#include <iostream>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdio.h>
#include <strings.h>
#include <cstdlib>
#include <stdlib.h>
#include <cstdio>
#include <unistd.h>
#define MAXHOSTNAME 256

#define PWM_MAX 65537

#define SERVO_DEFAULT 150000
#define SERVO_A_OFST 0
#define SERVO_B_OFST 0x4

#define LED_BASEINDEX 130

#define CTRL_OFST 0
#define PWM_A_OFST 0x4
#define PWM_B_OFST 0x10
#define SYNC_A_OFST 0x1C
#define SYNC_B_OFST 0x20

#define RUN_BIT 0
#define DIR_A_BIT 1
#define DIR_B_BIT 9
#define SYNC_BIT 7

using namespace std;

bool write_motor(FILE* fp, uint32_t ofst, uint32_t data);
bool write_servo(FILE* fp, uint32_t ofst, uint32_t data);

struct data_packet {
   uint32_t ctrl;
   uint32_t pwmA;
   uint32_t pwmB;
   uint32_t syncA;
   uint32_t syncB;
   uint32_t servoA;
   uint32_t servoB;
   uint32_t led;
};

main()
{
   struct sockaddr_in socketInfo;
   char sysHost[MAXHOSTNAME+1];  // Hostname of this computer we are running on
   struct hostent *hPtr;
   int socketHandle;
   int portNumber = 8765;
   FILE* motor_fp;
   FILE* servo_fp;
   FILE* led_fp[4];
   char led_filename[256];
   bool error = false;
   bool disconnected = true;
   int i = 0;
   int socketConnection;
   int rc = 0;  // Actual number of bytes read
   struct data_packet data;
   int recievedData = 0;
   bool ledBlink = true;
   
   motor_fp = fopen("/proc/motor_ctrl", "w");
   if(motor_fp == NULL) {
      printf("Cannot open /proc/motor_ctrl for write\n");
      return -1;
   }
   servo_fp = fopen("/proc/servo_ctrl", "w");
   if(servo_fp == NULL) {
      fclose(motor_fp);
      printf("Cannot open /proc/servo_ctrl for write\n");
      return -1;
   }
   for (i = 0; i < 4; i++)
   {
      sprintf(led_filename, "/sys/class/gpio/gpio%d/value", LED_BASEINDEX + i); 
      led_fp[i] = fopen(led_filename, "w");
      if(led_fp[i] == NULL) {
         fclose(motor_fp);
         fclose(servo_fp);
         printf("Cannot open %s for write\n", led_filename);
         return -1;
      }
   }
   for (i = 0; i < 4; i++)
   {
      fwrite("0", 1, 2, led_fp[i]);
      fflush(led_fp[i]);
   }
   bzero(&socketInfo, sizeof(sockaddr_in));  // Clear structure memory

   // Get system information

   gethostname(sysHost, MAXHOSTNAME);  // Get the name of this computer we are running on
	
   cout << "Host name: " << sysHost << endl;
   if((hPtr = gethostbyname(sysHost)) == NULL)
   {
      fwrite("1", 1, 2, led_fp[3]);
      fflush(led_fp[3]);
      fclose(motor_fp);
      fclose(servo_fp);
      for (i = 0; i < 4; i++)
      {
         fclose(led_fp[i]);
      }
      cerr << "System hostname misconfigured." << endl;
      exit(EXIT_FAILURE);
   }

   // create socket

         if((socketHandle = socket(AF_INET, SOCK_STREAM, 0)) < 0)
         {
            fwrite("1", 1, 2, led_fp[3]);
            fflush(led_fp[3]);
            fclose(motor_fp);
            fclose(servo_fp);
            for (i = 0; i < 4; i++)
            {
               fclose(led_fp[i]);
            }
            close(socketHandle);
            exit(EXIT_FAILURE);
         }

         cout << "Socket created!" << endl;
         // Load system information into socket data structures

         socketInfo.sin_family = AF_INET;
         socketInfo.sin_addr.s_addr = htonl(INADDR_ANY); // Use any address available to the system
         socketInfo.sin_port = htons(portNumber);      // Set port number

         // Bind the socket to a local socket address

         if( bind(socketHandle, (struct sockaddr *) &socketInfo, sizeof(socketInfo)) < 0)
         {
            fwrite("1", 1, 2, led_fp[3]);
            fflush(led_fp[3]);
            fclose(motor_fp);
            fclose(servo_fp);
            for (i = 0; i < 4; i++)
            {
               fclose(led_fp[i]);
            }
            close(socketHandle);
            perror("bind");
            exit(EXIT_FAILURE);
         }

         cout << "Socket bound!" << endl;

   while (!error)
   {
      if (disconnected)
      {
         listen(socketHandle, 1);
         cout << "Listen returned!" << endl;

         fwrite("1", 1, 2, led_fp[0]);
         fflush(led_fp[0]);
         if( (socketConnection = accept(socketHandle, NULL, NULL)) < 0)
         {
            fwrite("1", 1, 2, led_fp[3]);
            fflush(led_fp[3]);
            fclose(motor_fp);
            fclose(servo_fp);
            for (i = 0; i < 4; i++)
            {
               fclose(led_fp[i]);
            }
            exit(EXIT_FAILURE);
         }

         fputs("1", led_fp[1]);
         fflush(led_fp[1]);
         cout << "Socket Accepted!" << endl;
         //close(socketHandle);
         //cout << "Socket handle closed!" << endl;
         disconnected = false;
      }


   // rc is the number of characters returned.
   // Note this is not typical. Typically one would only specify the number 
   // of bytes to read a fixed header which would include the number of bytes
   // to read. See "Tips and Best Practices" below.

      //cout << "Waiting for packet..." << endl;
      recievedData = 0;
      while (recievedData != sizeof(data) && !error && !disconnected)
      {
         rc = recv(socketConnection, (&data) + recievedData, (sizeof(data) - recievedData), 0);
         if ( rc == 0 )
         {
              cout << "Socket closed" << endl;
              data.pwmA = 0;
              data.pwmB = 0;
              data.syncA = 1;
              data.syncB = 1;
              data.ctrl = 0;
              data.servoA = SERVO_DEFAULT;
              data.servoB = SERVO_DEFAULT;
              data.led = 0;
              //error = true;
              disconnected = true;
               for (i = 0; i < 4; i++)
               {
                  fwrite("0", 1, 2, led_fp[i]);
                  fflush(led_fp[i]);
                }
         }
         else if ( rc == -1 )
         {
              cout << "Socket error" << endl;
              perror("recv");
              close(socketConnection);
              data.pwmA = 0;
              data.pwmB = 0;
              data.syncA = 1;
              data.syncB = 1;
              data.ctrl = 0;
              data.servoA = SERVO_DEFAULT;
              data.servoB = SERVO_DEFAULT;
              data.led = 0;
              disconnected = true;
              //error = true;
               for (i = 0; i < 4; i++)
               {
                  fwrite("0", 1, 2, led_fp[i]);
                  fflush(led_fp[i]);
                }
         }
          else if( rc != (sizeof(data) - recievedData))
          {
              cout << "Partial message recieved, waiting for more" << endl;
          }
          recievedData += rc;
      }
      //cout << "Packet recieved: pwmA=" << data.pwmA << "pwmB=" << data.pwmB << " ctrl=" << data.ctrl << " servoA=" << data.servoA << " servoB=" << data.servoB << endl;
       write_motor(motor_fp, PWM_A_OFST, data.pwmA);
       write_motor(motor_fp, PWM_B_OFST, data.pwmB);
       write_motor(motor_fp, SYNC_A_OFST, data.syncA);
       write_motor(motor_fp, SYNC_B_OFST, data.syncB);
       write_motor(motor_fp, CTRL_OFST, data.ctrl);

       write_servo(servo_fp, SERVO_A_OFST, data.servoA);
       write_servo(servo_fp, SERVO_B_OFST, data.servoB);

       if (ledBlink)
       {
           ledBlink = false;
           fwrite("1", sizeof(char), 2, led_fp[2]);
           fflush(led_fp[2]);
       }
       else
       {     
           ledBlink = true;
           fwrite("0", sizeof(char), 2, led_fp[2]);
           fflush(led_fp[2]);
       }
   }

fclose(motor_fp);
fclose(servo_fp); 
for (i = 0; i < 4; i++)
{
    fclose(led_fp[i]);
}
}

bool write_motor(FILE* fp, uint32_t ofst, uint32_t data)
{
   uint32_t buf[2];
   size_t retVal;

   buf[0] = ofst;
   buf[1] = data;
   //cout << "writing " << buf[1] << " to offset " << buf[0] << endl;
   retVal = fwrite(buf, sizeof(uint32_t), 2, fp);
   fflush(fp);
   if (retVal != 2)
   {
      cout << "Motor control write failure! retVal=" << retVal << endl;
      return false;
   }   
   else
   {
      //cout << "motor control write completed!" << endl;
      return true;
   }
}

bool write_servo(FILE* fp, uint32_t ofst, uint32_t data)
{
   uint32_t buf[2];
   size_t retVal;

   buf[0] = ofst;
   buf[1] = data;
   //cout << "writing " << buf[1] << " to offset " << buf[0] << endl;
   retVal = fwrite(buf, sizeof(uint32_t), 2, fp);
   fflush(fp);
   if (retVal != 2)
   {
      cout << "Servo control write failure! retVal=" << retVal << endl;
      return false;
   }   
   else
   {
      //cout << "motor control write completed!" << endl;
      return true;
   }
}
   
          
