#include <Adafruit_BMP085.h>
#include <Wire.h>
#include <LiquidCrystal.h>

#define TIMER 500

LiquidCrystal lcd(8,9,10,11,12,13);

Adafruit_BMP085 bmp;

int switchPin = 5;
unsigned short usIndex = 0;
unsigned long ulTimer = 0;

void setup() {
  lcd.clear();
  lcd.begin(16,2);
  pinMode(switchPin, INPUT);
  digitalWrite(switchPin, HIGH);
  if (!bmp.begin())
  {
  lcd.setCursor(0,0);
  lcd.print("No Sensor Found!");
  while(true){}
  }
  ulTimer = millis();
}

void loop() {
  if (usBut_Status() == 1)
  {
    usIndex++;
  }
  
  if (usIndex == 0)
  {
    if ((millis() - ulTimer) >= TIMER)
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("Temperature:");
      lcd.setCursor(0,1);
      lcd.print(bmp.readTemperature());
      lcd.print("C");
      ulTimer = millis();
    }
  }
  else if (usIndex == 1)
  {
    if ((millis() - ulTimer) >= TIMER)
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("Pressure:");
      lcd.setCursor(0,1);
      lcd.print(bmp.readPressure());
      lcd.print("Pa");
      ulTimer = millis();
    }
  }
  else if (usIndex == 2)
  {
    if ((millis() - ulTimer) >= TIMER)
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("Altitude:");
      lcd.setCursor(0,1);
      lcd.print(bmp.readAltitude());
      lcd.print("m");
      ulTimer = millis();
    }
  }
  else if (usIndex == 3)
  {
    if ((millis() - ulTimer) >= TIMER)
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("sea-level pres:");
      lcd.setCursor(0,1);
      lcd.print(bmp.readPressure()*bmp.readAltitude()*0.0295333727);
      lcd.print("Pa");
      ulTimer = millis();
    }
  }
  else
  {
    usIndex = 0;
  }
}

unsigned short usBut_Status(void)
{
  if (digitalRead(switchPin) == 0)
  {
    while(digitalRead(switchPin) == 0);
    return 1;
  }
  else
  {
    return 0;
  }
}


