#include <SM.h>//state machine library
//#include <SPI.h>
//#include <Ethernet.h>
//#include "Mudbus.h"
//Mudbus Mb;
SM Master(&State10);//add & before the initial state on IDE 1.6.8 and above
SM Machine1(&State20);
SM Machine2(&State30);
SM Machine3(&State40);

int etat = 0;

void setup() {
  /*uint8_t mac[]     = { 0x90, 0xA2, 0xDA, 0x00, 0x51, 0x06 };
  uint8_t ip[]      = { 192, 168, 1, 8 };
  uint8_t gateway[] = { 192, 168, 1, 1 };
  uint8_t subnet[]  = { 255, 255, 255, 0 };*/
  //Ethernet.begin(mac, ip, gateway, subnet); //Avoid pins 0,4,5,6,7 when using ethernet shield on DIP40
  //delay(5000);  //Time to open the terminal
  //Serial.begin(9600); NO!! IF YOU USE tx d9 AS INPUT!!!!!

  //to use pin 18, 19, 20, 21 correctly as digital inputs and not with JTAG
  uint8_t tmp = 1 << JTD; // Disable JTAG
  MCUCR = tmp; // Disable JTAG
  MCUCR = tmp; // Disable JTAG

  pinMode(0, OUTPUT);
  pinMode(1, OUTPUT);
  pinMode(2, OUTPUT);
  pinMode(3, OUTPUT);
  pinMode(4, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT);
  pinMode(A0, OUTPUT);
  pinMode(A1, OUTPUT);
  //pinMode(15, OUTPUT);
  pinMode(A2, OUTPUT);
  DDRC = DDRC | B00000000;
  pinMode(8, INPUT);
  pinMode(9, INPUT);
  pinMode(10, INPUT);
  pinMode(11, INPUT);
  pinMode(12, INPUT);
  pinMode(13, INPUT);
  pinMode(14, INPUT);
  /*pinMode(16, INPUT);
    pinMode(17, INPUT);
    pinMode(18, INPUT);
    pinMode(19, INPUT);
    pinMode(20, INPUT);
    pinMode(21, INPUT);
    pinMode(22, INPUT);
    pinMode(23, INPUT);*/
  pinMode(A7, INPUT);
  pinMode(A6, INPUT);
  pinMode(A5, INPUT);
  //pinMode(A4, INPUT);
  pinMode(A3, INPUT);
}

void loop() {
  EXEC(Master);
  if (digitalRead(8) == LOW) {
    Machine1.Finish(); Machine2.Finish(); Machine3.Finish();
  }
  if ((digitalRead(8) == HIGH) && Machine1.Finished && Machine2.Finished && Machine3.Finished) {
    EXEC(Machine1);
    Machine1.Set(State20);
    EXEC(Machine2);
    Machine2.Set(State30);
    EXEC(Machine3);
    Machine3.Set(State40);
  }
}

//The Master machine////////////////////////////////////////////////
State State10() {
  digitalWrite(0, LOW);
  digitalWrite(1, LOW);
  digitalWrite(5, LOW);
  digitalWrite(A2, LOW);
  digitalWrite(2, LOW);
  analogWrite(15,0);
  if (digitalRead(8) == HIGH) Master.Set(State11);
}

State State11() {
  digitalWrite(2, HIGH);
  analogWrite(15,(analogRead(A4))/4);
  EXEC(Machine1);
  EXEC(Machine2);
  EXEC(Machine3);
  if (digitalRead(8) == LOW) Master.Set(State10);
}

//The Machine1////////////////////////////////////////////////////
State State20() {
  digitalWrite(0, LOW);
  if (Machine1.Timeout(300)) Machine1.Set(State21) ;
}
State State21() {
  digitalWrite(0, HIGH);
  if (Machine1.Timeout(500)) Machine1.Set(State20) ;
}

//The Machine2////////////////////////////////////////////////////////
State State30() {
  digitalWrite(1, LOW);
  if (Machine2.Timeout(700)) Machine2.Set(State31) ;
}
State State31() {
  digitalWrite(1, HIGH);
  if (Machine2.Timeout(700)) Machine2.Set(State30) ;
}

//The Machine3////////////////////////////////////////////////////////
State State40() {
  digitalWrite(5, LOW);
  digitalWrite(A2, LOW);
  if ((RE(digitalRead(9), etat) == 1)) Machine3.Set(State41) ;
}
State State41() {
  digitalWrite(5, HIGH);
  if ((digitalRead(A5) == HIGH))
    digitalWrite(A2, HIGH);
  else digitalWrite(A2, LOW);
  if ((RE(digitalRead(19), etat) == 1)) Machine3.Set(State40) ;
}

