#!/usr/bin/env python3
#
#########################################################################
#
# A CGI dispatcher to control the processes that run a timelapse script.
# originally written by Liam Fraser and modified by Makrtoolbox.
#
# Date: 2/20/2017
#
#########################################################################
#

import cgi
import subprocess
from pathlib import Path

#
# Prints a sub menu based on actions sent
#
def print_page(title, body):
    print("Content-Type: text/html")
    print()
    print("<html>\n<head><meta http-equiv=\"refresh\" content=\"60\">\n<title>{0}</title>\n</head>\n<body>\n<h1>{0}</h1>\n{1}\n</body>\n</html>\n".format(title, body))

#
# prints the main menu
#
def print_menu():
    title = "Raspberry Pi Timelapse Camera"
    cmd = "ls -t /var/www/html/images | head -1"
    img = subprocess.check_output(cmd, shell=True, universal_newlines=True)
    # Create the body including the output of a command if we ran one
    body = "<IMG SRC=\"images/{0}\" ALT=\"Image Captured\" WIDTH=640 HEIGHT=380><p><p><a href=\"index.cgi?action=tl_control\">Time Lapse Control</a></p>".format(img.strip("\n"))
    print_page(title, body)

#
# Prints the timelapse control menu and parses commands when an action is sent.
#
def tl_control(params):
    # Define output up here so it’s in the scope of the entire function 
    output = ""
    cmd = ""
    title = "Time Lapse Control"
    # Determine if the timelapse process is running
    #
    lockFile = Path("/var/www/html/cgi-bin/locks/tld.pid")
    if params.getvalue("tl_action"):
        action = params.getvalue("tl_action")
        if action == "Start Timelapse":
            # Prevent starting two instances on refresh
            if lockFile.exists() == False: 
                 subprocess.check_output(['sudo','/var/www/html/cgi-bin/tld','start'])
        elif action == "Stop Timelapse":
            if lockFile.exists():
                 subprocess.check_output(['sudo','/var/www/html/cgi-bin/tld','stop'])
    if lockFile.exists():
        button_string = "Stop Timelapse"
    else:
        button_string = "Start Timelapse"
    cmd = "ls -t /var/www/html/images | head -1"
    img = subprocess.check_output(cmd, shell=True, universal_newlines=True)
    # Create the body including the output of a command if we ran one
    body = "<form action=\"index.cgi\" method=\"post\"> <input type=\"hidden\" name=\"action\" value=\"tl_control\"> <input type=\"submit\" name=tl_action value=\"{0}\"></form><IMG SRC=\"images/{1}\" ALT=\"Image Captured\" WIDTH=640 HEIGHT=380><p><a href=\"images\">Review Images Captured</a></p>".format(button_string, img.strip("\n"))
    print_page(title, body)

#
# Main section of script.
#
if __name__ == "__main__":
    # Get any parameters
    params = cgi.FieldStorage()
    # Variable to keep track of if we have a valid input or not
    valid = False
    # If we have a key called action in the params
    if params.getvalue("action"):
        action = params.getvalue("action")
        if action == "tl_control":
            valid = True
            tl_control(params)
    if valid == False:
        print_menu()
