/******************************************************************************/
/* Files to Include                                                           */
/******************************************************************************/

#if defined(__XC)
    #include <xc.h>         /* XC8 General Include File */
#elif defined(HI_TECH_C)
    #include <htc.h>        /* HiTech General Include File */
#endif

#include <stdint.h>         /* For uint8_t definition */
#include <stdbool.h>        /* For true/false definition */

#include "user.h"

/******************************************************************************/
/* User Functions                                                             */
/******************************************************************************/

/* <Initialize variables in user.h and insert code for user algorithms.> */

void InitApp(void)
{
    /* TODO Initialize User Ports/Peripherals/Project here */
    // Set all pins as digital pins except RA0.
    ANS1 = 0; ANS2 = 0; ANS3 = 0; ANS4 = 0; ANS5 = 0; ANS6 = 0; ANS7 = 0;
    CM0 = 1; CM1 = 1; CM2 = 1;
    // Set TRIS to set RA0/AN0 as an input (high Z).
    TRISA0 = PIN_IS_IN;
    // Set TRIS so RA[1..2] are outputs. Data port for MAX7219
    TRISA1 = PIN_IS_OUT;
    TRISA2 = PIN_IS_OUT;
    // RC0 is the SPI clock output to the MAX7219s
    TRISC0 = PIN_IS_OUT;
    // RC3 to 5 are switch inputs
    TRISC3 = PIN_IS_IN;
    TRISC4 = PIN_IS_IN;
    TRISC5 = PIN_IS_IN;
    // Weak pullups on RA4, RA5.
    WPUA4 = 1;
    WPUA5 = 1;
    //RC1 is SDA (bi-dir), RC2 is SCL (output).
    TRISC1 = PIN_IS_OUT;  // Start as an output.
    TRISC2 = PIN_IS_OUT;
    // Set unused as outputs.
    TRISA3 = PIN_IS_IN;  // RA3 is an input-only pin.
    TRISA4 = PIN_IS_IN;
    TRISA5 = PIN_IS_IN;
    // Set MAX7219 data low, CS high, CLK low
    RA1 = 0;
    RA2 = 1;
    RC0 = 0;
    // SDA low -> high (=stop), SCL high
    RC1 = 0;  // SDA
    __delay_ms(1);
    RC2 = 0;  // SCL
    __delay_ms(1);
    RC2 = 1;  // SCL
    __delay_ms(1);
    RC1 = 1;
    // Doesn't matter, but set them to something.
    RA4 = 1;
    RA5 = 1;

    /* Setup analog functionality and port direction */
    // Make sure RA0/AN0 pin output driver is disabled via TRIS.
    // Set RA0/AN0 as an analog input.
    ANS0 = 1;
    // Set conversion clock to Fosc/16.  (Presumes a clock freq of 4MHz.)
    //     So conversion time is 11*4uSec max.  44 uSec typical.
    ADCS2 = 1;
    ADCS1 = 0;
    ADCS0 = 1;
    // Set Vref to VDD. Set VCFG bit in ADCON0 register = 0.
    VCFG = 0;
    // Set CHS bits of ADCON0 so that AN0 is routed to the sample/hold.
    CHS2 = 0;
    CHS1 = 0;
    CHS0 = 0;
    // Select data format for the ADC result.
    ADFM = 0;  // MS8-bit result in ADRESH. Ignore LS2bits in ADRESL.
    // Enable the ADC module.
    ADON = 1;
    __delay_ms(1);

    // Clear ADC INT flag
    // Disable ADC interrupt

    /* Initialize peripherals */

    /* Enable interrupts */
    // Disable all interrupts.
    // Disable peripheral interrupts.
    // Disable global interrupt
}

