#include <Arduino.h>
#include <ESP8266WiFi.h>          //https://github.com/esp8266/Arduino
#include <ESP8266HTTPClient.h>
#include <WiFiClientSecure.h>
#include <jled.h>
#include <ArduinoOTA.h>
#include "OTA.h"
// #include <FS.h>

//******************************Setup JLed Modes***************************************
JLed blink = JLed(LED_BUILTIN).Blink(500, 500).Forever().LowActive();
JLed breathe = JLed(LED_BUILTIN).Breathe(1600).Forever().LowActive();
JLed On = JLed(LED_BUILTIN).On().LowActive();
JLed Off = JLed(LED_BUILTIN).Off().LowActive();
//*************************************************************************************

// *************************** WiFi Setup **********************************************
// Home WiFi
 #define wifi_ssid  "WiFi_SSID"
 #define wifi_pass  "WiFi_Pass"

int wifiTimeout = 8000;
// *************************************************************************************

// **************************** IFTTT Setup ********************************************
String Key = "Your_IFTTT_Key";
String Firewood_Event = "Firewood_Event";
String Safety_Event = "No_Temp_Update";

WiFiClientSecure clientS;
const char* ifttthost =  "maker.ifttt.com";
const int httpsPort = 443;
// *************************************************************************************

// *********************************** Blynk Setup *************************************
#define BLYNK_PRINT Serial

#include <BlynkSimpleEsp8266.h>

char auth[] = "Your_Wood_Stove_Damper_Control_Auth_Token";
char temp_auth[] = "Your_Thermostat_Auth_Token";
WidgetBridge SetPointBridge(V24);
BlynkTimer Timer;

// *************************************************************************************

// ************************** PID Setup ***************************************
#include <PID_v1.h>

//Define Variables we'll be connecting to
double Setpoint, Input, Output;
long min_output = 0;
long max_output = 4166;

//Specify the links and initial tuning parameters
double Kp=250, Ki=2, Kd=0;
PID myPID(&Input, &Output, &Setpoint, Kp, Ki, Kd, DIRECT);
// ****************************************************************************

// ************************ Stepper Variables & Defaults***********************
// Easy Driver Output Pin Variables
#define DIR     D1
#define STP     D2
#define MS1     D3
#define MS2     D4
#define EN      D5
#define endstop D6

long count = 0;
long max_count = 4166;
long target_position;
long temp = 78;
long _setpoint = 78;

long currenttime = 0;

long home_time = 0;
long home_interval = 10;  // minutes
bool first_home = true;

long safety_timer = 0;
long safety_interval = 60; // seconds, how long without temperature signal
long safety_check_timer = 0;
long safety_check_int = 60; // seconds, how often to check and send trigger

long add_firewood_timer = 0;
long add_firewood_interval = 20;   // minutes 10
long firewood_print_timer = 0;
long firewood_print_interval = 10;    // minutes 3
bool first_max = true;

long current_damper_pos = 0;
long damper_position_threshold = 10;

bool reset_button_state = HIGH;
int reset_button_pin = D7;

// *****************************************************************************


//************************************* Setup File System ***********************************
// // flag for saving config parameters to SPIFFS
// bool shouldSaveConfig = false;

// // Custom Parameters for user to set and their default values - these default values show on Wifi Manager
// char param_1[40];  
// char param_2[40];
// char param_3[40];


// #include "File_System.h"
// ******************************************************************************************

#include "stepper_functions.h"
#include "Callbacks.h"
#include "functions.h"

BLYNK_CONNECTED() {
  Blynk.syncAll();
  SetPointBridge.setAuthToken(temp_auth);
}

void setup() {

  Serial.begin(115200);

  pinMode(DIR, OUTPUT);
  pinMode(STP, OUTPUT);
  pinMode(MS1, OUTPUT);
  pinMode(MS2, OUTPUT);
  pinMode(EN, OUTPUT);
  pinMode(endstop, INPUT_PULLUP);
  pinMode(reset_button_pin, INPUT_PULLUP);

  // SPIFFS.format();
  //Mount_SPIFFS();

  Input = temp;
  Setpoint = 78;
  myPID.SetOutputLimits(min_output, max_output);
  //turn the PID on
  myPID.SetMode(AUTOMATIC);

  Blynk.begin(auth, wifi_ssid, wifi_pass);

  OTA_Functions();
  SetPointBridge.virtualWrite(V4, _setpoint);
  Blynk.virtualWrite(V2, current_damper_pos);
}


void loop() {
  ArduinoOTA.handle();
  Blynk.run();
  currenttime = millis();
  myPID.Compute();
  Input = temp;
  Setpoint = _setpoint;
  
  if (!Blynk.connected()) {
    Serial.println("Wifi Disconnected");
    Off.Update();
    enable_stepper();
    home_stepper();
    disable_stepper();
    Blynk.virtualWrite(V2, 0);
    // Try to reconnect to preconfigured WiFi indefinitely (restarts module every 8s to refresh)
    ConnectWifi();
    first_home = true;
  } else {
    breathe.Update();
  }

  CheckButton();
  SafetyCheck();
  AddFirewood();
  }
