
/**
 * WigglePShape. 
 * 
 * How to move the individual vertices of a PShape
 */
 
 
 // Modification of the Processing example.


// A "Wiggler" object
Wiggler outer;
Wiggler inner;

float globalScale = 1;

int timeStart = 0;
int programLength = 6000;
int fadeLength = 2000;


void setup() {
  size(1280, 1024, P2D);

  outer = new Wiggler(400, 0, 40, 0);
  inner = new Wiggler(200, 0, 0, 0);

  timeStart = millis() + 0;

  noCursor();
 
}

void draw() {

  if (millis() < timeStart) {
    globalScale = 0;
  } else if (millis() - timeStart < fadeLength) {
    globalScale =  (1.0 * millis() - timeStart) / fadeLength;
  }
  if ( (timeStart + programLength) - millis() < fadeLength) {
    globalScale = 1.0 * (timeStart + programLength - millis()) / fadeLength;
  }

  if (millis() - timeStart > programLength + 500) {
    globalScale = 0;

  }

  background(0);
  outer.display();
  outer.wiggle();

  inner.display();
  inner.wiggle();
  
  fill(255);
  //text(frameRate,10,10);
  
  //if (frameCount < 180) {
  //  save("frames/frame" + String.format ("%03d", frameCount));
  //}
}

public void mousePressed() {
   timeStart = millis();
}

public void keyPressed() {
  delay(500);
  exit();
}