<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en" xmlns:fb="http://ogp.me/ns/fb#" >
<head>
<meta http-equiv="refresh" content="60">
<title>Arduino Test Bed</title>
<link rel="stylesheet" href="w3.css">
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Karma">
<link rel="stylesheet" href="bootstrap-switch.css">
 <!-- sources for the graph -->
<link href='graph.css' rel='stylesheet' type='text/css'>
<script src="http://d3js.org/d3.v3.js"></script>
<style type="text/css">
    dt, dd {
      display: block;
      float: left;
   }
    dt { 
      clear: both;
      width: 100px;
   }
</style>
<!-- end sources for the graph -->
<style>
body,h1,h2,h3,h4,h5,h6 {font-family: "Karma", sans-serif}
.w3-bar-block .w3-bar-item {padding:20px}
</style>

<script src="http://code.jquery.com/jquery-1.11.0.min.js"></script>
<script src="bootstrap-switch.js"></script>
<script type="text/javascript">
$("document").ready(function(){
  $(".js-ajax-options").submit(function(){		// Mock post the temperature value
    var data = {
      "action": "test"
    };
    data = $(this).serialize(); // + "&" + $.param(data);
    $.ajax({
      type: "POST",
      //dataType: "json",
      url: "data_store3.php", //Relative or absolute path to data_parser.php file
      data: data
    })
     .done(function(data) {
        $(".the-return").html(data);
        //alert("Form submitted successfully.\nReturned json: " + data["json"]);
      })
      .fail(function() {
      		alert( "Posting failed.");
      });
    
    return false;
  });
});

$("document").ready(function(){
	$("[name='ledcheckbox']").bootstrapSwitch();
	$('input[name="ledcheckbox"]').on('switchChange.bootstrapSwitch', function(event, state){
		console.log(state);
		if(state){
			$.post("cmd_store.php",{light:"on"},
			function(returnedData){
				console.log(returnedData);
			});
		}else{
			$.post("cmd_store.php",{light:"off"},
			function(returnedData){
				console.log(returnedData);
			});
		}
	});
});

$("document").ready(function(){
	$("[name='motioncheckbox']").bootstrapSwitch();
	$('input[name="motioncheckbox"]').on('switchChange.bootstrapSwitch', function(event, state){
		console.log(state);
	});
});
</script>

<?php
	$file = 'temp.txt';
	date_default_timezone_set('Australia/Melbourne');
	if (file_exists($file)){
		$tempdata = file_get_contents($file);
		$lastmodified = "Last captured: ".date ("d-M-y h:i:s. A", filemtime($file));
	}
?>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
      google.charts.load('current', {'packages':['gauge']});
      google.charts.setOnLoadCallback(drawChart);
     function drawChart() {

        var data = google.visualization.arrayToDataTable([
          ['Label', 'Value'], 
          ['Temp', 
<?php    
    echo $tempdata;
?>        
          ],]);
  // setup the google chart options here
  // width: 400, height: 120,
      var options = {
       
        redFrom: 35, redTo: 100,
        yellowFrom: 0, yellowTo: 15,
        greenFrom: 16, greenTo: 34,
         minorTicks: 5    };
     var chart = new google.visualization.Gauge(document.getElementById('chart_div'));

    chart.draw(data, options);

 	function resizeHandler () {
        chart.draw(data, options);
    }
    if (window.addEventListener) {
        window.addEventListener('resize', resizeHandler, false);
    }
    else if (window.attachEvent) {
        window.attachEvent('onresize', resizeHandler);
    }
    
    setInterval(function() {
    data.setValue(0, 1, 
<?php    
    echo $tempdata;
?> 
	);
    chart.draw(data, options);
      }, 13000);

    }
</script>
<?php
  
  // this script is a webapp for mobile browsers.
  // it gets data from the sqlite database and shows the user things like the current temperature at home.
  // if the users sets a new goal temperature, it is passed on to setThermostat.php.
   class MyDB extends SQLite3
   {
      function __construct()
      {
         $this->open('temperature.db');
      }
   }
   $db = new MyDB();
   if(!$db){
      echo $db->lastErrorMsg();
      exit;
   } else {
      // echo "Opened database successfully\n";
   }

   $sql ="SELECT * from temperature ORDER BY ID DESC LIMIT 1";

   $ret = $db->query($sql);
   while($row = $ret->fetchArray(SQLITE3_ASSOC) ){
      $temperature = $row['temperature'];
      $humidity = $row['humidity'];
      $heater = $row['heater'];
      $timestamp = $row['timestamp'];
      $goaltemp = $row['goaltemp'];
   }

    // get temperature data from last 24 hours
    // source: https://nyquist212.wordpress.com/2014/03/28/example-to-connect-to-sqlite-with-php-and-return-json/
    // Iterate through the results and pass into JSON encoder
   $sql ="SELECT timestamp, temperature from temperature ORDER BY ID DESC LIMIT 1440";
   $ret = $db->query($sql);
   while($row = $ret->fetchArray(SQLITE3_ASSOC) ){
      $temperaturedata24hr[]= $row;
    }
 	foreach($temperaturedata24hr as $anArray => &$timestamp){
 		$theDate = new DateTime($timestamp['timestamp'], new DateTimeZone('UTC'));
 		$theDate->setTimezone(new DateTimeZone('Australia/Melbourne'));
 		//print $theDate->format('Y-m-d H:i:s');
 		$timestamp['timestamp'] = $theDate->format('Y-m-d H:i:s');
 	}
    $temperaturedata24hr = json_encode($temperaturedata24hr);
	
   $db->close();
?>

</head>

<body>

<!-- !PAGE CONTENT! -->
<div class="w3-main w3-content w3-padding" style="max-width:1200px;margin-top:100px">

<!-- First Photo Grid-->
  <div class="w3-row-padding w3-padding-16 w3-center" id="food">
  	<div class="w3-quarter">
  	<!--// below is the google chart html-->
	<!--<div id="chart_div" style="width: 300px; height: 120px;"></div>-->
	<h3>Temperature Sensor</h3>
	<div id="chart_div" style="width: 100%; height: 100%;"></div>
	<p>
<?php
	echo $lastmodified;
?> 	</p>
	</div>
	
	<div class="w3-quarter">
	<h3>Motion Sensor</h3>

		<?php
			$content = file_get_contents("motionsensor.json");
			$json_array = json_decode($content, true);
			//echo $json_array["motion"];
		?>
		  <input type="checkbox" name="motioncheckbox" data-size="small" readonly=true
													<?php 
														if ($json_array["motion"]=="true") 
															echo "checked";
													 ?>
		  >
	<p></p>

	</div>
	<div class="w3-quarter">
	<h3>Control Panel</h3>
		<!--Put the following in the <body>-->
		<?php
			$content = file_get_contents("light.json");
			$json_array = json_decode($content, true);
			//echo $json_array["light"];
		?>
		  <input type="checkbox" name="ledcheckbox" data-size="small" 
													<?php 
														if ($json_array["light"]=="on") 
															echo "checked";
													 ?>
		  >
	<p>Turn LED ON/OFF</p>
	</div>
	 <div class="w3-quarter">
      <h3>Debug</h3>
		<form action="ArduinoData3.php" class="js-ajax-options" method="post" accept-charset="utf-8">
		  <input type="text" name="temp_sensor" value="15" placeholder="Temp Sensor" />
		  <input type="submit" name="submit" value="Update"  />
		</form>
		<p>
		<div class="the-return">
		  [HTML is replaced when successful.]
		</div>
		</p>
    </div> 
  </div>
	<div style="clear: both;">

    <!-- 
    // showing a D3 responsive graph of the temperature in the last 24 hours 
    // source: https://www.safaribooksonline.com/blog/2014/02/17/building-responsible-visualizations-d3-js/
    -->
    <svg id="graph" viewBox="0 0 800 310" preserveAspectRatio="xMidYMid"></svg>

    <script>

    var margin = 40,
        width = 800 - margin*2,
        height = 310 - margin*2;

    var xScale = d3.time.scale()
        .range([0, width])
        .nice(d3.time.day);

    var yScale = d3.scale.linear()
        .range([height, 0])
        .nice();

    var xAxis = d3.svg.axis()
        .scale(xScale)
        .orient("bottom");

    var yAxis = d3.svg.axis()
        .scale(yScale)
        .orient("left");

    var line = d3.svg.line()
        .x(function(d) { return xScale(d.date); })
        .y(function(d) { return yScale(d.temperature); });

    var graph = d3.select("#graph")
        .attr("width", width + margin*2)
        .attr("height", height + margin*2)
        .append("g")
        .attr("transform", "translate(" + margin + "," + margin + ")");

      var data = '<?php print $temperaturedata24hr; ?>';

      data = JSON.parse( data );

      data.forEach(function(d) {
        d.date = d3.time.format("%Y-%m-%d %H:%M:%S").parse(d.timestamp); // 2016-01-17 19:46:01
        d.temperature = +d.temperature;
      });



      xScale.domain(d3.extent(data, function(d) { return d.date; }));
      yScale.domain(d3.extent(data, function(d) { return d.temperature; }));

      graph.append("g")
          .attr("class", "x axis")
          .attr("transform", "translate(0," + height + ")")
          .call(xAxis);

      graph.append("g")
          .attr("class", "y axis")
          .call(yAxis)
        .append("text")
          .attr("transform", "rotate(-90)")
          .attr("y", 6)
          .attr("dy", ".71em")
          .style("text-anchor", "end")
          .text("Temperature (C)");

      graph.append("path")
          .datum(data)
          .attr("class", "line")
          .attr("d", line);

    </script>

   </div>
  <!-- Second Photo Grid
  <div class="w3-row-padding w3-padding-16 w3-center">
    <div class="w3-quarter">
      <img src="/w3images/popsicle.jpg" alt="Popsicle" style="width:100%">
      <h3>All I Need Is a Popsicle</h3>
      <p>Lorem ipsum text praesent tincidunt ipsum lipsum.</p>
    </div>
    <div class="w3-quarter">
      <img src="/w3images/salmon.jpg" alt="Salmon" style="width:100%">
      <h3>Salmon For Your Skin</h3>
      <p>Once again, some random text to lorem lorem lorem lorem ipsum text praesent tincidunt ipsum lipsum.</p>
    </div>
    <div class="w3-quarter">
      <img src="/w3images/sandwich.jpg" alt="Sandwich" style="width:100%">
      <h3>The Perfect Sandwich, A Real Classic</h3>
      <p>Just some random text, lorem ipsum text praesent tincidunt ipsum lipsum.</p>
    </div>
    <div class="w3-quarter">
      <img src="/w3images/croissant.jpg" alt="Croissant" style="width:100%">
      <h3>Le French</h3>
      <p>Lorem lorem lorem lorem ipsum text praesent tincidunt ipsum lipsum.</p>
    </div>
  </div>	-->
<!-- End page content -->
</div>

</body></html>
