/*
   Looks for and discards the accents in weather description
*/
void LookForAccents (char Text[], int TextLength) {
  byte i = 0;
  do {
    char c = Text[i];
    if ((int)c == 195) {
      char c2 = Text[i + 1];
      switch ((int)c2) {
        case 160 ... 166:
          Text[i] = 'a';
          break;
        case 167:
          Text[i] = 'c';
          break;
        case 168 ... 171:
          Text[i] = 'e';
          break;
        case 172 ... 175:
          Text[i] = 'i';
          break;
        case 177:
          Text[i] = 'n';
          break;
        case 178 ... 182:
          Text[i] = 'o';
          break;
        case 185 ... 188:
          Text[i] = 'u';
          break;
        case 189 ... 191:
          Text[i] = 'y';
          break;
        case 128 ... 134:
          Text[i] = 'A';
          break;
        case 135:
          Text[i] = 'C';
          break;
        case 136 ... 139:
          Text[i] = 'E';
          break;
        case 140 ... 143:
          Text[i] = 'I';
          break;
        case 146 ... 150:
          Text[i] = 'O';
          break;
        case 153 ... 156:
          Text[i] = 'U';
          break;
        default:
          break;
      }
      for (byte j = i + 1; j < TextLength; j++) Text[j] = Text[j + 1];
      TextLength --;
    }
    i++;
  } while (i < TextLength);
}

/*
   Display current weather on serial monitor
*/
void AfficheCurrent () {
  Serial.println ("Meteo :");
  Serial.printf ("Description :\t\t%s\n", current_weather_description);
  //  Serial.print ("Icon :\t\t\t");       Serial.println(current_weather_icon);
  Serial.printf ("Code :\t\t\t%d\n", current_condition_code);
  Serial.printf ("Temperature :\t\t%4.1f\n", current_temp);
  Serial.printf ("Pression :\t\t%4.1f\n", current_pressure, 1);
  Serial.printf ("Tendance :\t\t%d\n", tendency_pressure);
  Serial.printf ("Precipitations :\t%4.1f mm\n", current_precip_mm);
  Serial.printf ("Humidite :\t\t%d %%\n", current_humidity);
  //  Serial.printf ("Indice UV :\t\t%4.1f\n", current_uv);
  Serial.println (" ");
}
/*
   Display forecast (current time + H hours) on serial monitor
*/
void AfficheHourly (int H) {
  Serial.printf ("Dans %d heure(s) :\n", hourlyHours[H] + 1);
  Serial.printf ("   Description :\t%s\n", hourly_weather_description[H]);
  Serial.printf ("   Icon :\t\t%d\n", hourly_weather_icon[H]);
  Serial.printf ("   Temperature :\t%4.1f\n", hourly_temp[H]);
  Serial.printf ("   Chance de pluie :\t%d %%\n", hourly_PreciProba[H]);
  Serial.println(" ");
}
/*
   Display forecast (current day + D days) on serial monitor
*/
void AfficheDaily (int D) {
  Serial.printf ("Jour + %d\n", D + 1);
  //  Serial.printf ("   Date :\t\t%s\n", daily_date[D]);
  Serial.printf ("   Temp min :\t\t%4.1f\n", daily_mintemp[D]);
  Serial.printf ("   Temp max :\t\t%4.1f\n", daily_maxtemp[D]);
  Serial.printf ("   Precipitations :\t%4.1f mm\n", daily_Precip[D]);
  //  Serial.printf ("   Conditions :\t\t%s\n", daily_weather_description[D]);
  //  Serial.printf ("   Icone :\t\t%s\n", daily_weather_icon[D]);
  Serial.printf ("   Code :\t\t%d\n", daily_condition_code[D]);
  //  Serial.printf ("   Lever du soleil :\t%s\n", daily_sunrise[D]);
  //  Serial.printf ("   Coucher du soleil :\t%s\n", daily_sunset[D]);
  Serial.println(" ");
}
/*
   Compute pressure tendency : 0 = falling, 1 = flat, 2 = rising
*/
byte PressureTendency () {
  byte Tendency = 1;
  if (memory_pressure[0] < memory_pressure[1] && memory_pressure[1] < memory_pressure[2])
    Tendency = 2;
  if (memory_pressure[0] > memory_pressure[1] && memory_pressure[1] > memory_pressure[2])
    Tendency = 0;
  return Tendency;
}
/*
   Get current weather using Apixu API
*/
void GetCurrentMeteo () {
  String payload;
  HTTPClient http;
  http.begin(CurrentW CityName Cparams Apixu_key); // Meteo courante
  int httpCode = http.GET();  // Make the request
  if (httpCode > 0) { // Check for the returning code
    payload = http.getString();
  } else Serial.println("Error on HTTP request");
  http.end(); //Free the resources
  if (httpCode == 200) {
    // JSON parse
    const size_t bufferSize = JSON_OBJECT_SIZE(2) + JSON_OBJECT_SIZE(3) + JSON_OBJECT_SIZE(7) + JSON_OBJECT_SIZE(8) + 500; //360;
    DynamicJsonBuffer jsonBuffer(bufferSize);
    JsonObject& root = jsonBuffer.parseObject(payload);
    JsonObject& current = root["current"];
    current_temp = current["temp_c"];
    //    int current_is_day = current["is_day"];
    JsonObject& current_condition = current["condition"];
    const char* description = current_condition["text"];
    for (int i = 0; i < NumCar; i++) current_weather_description[i] = *(description + i);
    LookForAccents (current_weather_description, strlen(current_weather_description));
    //    current_weather_icon = current_condition["icon"];
    current_condition_code = current_condition["code"];
    current_pressure = current["pressure_mb"];
    current_precip_mm = current["precip_mm"];
    current_humidity = current["humidity"];
    //    current_uv = current["uv"];
    AfficheCurrent ();
    // Store pressure in array for tendancy
    if (bootCount == 1) {
      memory_pressure[0] = current_pressure;
      memory_pressure[1] = current_pressure;
    } else {
      memory_pressure[0] = memory_pressure[1];
      memory_pressure[1] = memory_pressure[2];
    }
    memory_pressure[2] = current_pressure;
    tendency_pressure = PressureTendency ();
    return;
  }
  Serial.println ("Apixu Weather problem: maximum number of requests exceeded!");
}
/*
   Get hourly forecast using Accuweather API
*/
void GetHourlyForecast () {
  String payload;
  HTTPClient http;
  //http.begin("http://dataservice.accuweather.com/forecasts/v1/hourly/12hour/133686?apikey=V50nGaDSLQ1RFZTqQQGGA8sCYrJEdUbv&language=fr-fr&metric=true");
  String command = Hforecast cityCode API_key Accu_key WparamsS Metrics;
  http.begin(command);
  int httpCode = http.GET();  // Make the request
  if (httpCode > 0) { // Check for the returning code
    payload = http.getString();
  } else Serial.println("Error on HTTP request");
  http.end(); //Free the resources

  if (httpCode == 200) {
    // JSON parse
    const size_t bufferSize = JSON_ARRAY_SIZE(12) + 12 * JSON_OBJECT_SIZE(3) + 12 * JSON_OBJECT_SIZE(9) + 6000; //5500;
    DynamicJsonBuffer jsonBuffer(bufferSize);
    JsonArray& root = jsonBuffer.parseArray(payload);
    JsonArray& root_ = root;

    Serial.println ("\nPrevision horaires");
    for (int i = 0; i < nbHourForecast; i++) {
      byte index = hourlyHours[i];
      JsonObject& hourly = root_[index];
      hourly_weather_icon[i] = hourly["WeatherIcon"];
      //      hourly_weather_description[i] = hourly["IconPhrase"];
      const char* description = hourly["IconPhrase"];
      for (int j = 0; j < NumCar; j++) hourly_weather_description[i][j] = *(description + j);
      LookForAccents (hourly_weather_description[i], strlen(hourly_weather_description[i]));
      JsonObject& hourly_Temperature = hourly["Temperature"];
      hourly_temp[i] = hourly_Temperature["Value"];
      hourly_PreciProba[i] = hourly["PrecipitationProbability"];
      AfficheHourly (i);
    }
  } else Serial.println ("AccuWeather problem: maximum number of requests exceeded!");
}
/*
   Get daily forecast for 3 next days using Apixu APi
*/
void GetDailyForecast () {
  String payload;
  HTTPClient http;
  http.begin(Dforecast Apixu_key Fparams CityName); // Prévisions à 3 jours
  int httpCode = http.GET();  // Make the request
  if (httpCode > 0) { // Check for the returning code
    payload = http.getString();
  } else Serial.println("Error on HTTP request");
  http.end(); //Free the resources

  if (httpCode == 200) {
    // JSON parse
    const size_t bufferSize = JSON_ARRAY_SIZE(3) + JSON_OBJECT_SIZE(1) + 3 * JSON_OBJECT_SIZE(2) + 8 * JSON_OBJECT_SIZE(3) + 3 * JSON_OBJECT_SIZE(4) + JSON_OBJECT_SIZE(7) + JSON_OBJECT_SIZE(8) + 1500; //1040;
    DynamicJsonBuffer jsonBuffer(bufferSize);
    JsonObject& root = jsonBuffer.parseObject(payload);
    JsonArray& forecast_forecastdays = root["forecast"]["forecastday"];

    Serial.println ("\nPrevisions journalieres :");
    for (int i = 0; i < nbDayForecast; i++) {
      JsonObject& forecast_forecastday = forecast_forecastdays[i];
      //      const char* description = forecast_forecastday["date"];
      //      for (int j = 0; j < NumCar; j++) daily_date[i][j] = *(description + j);

      JsonObject& forecast_forecastday_day = forecast_forecastday["day"];
      daily_maxtemp[i] = forecast_forecastday_day["maxtemp_c"]; // 12.9
      daily_mintemp[i] = forecast_forecastday_day["mintemp_c"]; // 12.1
      daily_Precip[i] = forecast_forecastday_day["totalprecip_mm"]; // 10.5

      JsonObject& forecast_forecastday_day_condition = forecast_forecastday_day["condition"];
      //      description = forecast_forecastday_day_condition["text"];
      //      for (int j = 0; j < NumCar; j++) daily_weather_description[i][j] = *(description + j);
      //      LookForAccents (daily_weather_description[i], strlen(daily_weather_description[i]));
      //      description = forecast_forecastday_day_condition["icon"];
      //      for (int j = 0; j < NumCar; j++) daily_weather_icon[i][j] = *(description + j);
      daily_condition_code[i] = forecast_forecastday_day_condition["code"]; // 1183
      //      JsonObject& forecast_forecastday_astro = forecast_forecastday["astro"];
      //      description = forecast_forecastday_astro["sunrise"];
      //      for (int j = 0; j < NumCar; j++) daily_sunrise[i][j] = *(description + j);
      //      description = forecast_forecastday_astro["sunset"];
      //      for (int j = 0; j < NumCar; j++) daily_sunset[i][j] = *(description + j);
      AfficheDaily (i);
    }
  } else Serial.println ("Apixu Weather problem: maximum number of requests exceeded!");
}

