/*
     All libraries, connections, global variables and
    variables to store in RTC RAM before deep sleep
*/
#define DEBUG 1 // 1 for debug, 0 if not
#define Serial if(DEBUG)Serial
#include <Arduino.h>

// Pin definitions
// I2C Bus : accelerometer
#define SDA 33 //21
#define SCL 32 //22
// INT is connected to GPIO34

/*
     Temperature sensor (DHT22)
     Connects to VCC, GND, pin 25
*/
#define DHT_PIN 25
#include "DHTesp.h"
DHTesp dht;

/*
 *  Voltage measurement pins
 */
#define CTRL_PIN 26
#define MES_PIN 35
RTC_DATA_ATTR float oldVoltage = 0;

// Sleep variables (to be stored in RTC RAM)
RTC_DATA_ATTR int bootCount = 0;
RTC_DATA_ATTR static byte wifiNumber = 255; // Which wifi to connect to
RTC_DATA_ATTR byte Orientation;

// Internet
#include <WiFi.h>
#include <HTTPClient.h>
#define WIFITIMEOUT 7000ul // ms
const byte NetworksNumber = 3;
const char* ssid[NetworksNumber]     = {"***", "***", "***"};
const char* password[NetworksNumber] = {"***", "***", "***"};

// Time
//#include "time.h"
#include <sys/time.h>
#define GMT 1 // for GMT + 1
RTC_DATA_ATTR time_t now;
RTC_DATA_ATTR struct tm * timeinfo;

// Weather
#include "ArduinoJson.h"
// Apixu : current weather
#define CurrentW  "https://api.apixu.com/v1/current.json?q="
#define CityName  "Massy"
#define Cparams   "&lang=fr&key="
#define Apixu_key "your key here"
// Accuweather : hourly forecast
// Massy = 133686 (http://dataservice.accuweather.com/locations/v1/search?q=massy&apikey=V50nGaDSLQ1RFZTqQQGGA8sCYrJEdUbv)
#define cityCode  "133686"
#define Hforecast "http://dataservice.accuweather.com/forecasts/v1/hourly/12hour/"
#define Accu_key  "your key here"
#define API_key   "?apikey="
#define WparamsS  "&language=fr-fr"
#define Metrics   "&metric=true"
// Apixu : daily forecast
#define Dforecast "https://api.apixu.com/v1/forecast.json?key="
#define Fparams   "&days=4&lang=fr&q="

// Current weather (Apixu)
#define NumCar 60
RTC_DATA_ATTR char current_weather_description[NumCar];
RTC_DATA_ATTR float current_temp;
RTC_DATA_ATTR float current_pressure;
RTC_DATA_ATTR float memory_pressure[3];
RTC_DATA_ATTR byte tendency_pressure;
// RTC_DATA_ATTR const char* current_PressureTendency_Code;
// RTC_DATA_ATTR const char* current_weather_icon;
RTC_DATA_ATTR int current_condition_code;
RTC_DATA_ATTR float current_precip_mm;
RTC_DATA_ATTR int current_humidity;
// RTC_DATA_ATTR float current_uv;

// Hourly forecast (Accuweather)
#define nbHourForecast 6
RTC_DATA_ATTR byte hourlyHours[nbHourForecast] = {0, 1, 2, 5, 8, 11};
RTC_DATA_ATTR char hourly_weather_description[nbHourForecast][NumCar];
RTC_DATA_ATTR float hourly_temp[nbHourForecast];
RTC_DATA_ATTR int hourly_weather_icon[nbHourForecast];
RTC_DATA_ATTR int hourly_PreciProba[nbHourForecast];

// Daily forecast (Apixu)
#define nbDayForecast 4
//RTC_DATA_ATTR char daily_weather_description[nbDayForecast][NumCar];
//RTC_DATA_ATTR char daily_weather_icon[nbDayForecast][NumCar];
RTC_DATA_ATTR int daily_condition_code[nbDayForecast];
//RTC_DATA_ATTR char daily_date[nbDayForecast][NumCar];
RTC_DATA_ATTR float daily_mintemp[nbDayForecast];
RTC_DATA_ATTR float daily_maxtemp[nbDayForecast];
RTC_DATA_ATTR float daily_Precip[nbDayForecast];
//RTC_DATA_ATTR char daily_sunrise[nbDayForecast][NumCar];
//RTC_DATA_ATTR char daily_sunset[nbDayForecast][NumCar];

/*
   List of weather icon files stored in SPiFFS
*/
struct icon
{
  int ApixuCode;
  int AccuweatherCode;
  char *DayIcon;
  char *NightIcon;
};

struct icon iconList[]
{
  1000,  1, "sunny", "nt_sunny",
  1003, 99, "partlycloudy", "nt_partlycloudy",
  1006, 99, "cloudy", "nt_partlysunny",
  1030,  5, "hazy", "nt_hazy",
  1063, 99, "chancerain", "nt_chancerain",
  1066, 23, "chancesnow", "nt_chancesnow",
  1069, 25, "chancesleet", "nt_chancesleet",
  1072, 20, "chanceflurries", "nt_chanceflurries",
  1087, 17, "chancetstorms", "nt_chancetstorms",
  1114, 99, "chancesnow", "nt_chancesnow",
  1117, 22, "snow", "nt_snow",
  1135, 11, "fog", "nt_fog",
  1147, 99, "fogsnow", "fogsnow",
  1150, 20, "chancerain", "nt_chancerain",
  1153, 99, "chancerain", "nt_chancerain",
  1168, 19, "flurries", "nt_flurries",
  1171, 99, "flurries", "nt_flurries",
  1180, 99, "cloudychancerain", "nt_cloudychancerain",
  1183, 99, "chancerain", "nt_chancerain",
  1186, 13, "cloudychancerain", "nt_cloudychancerain",
  1189, 99, "chancerain", "nt_chancerain",
  1192, 14, "mostlycloudyrain", "nt_mostlycloudyrain",
  1195, 12, "rain", "nt_rain",
  1198, 99, "flurries", "nt_flurries",
  1201, 99, "flurries", "nt_flurries",
  1204, 26, "chancesleet", "nt_chancesleet",
  1207, 25, "sleet", "nt_sleet",
  1210, 24, "chancesnow", "nt_chancesnow",
  1213, 99, "chancesnow", "nt_chancesnow",
  1216, 99, "moderatesnow", "nt_moderatesnow",
  1219, 99, "snow", "nt_snow",
  1222, 99, "moderatesnow", "nt_moderatesnow",
  1225, 99, "snow", "nt_snow",
  1237, 99, "chancesnow", "nt_chancesnow",
  1240, 99, "cloudychancerain", "nt_cloudychancerain",
  1243, 16, "mostlycloudyrain", "nt_mostlycloudyrain",
  1246, 18, "rain", "nt_rain",
  1249, 99, "chancesleet", "nt_chancesleet",
  1252, 99, "sleet", "nt_sleet",
  1255, 99, "moderatesnow", "nt_moderatesnow",
  1258, 99, "moderatesnow", "nt_moderatesnow",
  1261, 99, "moderatesnow", "nt_moderatesnow",
  1264, 99, "moderatesnow", "nt_moderatesnow",
  1273, 99, "chancetstorms", "nt_chancetstorms",
  1276, 15, "tstorms", "nt_tstorms",
  1279, 29, "lightsnowthunder", "nt_lightsnowthunder",
  1282, 99, "tstormsnow", "tstormsnow",
  9999,  2, "clear", "nt_clear",
  9999,  3, "mostlysunny", "nt_mostlysunny",
  9999,  4, "partlysunny", "nt_partlysunny",
  9999,  6, "mostlycloudy", "nt_mostlycloudy",
  9999,  7, "cloudy", "nt_cloudy",
  9999,  8, "overcast", "overcast",
  9999, 21, "chanceflurries", "nt_chanceflurries",
  9999, 30, "hot", "hot",
  9999, 31, "cold", "cold",
  9999, 32, "wind", "wind",
  9999, 33, "sunny", "nt_sunny",
  9999, 34, "clear", "nt_clear",
  9999, 35, "mostlysunny", "nt_mostlysunny",
  9999, 36, "partlysunny", "nt_partlysunny",
  9999, 37, "hazy", "nt_hazy",
  9999, 38, "cloudychancerain", "nt_cloudychancerain",
  9999, 39, "mostlycloudyrain", "nt_mostlycloudyrain",
  9999, 40, "mostlycloudyrain", "nt_mostlycloudyrain",
  9999, 41, "mostlycloudyrain", "nt_mostlycloudyrain",
  9999, 42, "chancetstorms", "nt_chancetstorms",
  9999, 43, "chancerain", "nt_chancerain",
  9999, 44, "chancesnow", "nt_chancesnow",
  0, 0,
};

/*
    Accelerometer (MPU6050)
    Connects to VCC, GND, SDA2, SCL2, INT to GPIO 34 (see GoodNight function)
*/
#include <Wire.h>
#include "I2Cdev.h"
#include "MPU6050.h"
MPU6050 accelgyro;
RTC_DATA_ATTR static byte OrientationOld = 10;
enum Direction {Xplus, Xmoins, Yplus, Ymoins, Zplus, Zmoins, Unknown};
bool sameOrientation = false;

// Displays
#include "SPIFFS.h"
#include <FS.h>
#define FileClass fs::File

#include <GxEPD2_BW.h>
//#include <Fonts/Arimo_Bold_10.h>
#include <Fonts/Open_Sans_ExtraBold_12.h>
#include <Fonts/Open_Sans_ExtraBold_14.h>
#include <Fonts/Open_Sans_ExtraBold_16.h>
#include <Fonts/Open_Sans_ExtraBold_22.h>
#include <Fonts/Lato_Semibold_22.h>
#include <Fonts/Open_Sans_ExtraBold_30.h>
#include <Fonts/Open_Sans_ExtraBold_50.h>
#include <Fonts/Open_Sans_ExtraBold_60.h>
#include <Fonts/Open_Sans_ExtraBold_90.h>
#include <Fonts/Open_Sans_ExtraBold_120.h>

// Citations
#define sizeCitation 225
#define sizeAuthor 30
#define maxNbCitations 11
RTC_DATA_ATTR char Citation[maxNbCitations][sizeCitation] = {0};
RTC_DATA_ATTR char Author[maxNbCitations][sizeAuthor] = {0};
RTC_DATA_ATTR byte totalCitNb = 0;
RTC_DATA_ATTR char Ephemeride[40];

/*
   Connexions
             grand   petit
      BUSY    22       4
      RES     16      16
      D/C     17      17
      CS      19       5
      SCK     18      18
      SDI     23      23
      GND     GND     GND
      3V3     3V      3V
*/
#define RST_PIN 16
#define CS_p 5
#define CS_g 19
#define BUSY_p 4
#define BUSY_g 22

GxEPD2_BW<GxEPD2_290_T5, GxEPD2_290_T5::HEIGHT> petit(GxEPD2_290_T5(/*CS=*/ CS_p, /*DC=*/ 17, /*RST=*/ 16, /*BUSY=*/ BUSY_p));
GxEPD2_BW<GxEPD2_420, GxEPD2_420::HEIGHT> grand(GxEPD2_420(/*CS=*/ CS_g, /*DC=*/ 17, /*RST=*/ 16, /*BUSY=*/ BUSY_g));

/*
   Remark : set TP0B to 20 on line 585 of file WaveTables.h
   in C:\Users\yourname\Documents\Arduino\libraries\GxEPD2\src
*/
