#include "Variables.h"
#include "Weather.h"
#include "Bonus.h"
#include "Displays.h"
#include "Accelero.h"
#include "Internet.h"
#include "Sleep.h"
#include "soc/soc.h"
#include "soc/rtc_cntl_reg.h"

void setup() {
  WRITE_PERI_REG(RTC_CNTL_BROWN_OUT_REG, 0); //disable brownout detector
  unsigned long WakeUpInstant = millis();
  pinMode (CTRL_PIN, OUTPUT);
  Serial.begin(115200);
  Serial.println ("Waking up");
  if (!SPIFFS.begin(true)) {
    Serial.println("An Error has occurred while mounting SPIFFS");
    return;
  }
  // Init for _first use_ then go to sleep
  if (bootCount == 0) FirstInit (WakeUpInstant);
  // Goes to sleep so nothing executed after that

//  bootCount++;
  WhatTime ();
  // Get reason for wakeup (1 : accelero, 3 : timer)
  byte WakeupReason = wakeup_reason();
  if (WakeupReason == 3) updateTime ();
  unsigned long epoch0 = time(NULL);
  // Initialize sensors and displays
  bool AcceleroSuccess = InitSensorsDisplays ();
  // Did orientation change?
  ProcessAccelero (AcceleroSuccess);
  // Do we need to update time display?
  if (Orientation == Xmoins) GrandTimeH(!sameOrientation);
  // Do we need to update weather?
  bool MaJ = TestTime ();
  Serial.printf("WakeupReason : %d -> ", WakeupReason);
  Serial.println ((WakeupReason == 1) ? "Wake up by motion" : "Wake up by timer");
  SetDisplaysOrientation (Orientation, MaJ);
  // Prepare for deep sleep
  GoodNight (WakeUpInstant, epoch0, WakeupReason); // Nothing executed after that (ever)!
}

void loop() {}
