/*
    Connects to the selected Wifi
    Returns true if connected, false if not
*/
bool WifiConnect (byte iNetwork) {
  WiFi.begin(ssid[iNetwork - 1], password[iNetwork - 1]);
  unsigned long chrono = millis();
  while (WiFi.status() != WL_CONNECTED) {
    if   (millis() - chrono > WIFITIMEOUT) return false;
  }
  return true;
}

/*
    Search available Wifi network and connects.
    Returns the number of the Wifi found or 0 if none available
*/
byte WifiSearch () {
  byte iNetwork = 1;
  while (WiFi.status() != WL_CONNECTED) {
    Serial.printf ("\nTesting network number %d \n", iNetwork - 1);
    unsigned long chrono = millis();
    Serial.printf("Connecting to %s ", ssid[iNetwork - 1]);
    WiFi.begin(ssid[iNetwork - 1], password[iNetwork - 1]);
    byte i = 0;
    while (WiFi.status() != WL_CONNECTED && millis() - chrono < WIFITIMEOUT) {
      delay(200);
      Serial.print(".");
    }
    Serial.printf("\nWifi status %d \n", WiFi.status());
    iNetwork++;
    if (iNetwork > NetworksNumber) return 0; // No network found
  }
  Serial.printf("Connected to network number %d \n", iNetwork - 2);
  return iNetwork - 1; // Number of the network found, starting to 1
}

/*
    Inits the Wifi connection, displays search and connection state on serial
    console and display #2
    Returns true if connected, false if not
*/
bool WifiInit () {
  //connect to WiFi
  bool WConnected = false;
  if (wifiNumber == 255) {
    wifiNumber = WifiSearch ();
    if (wifiNumber == 0) return false;
    //print the local IP address
    IPAddress ip = WiFi.localIP();
    Serial.printf ("Connected to %s - IP %u:%u:%u:%u\n", ssid[wifiNumber - 1], ip[0], ip[1], ip[2], ip[3]);
    uint16_t w = petit.width();
    uint16_t h = petit.height();
    do {
      petit.setFont(&Open_Sans_ExtraBold_14);
      petit.setCursor(20, h * 0.9);
      petit.print (ssid[wifiNumber - 1]);
    } while (petit.nextPage());
  } else WConnected = WifiConnect (wifiNumber);
  return WConnected;
}

/*
   Disconnects from Wifi
*/
void WifiDisconnect () {
  WiFi.disconnect(true);
  WiFi.mode(WIFI_OFF);
  Serial.println("Disconnected !");
}

/*
     Connects to ntp server and set the time in the RTC of the ESP32
*/
void SetTimeByWifi () {
  const char* ntpServer  = "fr.pool.ntp.org";
  //init and get the time
  const long  gmtOffset_sec = 0;
  const int   daylightOffset_sec = 0;
  configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);
}
/*
   Update the time & weather at plain hours, but not at night (from 0 to 6 AM)
*/
bool TestTime () {
  WhatTime ();
  // Do not update if ...
  if (timeinfo->tm_min != 0) return false; // not plain hour
  WifiConnect (wifiNumber);
  SetTimeByWifi ();
  // Get citations & saint if ...
  if (timeinfo->tm_hour == 0) {
    totalCitNb = getCitations ();
    GetEphemeris (timeinfo->tm_mon + 1, timeinfo->tm_mday, Ephemeride);
  }
  if (timeinfo->tm_hour < 4) {
    WifiDisconnect ();
    return false; // night time
  }
  // Get weather if ...
  GetHourlyForecast ();                    // update hourly forecast each hour
  if (timeinfo->tm_hour % 4 == 0) GetDailyForecast (); // daily each 4 hours
  if (timeinfo->tm_hour % 3 == 0) GetCurrentMeteo ();  // current each 3 hours
  WifiDisconnect ();
  return true;
}

