/*
      Update timeinfo
*/
void WhatTime () {
  time_t rawtime;
  time (&rawtime);
  rawtime += GMT * 3600;
  timeinfo = localtime (&rawtime);
}
/*
   Centers a text on a display, disp = 0 for small display, 1 for large
   Returns the horizontal offset to remove from the X where to center the text
*/
int TextCenter (char text[], byte disp) {
  int16_t tbx, tby; uint16_t tbw, tbh; // boundary box window
  if (disp == 0) petit.getTextBounds(text, 0, 0, &tbx, &tby, &tbw, &tbh);
  else grand.getTextBounds(text, 0, 0, &tbx, &tby, &tbw, &tbh);
  return tbw / 2;
}

/*
   Draws a black and white image file stored in SPIFFS
   Images are compressed using RLE algorithm to save space in SPIFFS
   Arguments :
      SPIFFS
      name of the file, for example "/64nt_moderatesnow.rle"
      x0, y0: coordinates of the upper left corner
      disp: 0 for small display, 1 for big display
*/
void drawBitmapFromSpiffs(fs::FS &fs,  const char * path, int x0, int y0, byte disp) {
  //  File file = fs.open(path);
  File file = SPIFFS.open(path);
  if (!file) {
    Serial.println("Failed to open file for reading");
    return;
  }
  byte w = 0;
  byte h = 0;
  byte Sum = 0;
  byte N = 0;
  bool isBlack = true;
  h = file.read();
  w = file.read();
  for (int i = 0; i < h; i++) {
    Sum = 0;
    isBlack = true;
    while (Sum < w) {
      N = file.read();
      isBlack = !isBlack;
      if (isBlack) {
        for (int j = 0; j < N; j++) {
          if (disp == 0) petit.writePixel(x0 + Sum + j, y0 + i, GxEPD_BLACK);
          else           grand.writePixel(x0 + Sum + j, y0 + i, GxEPD_BLACK);
        }
      }
      Sum += N;
    }
  }
  file.close();
}
/*
    Search the filename of the specified weather icon
*/
char *getIconFile(struct icon *iconList, int code, bool isDay, bool isApixu)
{
  // Serial.printf("search icon for %d ", code);
  if (isApixu) {
    for (byte i = 0 ; iconList[i].ApixuCode != 0 ; i++) {
      if (iconList[i].ApixuCode == code) {
        if (isDay) {
          // Serial.println(iconList[i].DayIcon);
          return iconList[i].DayIcon;
        } else {
          // Serial.println(iconList[i].NightIcon);
          return iconList[i].NightIcon;
        }
      }
    }
  } else {
    for (byte i = 0 ; iconList[i].AccuweatherCode != 0 ; i++) {
      if (iconList[i].AccuweatherCode == code) {
        if (isDay) {
          // Serial.println(iconList[i].DayIcon);
          return iconList[i].DayIcon;
        } else {
          // Serial.println(iconList[i].NightIcon);
          return iconList[i].NightIcon;
        }
      }
    }
  }
  // Serial.println("Not found");
  return "unknown";
}
/*
     Displays temperature and humidity horizontally on large display
*/
void GrandTH2H (float temperature, float humidite, bool Erase) {
  Serial.println("GrandTH2H");
  uint16_t w = grand.width();
  uint16_t h = grand.height();
  grand.setRotation(0);
  if (Erase) {
    grand.setFullWindow();
    Serial.println ("Full window");
  } else {
    grand.setPartialWindow(0, 0, w, h);
    Serial.println ("Partial window");
    grand.firstPage();
    grand.fillScreen(GxEPD_WHITE);
    do {
      grand.setFont(&Open_Sans_ExtraBold_60);
      int x = w / 2 - TextCenter ("       ", 1) ;
      grand.setCursor (x, h * 0.45);
      grand.print("       ");
      x = w / 2 - TextCenter ("      ", 1) ;
      grand.setCursor (x, h * 0.9);
      grand.print("      ");
    } while (grand.nextPage());
  }
//  grand.setRotation(0);
  int x = 0;
  char TempText[8] = "xx.x C";
  char HumiText[8] = "xx.x %";
  grand.firstPage();
  grand.fillScreen(GxEPD_WHITE);
  do {
    grand.setFont(&Open_Sans_ExtraBold_22);
    sprintf(TempText, "%4.1f  C", temperature);
    //   TempText[5] = "°";
    sprintf(HumiText, "%4.1f %%", humidite);
    x = w / 2 - TextCenter ("TEMPERATURE :", 1) ;
    grand.setCursor (x, h * 0.2);
    grand.print("TEMPERATURE :");
    x = w / 2 - TextCenter ("HUMIDITE :", 1) ;
    grand.setCursor (x, h * 0.65);
    grand.print("HUMIDITE :");
    grand.setFont(&Open_Sans_ExtraBold_60);
    x = w / 2 - TextCenter (HumiText, 1) ;
    grand.setCursor (x, h * 0.9);
    grand.print(HumiText);
    x = w / 2 - TextCenter (TempText, 1) ;
    grand.setCursor (x, h * 0.45);
    grand.print(TempText);
    grand.setFont(&Open_Sans_ExtraBold_22);
    //    grand.setCursor (x + 100, h * 0.4);
    grand.setCursor (240, 95);
    grand.print("O");
  } while (grand.nextPage());
  grand.powerOff();
}

/*
    Displays current time (HH:MM) horizontally on large display
*/
void GrandTimeH (bool Erase) {
  Serial.printf("GrandTimeH : erase = %d -- ", Erase);
  int DigitPos[5] = {37, 110, 180, 217, 290};
  char currentTime[6] = "xx:xx";
  WhatTime ();
  currentTime[0] = (timeinfo->tm_hour + GMT + timeinfo->tm_isdst) % 24 / 10 + '0';
  currentTime[1] = (timeinfo->tm_hour + GMT + timeinfo->tm_isdst) % 24 % 10 + '0';
  // currentTime[0] = (timeinfo->tm_hour + timeinfo->tm_isdst) % 24 / 10 + '0';
  // currentTime[1] = (timeinfo->tm_hour + timeinfo->tm_isdst) % 24 % 10 + '0';
  currentTime[3] = timeinfo->tm_min / 10 + '0';
  currentTime[4] = timeinfo->tm_min % 10 + '0';

  unsigned long chrono = millis();
  grand.setRotation(2);
  grand.setFont(&Open_Sans_ExtraBold_120);
  if (Erase) {
    grand.setFullWindow();
    Serial.println ("Full window");
  } else {
    // Double partial refresh
    /*
      Remark : set TP0B to 20 on line 585 of file WaveTables.h
      in C:\Users\yourname\Documents\Arduino\libraries\GxEPD2\src
    */
    grand.setPartialWindow(0, 0, grand.width(), grand.height());
    Serial.println ("Double partial refresh");
    grand.firstPage();
    do {
      grand.fillScreen(GxEPD_WHITE);
      for (byte i = 0; i < 5; i++) {
        grand.setCursor(DigitPos[i], 200);
        grand.print(" ");
      }
    } while (grand.nextPage());
  }
  grand.firstPage();
  grand.fillScreen(GxEPD_WHITE);
  do {
    for (byte i = 0; i < 5; i++) {
      grand.setCursor(DigitPos[i], 200);
      grand.print(currentTime[i]);
    }
  } while (grand.nextPage());
  /*
    // Single partial refresh
    grand.setPartialWindow(20, 100, 350, 110);
    Serial.println ("Single partial refresh");
    grand.firstPage();
    grand.fillScreen(GxEPD_WHITE);
    do {
    for (byte i = 0; i < 5; i++) {
      grand.setCursor(DigitPos[i], 200);
      grand.print(currentTime[i]);
    }
    } while (grand.nextPage());
  */
  grand.powerOff();
  Serial.printf("Temps affichage : %d ms\n", millis() - chrono);
}

/*
   Displays current date (DD Month Year) vertically on large display
*/
void GrandDateV (byte rotation) {
  char * MonthName[] = {"Janvier", "Fevrier", "Mars", "Avril", "Mai", "Juin", "Juillet",
                        "Aout", "Septembre", "Octobre", "Novembre", "Decembre"
                       };
  char * DayName[] = {"Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"};
  Serial.println ("GrandDateV");
  //  time_t now;
  //  struct tm * timeinfo;
  time (&now);
  timeinfo = localtime (&now);
  grand.setRotation(rotation);
  byte n = 30;
  uint16_t w = grand.width();
  uint16_t h = grand.height();
  int x = 0;
  char Text[6] = "";
  grand.setFullWindow();
  grand.firstPage();
  grand.fillScreen(GxEPD_WHITE);
  do {
    grand.setFont(&Open_Sans_ExtraBold_90);
    sprintf(Text, "%d", timeinfo->tm_mday);
    x = w / 2 - TextCenter (Text, 1);
    grand.setCursor(x, 9 * h / 20);
    grand.print(Text);
    grand.setFont(&Open_Sans_ExtraBold_60);
    sprintf(Text, "%d ", timeinfo->tm_year + 1900);
    x = w / 2 - TextCenter (Text, 1);
    grand.setCursor(x, 16 * h / 20);
    grand.print(Text);

    // smaller font if necessary here
    if (strlen(DayName[timeinfo->tm_wday]) > 7) grand.setFont(&Open_Sans_ExtraBold_50);
    x = w / 2 - TextCenter (DayName[timeinfo->tm_wday], 1);
    grand.setCursor(x, 4 * h / 20);
    grand.print(DayName[timeinfo->tm_wday]);
    if (sizeof(MonthName[timeinfo->tm_mon]) > 7) grand.setFont(&Open_Sans_ExtraBold_50);
    else grand.setFont(&Open_Sans_ExtraBold_60);
    x = w / 2 - TextCenter (MonthName[timeinfo->tm_mon], 1);
    grand.setCursor(x, 12 * h / 20);
    grand.print(MonthName[timeinfo->tm_mon]);
    if (strlen(Ephemeride) > 10) grand.setFont(&Open_Sans_ExtraBold_30);
    if (strlen(Ephemeride) > 15) grand.setFont(&Open_Sans_ExtraBold_22);
    x = w / 2 - TextCenter (Ephemeride, 1);
    grand.setCursor(x, 19 * h / 20);
    grand.print(Ephemeride);
  } while (grand.nextPage());
  grand.powerOff();
}

/*
   Displays daily weather forecast horizontally on small display
*/
void PetitDailyWeatherH (int rotat) {
  Serial.println ("PetitDailyWeatherH");
  char * DayName[] = {"Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"};
  petit.setRotation(rotat);
  uint16_t w = petit.width();
  uint16_t h = petit.height();
  int x = 0;
  byte n = 8;
  char MinMaxTemp[15] = "00.0 / 00.0 C";
  char RainText[9] = "00.0 mm";
  char *IconName;
  char FileName[30];
  bool isDay = true;
  //  time_t now;
  //  struct tm * timeinfo;
  time (&now);
  timeinfo = localtime (&now);
  if (timeinfo->tm_hour > 19 || timeinfo->tm_hour < 7) isDay = false;
  petit.setFullWindow();
  petit.setFont(&Open_Sans_ExtraBold_14);
  petit.firstPage();
  petit.fillScreen(GxEPD_WHITE);
  do {
    petit.drawRect(0, 0, w, h, GxEPD_BLACK);
    petit.drawRect(w / 3, 0, w / 3, h, GxEPD_BLACK);
    for (int i = 1; i < nbDayForecast; i++) {
      x = w / 2 + (i - 2) * w / 3 - TextCenter (DayName[(timeinfo->tm_wday + i) % 7], 0);
      petit.setCursor(x, 15);
      petit.print (DayName[(timeinfo->tm_wday + i) % 7]);
      sprintf(MinMaxTemp, "%3.1f / %3.1f C", daily_mintemp[i], daily_maxtemp[i]);
      x = w / 2 + (i - 2) * w / 3 - TextCenter (MinMaxTemp, 0);
      petit.setCursor(x, h - 20);
      petit.print (MinMaxTemp);
      sprintf(RainText, "%4.1f mm", daily_Precip[i]);
      x = w / 2 + (i - 2) * w / 3 - TextCenter (RainText, 0);
      petit.setCursor(x, h - 5);
      petit.print (RainText);
      IconName = getIconFile(iconList, daily_condition_code[i], isDay, true);
      sprintf (FileName, "/64%s.rle", IconName);
      drawBitmapFromSpiffs(SPIFFS, FileName, w / 2 - 32 + (i - 2)*w / 3, 26, 0);
    }
  } while (petit.nextPage());
  petit.powerOff();
}

/*
   Displays hourly weather forecast vertically on small display
*/
void PetitHourlyWeather1V (byte rotation) {
  Serial.println ("PetitHourlyWeather1V");
  petit.setRotation(rotation - 1);
  uint16_t w = petit.width();
  uint16_t h = petit.height();
  int x = 0;
  byte offset = (rotation == 1) ? 0 : 3;
  char HoursText[7] = "00:00";
  char MinMaxTemp[7] = "00.0 C";
  char RainText[6] = "000 %";
  char *IconName;
  char FileName[30];
  bool isDay = true;
  time_t now;
  //  struct tm * timeinfo;
  time (&now);
  timeinfo = localtime (&now);
  petit.setFullWindow();
  petit.firstPage();
  petit.fillScreen(GxEPD_WHITE);
  do {
    petit.drawRect(0, 0, w, h, GxEPD_BLACK);
    petit.drawRect(0, h / 3, w, h / 3, GxEPD_BLACK);
    for (int j = 0; j < 3; j++) { // 3 hours
      petit.setFont(&Open_Sans_ExtraBold_16);
      byte i = j + offset;
      byte Hour_i = (timeinfo->tm_hour + GMT + hourlyHours[i]) % 24;
      sprintf(HoursText, "%02d:%02d", Hour_i, timeinfo->tm_min);
      x = w / 2 - TextCenter (HoursText, 0);
      petit.setCursor(x, 18 + j * h / 3);
      petit.print (HoursText);
      sprintf(MinMaxTemp, "%4.1f C", hourly_temp[i]);
      petit.setCursor(3, 42 + j * h / 3);
      petit.print (MinMaxTemp);
      sprintf(RainText, "%3d %%", hourly_PreciProba[i]);
      petit.setCursor(3, 42 + j * h / 3 + 22);
      petit.print (RainText);
      x = w / 2 - TextCenter (hourly_weather_description[i], 0);
      petit.setFont(&Open_Sans_ExtraBold_12);
      petit.setCursor(x, (j + 1) * h / 3 - 10);
      petit.print(hourly_weather_description[i]);
      isDay = (Hour_i > 19 || Hour_i < 7) ? false : true;
      IconName = getIconFile(iconList, hourly_weather_icon[i], isDay, false);
      sprintf (FileName, "/64%s.rle", IconName);
      drawBitmapFromSpiffs(SPIFFS, FileName, w - 64, 18 + j * h / 3, 0);
    }
  } while (petit.nextPage());
  petit.powerOff();
}

/*
   Displays current weather vertically on large display
*/
void GrandCurrentWeatherV () {
  Serial.println ("GrandCurrentWeatherV");
  grand.setRotation(3);
  grand.setFont(&Open_Sans_ExtraBold_60);
  byte n = 30;
  uint16_t w = grand.width();
  uint16_t h = grand.height();
  int x = 0;
  char *IconName;
  char FileName[30];
  char PressText[18] = "Pression 0000 mb";
  char PrecipText[15] = "Pluie 00.0 mm";
  char HumiText[15] = "Humidite 000 %";
  bool isDay = true;
  //  time_t now;
  //  struct tm * timeinfo;
  time (&now);
  timeinfo = localtime (&now);
  if (timeinfo->tm_hour > 19 || timeinfo->tm_hour < 7) isDay = false;
  grand.setFullWindow();
  grand.firstPage();
  grand.fillScreen(GxEPD_WHITE);
  do {
    IconName = getIconFile(iconList, current_condition_code, isDay, true);
    sprintf (FileName, "/200%s.rle", IconName);
    drawBitmapFromSpiffs(SPIFFS, FileName, w / 2 - 100, 160, 1);
    grand.setCursor(35, 70);
    if (current_temp < 10) grand.setCursor(55, 70);
    grand.print(current_temp, 1);
    grand.setCursor(175, 70);
    grand.print("C");
    grand.setFont(&Open_Sans_ExtraBold_22);
    grand.setCursor(155, 35);
    grand.print("O");
    sprintf(PressText, "Pression %4.0f mb", current_pressure);
    grand.setCursor(30, 100);
    grand.print(PressText);
    // Flèche
    if (tendency_pressure == 0) drawBitmapFromSpiffs(SPIFFS, "/30Fleche_bas.rle", 265, 75, 1);
    if (tendency_pressure == 1) drawBitmapFromSpiffs(SPIFFS, "/30Fleche_droite.rle", 265, 75, 1);
    if (tendency_pressure == 2) drawBitmapFromSpiffs(SPIFFS, "/30Fleche_haut.rle", 265, 75, 1);
    sprintf(PrecipText, "Pluie %4.1f mm", current_precip_mm);
    grand.setCursor(30, 130);
    grand.print(PrecipText);
    sprintf(HumiText, "Humidite %d %%", current_humidity);
    grand.setCursor(30, 160);
    grand.print(HumiText);
    x = w / 2 - TextCenter (current_weather_description, 1);
    grand.setCursor(x, 380);
    grand.print(current_weather_description);
  } while (grand.nextPage());
  grand.powerOff();
}

/*
   Display a random citation on large display (horizontally)
*/
void CitationHoriz (char Citation[sizeCitation], char Auteur[sizeAuthor]) {
  uint16_t w = grand.width();
  uint16_t h = grand.height();
  grand.setRotation(0);
  grand.setFullWindow();
  grand.firstPage();
  grand.fillScreen(GxEPD_WHITE);
  char ligne[31] = {0};
  int nEsp = 30;
  byte nLines = 1 + strlen(Citation) / nEsp;
  int y = h / (nLines + 2);
  int dy = 5 * y / 6;
  bool fini = false;
  grand.setFont(&Lato_Semibold_22);
  do {
    do {
      byte N = Espaces (Citation, strlen(Citation), nEsp);
      fini = (N == strlen(Citation)) ? true : false;
      for (byte i = 0; i < N; i++) ligne[i] = Citation[i];
      ligne[N] = '\0';
      int x = w / 2 - TextCenter(ligne, 1);
      grand.setCursor(x, y);
      grand.print(ligne);
      for (byte i = N + 1; i <= strlen(Citation); i++) Citation[i - N - 1] = Citation[i];
      y += dy;
    } while (!fini);
    int x = w / 2 - TextCenter(Auteur, 1);
    grand.setCursor(x, h - dy);
    grand.print(Auteur);
  } while (grand.nextPage());
  grand.powerOff();
}

/*
   Measure and display bettery level on small display
*/
void PetitBattery (float Voltage) {
  float MinVolt = 2.2;
  float MaxVolt = 4.3;
  char ligne[7] = "x.xx V";
  petit.setRotation(3);
  uint16_t w = petit.width();
  uint16_t h = petit.height();
  int dw = 16;
  sprintf (ligne, "%4.2f V", Voltage);
  petit.setFullWindow();
  petit.firstPage();
  petit.fillScreen (GxEPD_WHITE);
  do {
    petit.setFont(&Open_Sans_ExtraBold_16);
    petit.setCursor (195, 25);
    petit.print ("Tension");
    petit.setCursor (190, 45);
    petit.print ("Batterie");
    petit.setFont(&Open_Sans_ExtraBold_30);
    petit.setCursor (180, 90);
    petit.print (ligne);
    petit.drawRoundRect (20, 25, 130, 78, 10, GxEPD_BLACK);
    petit.drawRoundRect (140, 40, 20, 48, 5, GxEPD_BLACK);
    petit.fillRect(140, 40, 11, 48, GxEPD_WHITE);
    //    int percent = (int)(100.0 * Voltage / MaxVolt);
    int percent = (int)(100.0 * (Voltage - MinVolt) / (MaxVolt - MinVolt));
    percent = constrain(percent, 0, 100);
    int Fill = (int)(1.30 * percent);
    petit.fillRoundRect (20, 25, Fill, 78, 10, GxEPD_BLACK);
    if (percent > 10) for (int i = 1; i <= percent / 10; i++) petit.drawFastVLine(20 + i * 13, 26, 76, GxEPD_WHITE);
  } while (petit.nextPage());
  petit.powerOff();
}
