/*
   Remove the accents
*/
void Accents (int &c) {
  if (c == 146) c = 39;                    // '
  else if (c >= 224 && c <= 230) c = 97;   // a
  else if (c == 231) c = 99;               // c
  else if (c >= 232 && c <= 235) c = 101;  // e
  else if (c >= 236 && c <= 239) c = 105;  // i
  else if (c == 241) c = 110;              // n
  else if (c >= 242 && c <= 246) c = 111;  // o
  else if (c >= 249 && c <= 252) c = 117;  // u
}

/*
    Function that returns the saint of the day
    input : month number (january is 1, december is 12) and
    number of the day in the month (from 1 to 31)
*/
void GetEphemeris (int Month, int Day, char * Message) {
  String payload;
  HTTPClient http;
  http.begin("https://raw.githubusercontent.com/theofidry/ephemeris/master/src/ephemeris.json");
  int httpCode = http.GET();  // Make the request
  if (httpCode > 0) { // Check for the returning code
    payload = http.getString();
  } else Serial.println("Error on HTTP request");
  http.end(); //Free the resources
  if (httpCode == 200) {
    // JSON parse
    const size_t capacity = 366 * JSON_ARRAY_SIZE(2) + JSON_ARRAY_SIZE(29) + 4 * JSON_ARRAY_SIZE(30) + 7 * JSON_ARRAY_SIZE(31) + JSON_OBJECT_SIZE(12) + 6200;
    DynamicJsonBuffer jsonBuffer(capacity);
    JsonObject& root = jsonBuffer.parseObject(payload);
    const char* Name;
    char Name2[35];
    const char* Saint;
    *(Message) = '\0';
    switch (Month) {
      case 1:
        {
          JsonArray& EphMonth = root["january"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 2:
        {
          JsonArray& EphMonth = root["february"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 3:
        {
          JsonArray& EphMonth = root["march"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 4:
        {
          JsonArray& EphMonth = root["april"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 5:
        {
          JsonArray& EphMonth = root["may"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 6:
        {
          JsonArray& EphMonth = root["june"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 7:
        {
          JsonArray& EphMonth = root["july"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 8:
        {
          JsonArray& EphMonth = root["august"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 9:
        {
          JsonArray& EphMonth = root["september"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 10:
        {
          JsonArray& EphMonth = root["october"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 11:
        {
          JsonArray& EphMonth = root["november"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      case 12:
        {
          JsonArray& EphMonth = root["december"];
          Name  = EphMonth[Day - 1][0];
          Saint = EphMonth[Day - 1][1];
          break;
        }
      default:
        Serial.println("Error");
        return;
        break;
    }

    for (byte i = 0; i < strlen(Name); i++) Name2[i] = Name[i];
    LookForAccents (Name2, strlen(Name2));
    Serial.printf ("%s %s\n", Saint, Name2);
    byte decal = 0;
    if (strlen(Saint) > 4) {
      for (byte i = 0; i < strlen(Saint); i++) *(Message + i) = Saint[i];
      decal = strlen(Saint) + 1;
    }
    *(Message + strlen(Saint)) = ' ';
    for (byte i = 0; i < strlen(Name2); i++) *(Message + i + decal) = Name2[i];
    *(Message + decal + strlen(Name)) = '\0';
  }
}

/*
   Search for spaces inside a citation, returns the last one before a given place
   Arguments : Citation, length of the citation, max number of chars to search
*/
byte Espaces (char * Citation, int nbChar, int nEsp) {
  byte N = 0;
  for (int i = 0; i < nEsp; i++) {
    if (i == nbChar) return nbChar;
    if (Citation[i] == ' ') N = i;
  }
  return N;
}

/*
   Get citations on an Internet site
   usage : int nCit = getCitations ();
*/
int getCitations () {
  int nCit = 0;
  int nbCitMax = 0;
  bool plusone = false;
  WiFiClient *pStream;
  HTTPClient http;
  http.begin("http://samuel.benoit.online.fr/fr/citations-pensees-reflexions-philosophiques?SlowConnection=1");
  if (http.GET() == HTTP_CODE_OK) {
    pStream = http.getStreamPtr();
    byte c1, c2, c3;
    //  First read the total number of quotes
    pStream->find("citations : <b>");
    c1 = pStream->read() - '0';
    c2 = pStream->read() - '0';
    c3 = pStream->read() - '0';
    nbCitMax = c1 * 100 + c2 * 10 + c3;
    Serial.printf("Number of quotes : %d\n", nbCitMax);

    int Total = 0;
    int index[maxNbCitations] = {0};
    for (byte i = 0; i < maxNbCitations; i++) index[i] = 1 + random(nbCitMax - 4);
    for (byte i = 0; i < maxNbCitations; i++)
      for (byte j = i + 1; j < maxNbCitations; j++)
        if (index[i] > index[j]) {
          int tmp = index[i];
          index[i] = index[j];
          index[j] = tmp;
        }

    bool error = false;
    int prev = 0;
    while (nCit < maxNbCitations) {
      int decal = index[nCit] - prev;
      if (plusone) decal = 1;
      plusone = false;
      for (byte i = 0; i < decal; i++) pStream->find("<i>");
      Total += decal;
      if (Total > nbCitMax) return nCit;

      int c = pStream->read();
      int nChar = 0;
      Citation[nCit][nChar] = c & 0xFF;
      error = false;
      while (c != 60 && !error) { // 60 == '<'
        c = pStream->read();
        if (c > 127) Accents (c);
        Citation[nCit][++nChar] = c & 0xFF;
        if (nChar >= sizeCitation - 1) error = true;
      }
      Citation[nCit][nChar] = '\0';

      // Search the author's name
      if (!error) {
        pStream->find("right\">");
        c = pStream->read();
        int nAut = 0;
        Author[nCit][nAut] = c & 0xFF;
        while (c != 60 && nAut < sizeAuthor - 1) {
          c = pStream->read();
          if (c > 127) Accents (c);
          Author[nCit][++nAut] = c & 0xFF;
        }
        Author[nCit][nAut] = '\0';
      }

      LookForAccents(Author[nCit], strlen(Author[nCit]));
      LookForAccents(Citation[nCit], strlen(Citation[nCit]));
      Serial.printf ("%d : %s - %d - %s\n", nCit, Author[nCit], strlen(Citation[nCit]), Citation[nCit]);
      if (strlen(Citation[nCit]) < 10 || strlen(Citation[nCit]) > sizeCitation - 4 || error) {
        nCit--;
        plusone = true;
      }
      prev = index[nCit];
      nCit++;
    }
  }
  else Serial.println("Unable to connect to server!");
  http.end();
  return nCit;
}

/*
    Measure the battery voltage
*/
float VoltMeasure () {
  float moyenne = 0.0;
  digitalWrite(CTRL_PIN, LOW); //Close transistor
  for (int i = 0; i < 10; i++)  {
    int sensorValue = analogRead(MES_PIN); //Measure
    moyenne += sensorValue / 10;
    delay(50);
  }
  digitalWrite(CTRL_PIN, HIGH); //Open transistor
  // Convert the analog reading
  float Voltage = moyenne / 4095.0f * 4.4f;
  Serial.printf ("%5.0f --> Tension = %4.2f V\n", moyenne, Voltage);
  return Voltage;
}

