#include "Adafruit_NeoPixel.h"
#define PIN            3
#define NUMPIXELS      20
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

#define lightness  4
uint8_t  rgb_color[3] ;
long randNumber;



void setup()
{
    randomSeed(analogRead(4));
    pixels.begin();
    analogWrite(10,5);
}

void loop()
{
    randNumber = random(0,14);
    for(int i=0;i<randNumber;i++)
    {
        pixels.setPixelColor(i, pixels.Color(50,0,0)); // red.
        pixels.show();
        delay(100);
    }

    while(1)
    {
        long randNumber_ = random(0,14);

        if (randNumber>=randNumber_)
        {
            for(int i=randNumber;i>randNumber_;i--)
            {
                pixels.setPixelColor(i, pixels.Color(0,0,0));
                pixels.show();
                delay(20);
            }
        }
        else
        {
            for(int i=randNumber;i<randNumber_;i++)
            {
                pixels.setPixelColor(i, pixels.Color(50,0,0)); // red.
                pixels.show();
                delay(20);
            }
        }
        randNumber = randNumber_;
    }
}



void action_rgbled_on ()
{

    int i = 0;
    int j = 0;
    uint32_t time = millis();
    uint8_t phase = (time >> 4) ;
    float h = phase / 256.0;
    float s = 1.0;
    float v = 1.0;

    int i_ = floor(h * 6);
    float f = h * 6 - i_;
    float p = v * (1 - s);
    float q = v * (1 - f * s);
    float t = v * (1 - (1 - f) * s);
    float r = 0, g = 0, b = 0;
    switch(i_ % 6){
        case 0: r = v; g = t; b = p; break;
        case 1: r = q; g = v; b = p; break;
        case 2: r = p; g = v; b = t; break;
        case 3: r = p; g = q; b = v; break;
        case 4: r = t; g = p; b = v; break;
        case 5: r = v; g = p; b = q; break;
    }

    rgb_color[0] = r * 255;
    rgb_color[1] = g * 255;
    rgb_color[2] = b * 255;

    rgb_color[0] = rgb_color[0] >>lightness;
    rgb_color[1] = rgb_color[1] >>lightness;
    rgb_color[2] = rgb_color[2] >>lightness;
}

void off ()
{
    for(int i=0;i<NUMPIXELS;i++)
    {
        pixels.setPixelColor(i, pixels.Color(0,0,0)); // Moderately bright green color.
        pixels.show(); // This sends the updated pixel color to the hardware.
    }
}


