package com.gun.fresh.turret;


import android.util.Log;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;


/**
 * Coded by Rezk Bouras on 19/03/2015.
 */

/**
 * Modified by Connor Dyke on February 25th, 2016
 */
public class TCPClient {


    private static String IP = "";
    private static int PORT = 0;
    //private MulticastSocket connectivity_socket;
    private Socket connectivity_socket;
    private boolean stayWithOpenConnection = true;
    public static boolean isConnected = false;
    private PrintWriter out = null;

    public TCPClient(String IP, int port) {

        // Set the IP Address
        this.setIP(IP);
        // Set the Port
        this.setPORT(port);
    }


    /**
     * Initializes the variables needed for connecting to the remote side.
     * @return boolean connectivity status.
     */
    public boolean initiateConnection() {

        try {
            // SocketAddress socket_addr;
            SocketAddress socket_addr = new InetSocketAddress(IP, PORT);
            connectivity_socket = new Socket(); //Create a new socket.
            // Set keep connection alive feature to what the user requested.
            connectivity_socket.setKeepAlive(stayWithOpenConnection);
            connectivity_socket.connect(socket_addr, 3000); // Connect to the end point (gun) and wait 3 seconds as timeout until we get connected, if we are connected we should continue, otherwise we get out of try block.
            isConnected = true; // Set the connected status to true.

            /////////////////// For Debugging Purposes \\\\\\\\\\\\\\\\\\\\\\\\\
        } catch (UnknownHostException e) {
                System.err.println("Don't know about host " + IP);
            System.exit(1);
        } catch (IOException e) {
              System.err.println("Couldn't get connection I/O for " + IP);
            e.getMessage();
            System.exit(1);
        }
            /////////////////// For Debugging Purposes \\\\\\\\\\\\\\\\\\\\\\\\\

         // Return connectivity status.
        return connectivity_socket.isConnected();
    }


    /**
     * Sends a command to the remote side.
     * @param command to send to the remote side.
     */
    public void send(char command) {
        //String received = "";

        if (connectivity_socket.isConnected()) { // Are we connected?

            try {
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(connectivity_socket.getOutputStream())),true); // store our data that we want to send to memory stream type, and tunnel it through the socket that is connected to the end point.
                out.println(command); // confirm sending data to the endpoint.

                /////////////////// For Debugging Purposes \\\\\\\\\\\\\\\\\\\\\\\\\
            } catch (IOException ex) {
                Log.d("TAG", ex.getMessage());
            }
                /////////////////// For Debugging Purposes \\\\\\\\\\\\\\\\\\\\\\\\\


              // Incase you needed to show some data from the remote side, or you want to interpret the data coming from the remote endpoint, just uncomment the following and the variable 'received':
           /* if (received != "") {

                // show received data on screen.

            }*/

            //return received;
        }

    }

    /**
     * Method that gets back the IP that was set to connect to.
     * @return String (Remote Side IP Address)
     */
    public static String getIP() {
        return IP;
    }

    /**
     * Method to set the IP to connect to.
     * @param IP to connect to.
     */
    public static void setIP(String IP) {
        TCPClient.IP = IP;
    }

    /**
     * Method to get the port that was used to connect to the remote side.
     * @return Port that was set by the user for the remote side.
     */
    public static int getPORT() {
        return PORT;
    }

    /**
     * Method to set the port that will be used to connect to the remote side IP or host.
     * @param PORT to set for connecting to the remote side.
     */
    public static void setPORT(int PORT) {
        TCPClient.PORT = PORT;
    }
}
