/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget.helper;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.animation.AnimatorCompatHelper;
import android.support.v4.animation.AnimatorListenerCompat;
import android.support.v4.animation.AnimatorUpdateListenerCompat;
import android.support.v4.animation.ValueAnimatorCompat;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.recyclerview.R;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchUIUtil;
import android.support.v7.widget.helper.ItemTouchUIUtilImpl;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;

public class ItemTouchHelper
extends RecyclerView.ItemDecoration
implements RecyclerView.OnChildAttachStateChangeListener {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int START = 16;
    public static final int END = 32;
    public static final int ACTION_STATE_IDLE = 0;
    public static final int ACTION_STATE_SWIPE = 1;
    public static final int ACTION_STATE_DRAG = 2;
    public static final int ANIMATION_TYPE_SWIPE_SUCCESS = 2;
    public static final int ANIMATION_TYPE_SWIPE_CANCEL = 4;
    public static final int ANIMATION_TYPE_DRAG = 8;
    private static final String TAG = "ItemTouchHelper";
    private static final boolean DEBUG = false;
    private static final int ACTIVE_POINTER_ID_NONE = -1;
    private static final int DIRECTION_FLAG_COUNT = 8;
    private static final int ACTION_MODE_IDLE_MASK = 255;
    private static final int ACTION_MODE_SWIPE_MASK = 65280;
    private static final int ACTION_MODE_DRAG_MASK = 0xFF0000;
    final List<View> mPendingCleanup = new ArrayList<View>();
    private final float[] mTmpPosition = new float[2];
    RecyclerView.ViewHolder mSelected = null;
    float mInitialTouchX;
    float mInitialTouchY;
    float mDx;
    float mDy;
    float mSelectedStartX;
    float mSelectedStartY;
    int mActivePointerId = -1;
    Callback mCallback;
    int mActionState = 0;
    int mSelectedFlags;
    List<RecoverAnimation> mRecoverAnimations = new ArrayList<RecoverAnimation>();
    private int mSlop;
    private RecyclerView mRecyclerView;
    private final Runnable mScrollRunnable = new Runnable(){

        @Override
        public void run() {
            if (ItemTouchHelper.this.mSelected != null && ItemTouchHelper.this.scrollIfNecessary()) {
                if (ItemTouchHelper.this.mSelected != null) {
                    ItemTouchHelper.this.moveIfNecessary(ItemTouchHelper.this.mSelected);
                }
                ItemTouchHelper.this.mRecyclerView.removeCallbacks(ItemTouchHelper.this.mScrollRunnable);
                ViewCompat.postOnAnimation((View)ItemTouchHelper.this.mRecyclerView, (Runnable)this);
            }
        }
    };
    private VelocityTracker mVelocityTracker;
    private List<RecyclerView.ViewHolder> mSwapTargets;
    private List<Integer> mDistances;
    private RecyclerView.ChildDrawingOrderCallback mChildDrawingOrderCallback = null;
    private View mOverdrawChild = null;
    private int mOverdrawChildPosition = -1;
    private GestureDetectorCompat mGestureDetector;
    private final RecyclerView.OnItemTouchListener mOnItemTouchListener = new RecyclerView.OnItemTouchListener(){

        @Override
        public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent event) {
            int index;
            ItemTouchHelper.this.mGestureDetector.onTouchEvent(event);
            int action = MotionEventCompat.getActionMasked((MotionEvent)event);
            if (action == 0) {
                RecoverAnimation animation;
                ItemTouchHelper.this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                ItemTouchHelper.this.mInitialTouchX = event.getX();
                ItemTouchHelper.this.mInitialTouchY = event.getY();
                ItemTouchHelper.this.obtainVelocityTracker();
                if (ItemTouchHelper.this.mSelected == null && (animation = ItemTouchHelper.this.findAnimation(event)) != null) {
                    ItemTouchHelper.this.mInitialTouchX -= animation.mX;
                    ItemTouchHelper.this.mInitialTouchY -= animation.mY;
                    ItemTouchHelper.this.endRecoverAnimation(animation.mViewHolder, true);
                    if (ItemTouchHelper.this.mPendingCleanup.remove(animation.mViewHolder.itemView)) {
                        ItemTouchHelper.this.mCallback.clearView(ItemTouchHelper.this.mRecyclerView, animation.mViewHolder);
                    }
                    ItemTouchHelper.this.select(animation.mViewHolder, animation.mActionState);
                    ItemTouchHelper.this.updateDxDy(event, ItemTouchHelper.this.mSelectedFlags, 0);
                }
            } else if (action == 3 || action == 1) {
                ItemTouchHelper.this.mActivePointerId = -1;
                ItemTouchHelper.this.select(null, 0);
            } else if (ItemTouchHelper.this.mActivePointerId != -1 && (index = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)ItemTouchHelper.this.mActivePointerId)) >= 0) {
                ItemTouchHelper.this.checkSelectForSwipe(action, event, index);
            }
            if (ItemTouchHelper.this.mVelocityTracker != null) {
                ItemTouchHelper.this.mVelocityTracker.addMovement(event);
            }
            return ItemTouchHelper.this.mSelected != null;
        }

        @Override
        public void onTouchEvent(RecyclerView recyclerView, MotionEvent event) {
            RecyclerView.ViewHolder viewHolder;
            ItemTouchHelper.this.mGestureDetector.onTouchEvent(event);
            if (ItemTouchHelper.this.mVelocityTracker != null) {
                ItemTouchHelper.this.mVelocityTracker.addMovement(event);
            }
            if (ItemTouchHelper.this.mActivePointerId == -1) {
                return;
            }
            int action = MotionEventCompat.getActionMasked((MotionEvent)event);
            int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)ItemTouchHelper.this.mActivePointerId);
            if (activePointerIndex >= 0) {
                ItemTouchHelper.this.checkSelectForSwipe(action, event, activePointerIndex);
            }
            if ((viewHolder = ItemTouchHelper.this.mSelected) == null) {
                return;
            }
            switch (action) {
                case 2: {
                    if (activePointerIndex < 0) break;
                    ItemTouchHelper.this.updateDxDy(event, ItemTouchHelper.this.mSelectedFlags, activePointerIndex);
                    ItemTouchHelper.this.moveIfNecessary(viewHolder);
                    ItemTouchHelper.this.mRecyclerView.removeCallbacks(ItemTouchHelper.this.mScrollRunnable);
                    ItemTouchHelper.this.mScrollRunnable.run();
                    ItemTouchHelper.this.mRecyclerView.invalidate();
                    break;
                }
                case 1: 
                case 3: {
                    if (ItemTouchHelper.this.mVelocityTracker != null) {
                        ItemTouchHelper.this.mVelocityTracker.computeCurrentVelocity(1000, (float)ItemTouchHelper.this.mRecyclerView.getMaxFlingVelocity());
                    }
                    ItemTouchHelper.this.select(null, 0);
                    ItemTouchHelper.this.mActivePointerId = -1;
                    break;
                }
                case 6: {
                    int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                    int pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)pointerIndex);
                    if (pointerId != ItemTouchHelper.this.mActivePointerId) break;
                    if (ItemTouchHelper.this.mVelocityTracker != null) {
                        ItemTouchHelper.this.mVelocityTracker.computeCurrentVelocity(1000, (float)ItemTouchHelper.this.mRecyclerView.getMaxFlingVelocity());
                    }
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    ItemTouchHelper.this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)newPointerIndex);
                    ItemTouchHelper.this.updateDxDy(event, ItemTouchHelper.this.mSelectedFlags, pointerIndex);
                    break;
                }
            }
        }

        @Override
        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            if (!disallowIntercept) {
                return;
            }
            ItemTouchHelper.this.select(null, 0);
        }
    };
    private Rect mTmpRect;
    private long mDragScrollStartTimeInMs;

    public ItemTouchHelper(Callback callback) {
        this.mCallback = callback;
    }

    private static boolean hitTest(View child, float x, float y, float left, float top) {
        return x >= left && x <= left + (float)child.getWidth() && y >= top && y <= top + (float)child.getHeight();
    }

    public void attachToRecyclerView(RecyclerView recyclerView) {
        if (this.mRecyclerView == recyclerView) {
            return;
        }
        if (this.mRecyclerView != null) {
            this.destroyCallbacks();
        }
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView != null) {
            this.setupCallbacks();
        }
    }

    private void setupCallbacks() {
        ViewConfiguration vc = ViewConfiguration.get((Context)this.mRecyclerView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mRecyclerView.addItemDecoration(this);
        this.mRecyclerView.addOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this);
        this.initGestureDetector();
    }

    private void destroyCallbacks() {
        this.mRecyclerView.removeItemDecoration(this);
        this.mRecyclerView.removeOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.removeOnChildAttachStateChangeListener(this);
        int recoverAnimSize = this.mRecoverAnimations.size();
        for (int i = recoverAnimSize - 1; i >= 0; --i) {
            RecoverAnimation recoverAnimation = this.mRecoverAnimations.get(0);
            this.mCallback.clearView(this.mRecyclerView, recoverAnimation.mViewHolder);
        }
        this.mRecoverAnimations.clear();
        this.mOverdrawChild = null;
        this.mOverdrawChildPosition = -1;
        this.releaseVelocityTracker();
    }

    private void initGestureDetector() {
        if (this.mGestureDetector != null) {
            return;
        }
        this.mGestureDetector = new GestureDetectorCompat(this.mRecyclerView.getContext(), (GestureDetector.OnGestureListener)new ItemTouchHelperGestureListener());
    }

    private void getSelectedDxDy(float[] outPosition) {
        outPosition[0] = (this.mSelectedFlags & 0xC) != 0 ? this.mSelectedStartX + this.mDx - (float)this.mSelected.itemView.getLeft() : ViewCompat.getTranslationX((View)this.mSelected.itemView);
        outPosition[1] = (this.mSelectedFlags & 3) != 0 ? this.mSelectedStartY + this.mDy - (float)this.mSelected.itemView.getTop() : ViewCompat.getTranslationY((View)this.mSelected.itemView);
    }

    @Override
    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.mSelected != null) {
            this.getSelectedDxDy(this.mTmpPosition);
            dx = this.mTmpPosition[0];
            dy = this.mTmpPosition[1];
        }
        this.mCallback.onDrawOver(c, parent, this.mSelected, this.mRecoverAnimations, this.mActionState, dx, dy);
    }

    @Override
    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.mOverdrawChildPosition = -1;
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.mSelected != null) {
            this.getSelectedDxDy(this.mTmpPosition);
            dx = this.mTmpPosition[0];
            dy = this.mTmpPosition[1];
        }
        this.mCallback.onDraw(c, parent, this.mSelected, this.mRecoverAnimations, this.mActionState, dx, dy);
    }

    private void select(RecyclerView.ViewHolder selected, int actionState) {
        ViewParent rvParent;
        if (selected == this.mSelected && actionState == this.mActionState) {
            return;
        }
        this.mDragScrollStartTimeInMs = Long.MIN_VALUE;
        int prevActionState = this.mActionState;
        this.endRecoverAnimation(selected, true);
        this.mActionState = actionState;
        if (actionState == 2) {
            this.mOverdrawChild = selected.itemView;
            this.addChildDrawingOrderCallback();
        }
        int actionStateMask = (1 << 8 + 8 * actionState) - 1;
        boolean preventLayout = false;
        if (this.mSelected != null) {
            final RecyclerView.ViewHolder prevSelected = this.mSelected;
            if (prevSelected.itemView.getParent() != null) {
                float targetTranslateX;
                float targetTranslateY;
                final int swipeDir = prevActionState == 2 ? 0 : this.swipeIfNecessary(prevSelected);
                this.releaseVelocityTracker();
                switch (swipeDir) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: {
                        targetTranslateY = 0.0f;
                        targetTranslateX = Math.signum(this.mDx) * (float)this.mRecyclerView.getWidth();
                        break;
                    }
                    case 1: 
                    case 2: {
                        targetTranslateX = 0.0f;
                        targetTranslateY = Math.signum(this.mDy) * (float)this.mRecyclerView.getHeight();
                        break;
                    }
                    default: {
                        targetTranslateX = 0.0f;
                        targetTranslateY = 0.0f;
                    }
                }
                int animationType = prevActionState == 2 ? 8 : (swipeDir > 0 ? 2 : 4);
                this.getSelectedDxDy(this.mTmpPosition);
                float currentTranslateX = this.mTmpPosition[0];
                float currentTranslateY = this.mTmpPosition[1];
                RecoverAnimation rv = new RecoverAnimation(prevSelected, animationType, prevActionState, currentTranslateX, currentTranslateY, targetTranslateX, targetTranslateY){

                    @Override
                    public void onAnimationEnd(ValueAnimatorCompat animation) {
                        super.onAnimationEnd(animation);
                        if (this.mOverridden) {
                            return;
                        }
                        if (swipeDir <= 0) {
                            ItemTouchHelper.this.mCallback.clearView(ItemTouchHelper.this.mRecyclerView, prevSelected);
                        } else {
                            ItemTouchHelper.this.mPendingCleanup.add(prevSelected.itemView);
                            this.mIsPendingCleanup = true;
                            if (swipeDir > 0) {
                                ItemTouchHelper.this.postDispatchSwipe(this, swipeDir);
                            }
                        }
                        if (ItemTouchHelper.this.mOverdrawChild == prevSelected.itemView) {
                            ItemTouchHelper.this.removeChildDrawingOrderCallbackIfNecessary(prevSelected.itemView);
                        }
                    }
                };
                long duration = this.mCallback.getAnimationDuration(this.mRecyclerView, animationType, targetTranslateX - currentTranslateX, targetTranslateY - currentTranslateY);
                rv.setDuration(duration);
                this.mRecoverAnimations.add(rv);
                rv.start();
                preventLayout = true;
            } else {
                this.removeChildDrawingOrderCallbackIfNecessary(prevSelected.itemView);
                this.mCallback.clearView(this.mRecyclerView, prevSelected);
            }
            this.mSelected = null;
        }
        if (selected != null) {
            this.mSelectedFlags = (this.mCallback.getAbsoluteMovementFlags(this.mRecyclerView, selected) & actionStateMask) >> this.mActionState * 8;
            this.mSelectedStartX = selected.itemView.getLeft();
            this.mSelectedStartY = selected.itemView.getTop();
            this.mSelected = selected;
            if (actionState == 2) {
                this.mSelected.itemView.performHapticFeedback(0);
            }
        }
        if ((rvParent = this.mRecyclerView.getParent()) != null) {
            rvParent.requestDisallowInterceptTouchEvent(this.mSelected != null);
        }
        if (!preventLayout) {
            this.mRecyclerView.getLayoutManager().requestSimpleAnimationsInNextLayout();
        }
        this.mCallback.onSelectedChanged(this.mSelected, this.mActionState);
        this.mRecyclerView.invalidate();
    }

    private void postDispatchSwipe(final RecoverAnimation anim, final int swipeDir) {
        this.mRecyclerView.post(new Runnable(){

            @Override
            public void run() {
                if (ItemTouchHelper.this.mRecyclerView != null && ItemTouchHelper.this.mRecyclerView.isAttachedToWindow() && !anim.mOverridden && anim.mViewHolder.getAdapterPosition() != -1) {
                    RecyclerView.ItemAnimator animator = ItemTouchHelper.this.mRecyclerView.getItemAnimator();
                    if (!(animator != null && animator.isRunning(null) || ItemTouchHelper.this.hasRunningRecoverAnim())) {
                        ItemTouchHelper.this.mCallback.onSwiped(anim.mViewHolder, swipeDir);
                    } else {
                        ItemTouchHelper.this.mRecyclerView.post(this);
                    }
                }
            }
        });
    }

    private boolean hasRunningRecoverAnim() {
        int size = this.mRecoverAnimations.size();
        for (int i = 0; i < size; ++i) {
            if (this.mRecoverAnimations.get(i).mEnded) continue;
            return true;
        }
        return false;
    }

    private boolean scrollIfNecessary() {
        if (this.mSelected == null) {
            this.mDragScrollStartTimeInMs = Long.MIN_VALUE;
            return false;
        }
        long now = System.currentTimeMillis();
        long scrollDuration = this.mDragScrollStartTimeInMs == Long.MIN_VALUE ? 0L : now - this.mDragScrollStartTimeInMs;
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        if (this.mTmpRect == null) {
            this.mTmpRect = new Rect();
        }
        int scrollX = 0;
        int scrollY = 0;
        lm.calculateItemDecorationsForChild(this.mSelected.itemView, this.mTmpRect);
        if (lm.canScrollHorizontally()) {
            int rightDiff;
            int curX = (int)(this.mSelectedStartX + this.mDx);
            int leftDiff = curX - this.mTmpRect.left - this.mRecyclerView.getPaddingLeft();
            if (this.mDx < 0.0f && leftDiff < 0) {
                scrollX = leftDiff;
            } else if (this.mDx > 0.0f && (rightDiff = curX + this.mSelected.itemView.getWidth() + this.mTmpRect.right - (this.mRecyclerView.getWidth() - this.mRecyclerView.getPaddingRight())) > 0) {
                scrollX = rightDiff;
            }
        }
        if (lm.canScrollVertically()) {
            int bottomDiff;
            int curY = (int)(this.mSelectedStartY + this.mDy);
            int topDiff = curY - this.mTmpRect.top - this.mRecyclerView.getPaddingTop();
            if (this.mDy < 0.0f && topDiff < 0) {
                scrollY = topDiff;
            } else if (this.mDy > 0.0f && (bottomDiff = curY + this.mSelected.itemView.getHeight() + this.mTmpRect.bottom - (this.mRecyclerView.getHeight() - this.mRecyclerView.getPaddingBottom())) > 0) {
                scrollY = bottomDiff;
            }
        }
        if (scrollX != 0) {
            scrollX = this.mCallback.interpolateOutOfBoundsScroll(this.mRecyclerView, this.mSelected.itemView.getWidth(), scrollX, this.mRecyclerView.getWidth(), scrollDuration);
        }
        if (scrollY != 0) {
            scrollY = this.mCallback.interpolateOutOfBoundsScroll(this.mRecyclerView, this.mSelected.itemView.getHeight(), scrollY, this.mRecyclerView.getHeight(), scrollDuration);
        }
        if (scrollX != 0 || scrollY != 0) {
            if (this.mDragScrollStartTimeInMs == Long.MIN_VALUE) {
                this.mDragScrollStartTimeInMs = now;
            }
            this.mRecyclerView.scrollBy(scrollX, scrollY);
            return true;
        }
        this.mDragScrollStartTimeInMs = Long.MIN_VALUE;
        return false;
    }

    private List<RecyclerView.ViewHolder> findSwapTargets(RecyclerView.ViewHolder viewHolder) {
        if (this.mSwapTargets == null) {
            this.mSwapTargets = new ArrayList<RecyclerView.ViewHolder>();
            this.mDistances = new ArrayList<Integer>();
        } else {
            this.mSwapTargets.clear();
            this.mDistances.clear();
        }
        int margin = this.mCallback.getBoundingBoxMargin();
        int left = Math.round(this.mSelectedStartX + this.mDx) - margin;
        int top = Math.round(this.mSelectedStartY + this.mDy) - margin;
        int right = left + viewHolder.itemView.getWidth() + 2 * margin;
        int bottom = top + viewHolder.itemView.getHeight() + 2 * margin;
        int centerX = (left + right) / 2;
        int centerY = (top + bottom) / 2;
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        int childCount = lm.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            RecyclerView.ViewHolder otherVh;
            View other = lm.getChildAt(i);
            if (other == viewHolder.itemView || other.getBottom() < top || other.getTop() > bottom || other.getRight() < left || other.getLeft() > right || !this.mCallback.canDropOver(this.mRecyclerView, this.mSelected, otherVh = this.mRecyclerView.getChildViewHolder(other))) continue;
            int dx = Math.abs(centerX - (other.getLeft() + other.getRight()) / 2);
            int dy = Math.abs(centerY - (other.getTop() + other.getBottom()) / 2);
            int dist = dx * dx + dy * dy;
            int pos = 0;
            int cnt = this.mSwapTargets.size();
            for (int j = 0; j < cnt && dist > this.mDistances.get(j); ++j) {
                ++pos;
            }
            this.mSwapTargets.add(pos, otherVh);
            this.mDistances.add(pos, dist);
        }
        return this.mSwapTargets;
    }

    private void moveIfNecessary(RecyclerView.ViewHolder viewHolder) {
        if (this.mRecyclerView.isLayoutRequested()) {
            return;
        }
        if (this.mActionState != 2) {
            return;
        }
        float threshold = this.mCallback.getMoveThreshold(viewHolder);
        int x = (int)(this.mSelectedStartX + this.mDx);
        int y = (int)(this.mSelectedStartY + this.mDy);
        if ((float)Math.abs(y - viewHolder.itemView.getTop()) < (float)viewHolder.itemView.getHeight() * threshold && (float)Math.abs(x - viewHolder.itemView.getLeft()) < (float)viewHolder.itemView.getWidth() * threshold) {
            return;
        }
        List<RecyclerView.ViewHolder> swapTargets = this.findSwapTargets(viewHolder);
        if (swapTargets.size() == 0) {
            return;
        }
        RecyclerView.ViewHolder target = this.mCallback.chooseDropTarget(viewHolder, swapTargets, x, y);
        if (target == null) {
            this.mSwapTargets.clear();
            this.mDistances.clear();
            return;
        }
        int toPosition = target.getAdapterPosition();
        int fromPosition = viewHolder.getAdapterPosition();
        if (this.mCallback.onMove(this.mRecyclerView, viewHolder, target)) {
            this.mCallback.onMoved(this.mRecyclerView, viewHolder, fromPosition, target, toPosition, x, y);
        }
    }

    @Override
    public void onChildViewAttachedToWindow(View view) {
    }

    @Override
    public void onChildViewDetachedFromWindow(View view) {
        this.removeChildDrawingOrderCallbackIfNecessary(view);
        RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(view);
        if (holder == null) {
            return;
        }
        if (this.mSelected != null && holder == this.mSelected) {
            this.select(null, 0);
        } else {
            this.endRecoverAnimation(holder, false);
            if (this.mPendingCleanup.remove(holder.itemView)) {
                this.mCallback.clearView(this.mRecyclerView, holder);
            }
        }
    }

    private int endRecoverAnimation(RecyclerView.ViewHolder viewHolder, boolean override) {
        int recoverAnimSize = this.mRecoverAnimations.size();
        for (int i = recoverAnimSize - 1; i >= 0; --i) {
            RecoverAnimation anim = this.mRecoverAnimations.get(i);
            if (anim.mViewHolder != viewHolder) continue;
            anim.mOverridden |= override;
            if (!anim.mEnded) {
                anim.cancel();
            }
            this.mRecoverAnimations.remove(i);
            return anim.mAnimationType;
        }
        return 0;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.setEmpty();
    }

    private void obtainVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = VelocityTracker.obtain();
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private RecyclerView.ViewHolder findSwipedView(MotionEvent motionEvent) {
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        if (this.mActivePointerId == -1) {
            return null;
        }
        int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId);
        float dx = MotionEventCompat.getX((MotionEvent)motionEvent, (int)pointerIndex) - this.mInitialTouchX;
        float dy = MotionEventCompat.getY((MotionEvent)motionEvent, (int)pointerIndex) - this.mInitialTouchY;
        float absDx = Math.abs(dx);
        float absDy = Math.abs(dy);
        if (absDx < (float)this.mSlop && absDy < (float)this.mSlop) {
            return null;
        }
        if (absDx > absDy && lm.canScrollHorizontally()) {
            return null;
        }
        if (absDy > absDx && lm.canScrollVertically()) {
            return null;
        }
        View child = this.findChildView(motionEvent);
        if (child == null) {
            return null;
        }
        return this.mRecyclerView.getChildViewHolder(child);
    }

    private boolean checkSelectForSwipe(int action, MotionEvent motionEvent, int pointerIndex) {
        if (this.mSelected != null || action != 2 || this.mActionState == 2 || !this.mCallback.isItemViewSwipeEnabled()) {
            return false;
        }
        if (this.mRecyclerView.getScrollState() == 1) {
            return false;
        }
        RecyclerView.ViewHolder vh = this.findSwipedView(motionEvent);
        if (vh == null) {
            return false;
        }
        int movementFlags = this.mCallback.getAbsoluteMovementFlags(this.mRecyclerView, vh);
        int swipeFlags = (movementFlags & 0xFF00) >> 8;
        if (swipeFlags == 0) {
            return false;
        }
        float x = MotionEventCompat.getX((MotionEvent)motionEvent, (int)pointerIndex);
        float y = MotionEventCompat.getY((MotionEvent)motionEvent, (int)pointerIndex);
        float dx = x - this.mInitialTouchX;
        float dy = y - this.mInitialTouchY;
        float absDx = Math.abs(dx);
        float absDy = Math.abs(dy);
        if (absDx < (float)this.mSlop && absDy < (float)this.mSlop) {
            return false;
        }
        if (absDx > absDy) {
            if (dx < 0.0f && (swipeFlags & 4) == 0) {
                return false;
            }
            if (dx > 0.0f && (swipeFlags & 8) == 0) {
                return false;
            }
        } else {
            if (dy < 0.0f && (swipeFlags & 1) == 0) {
                return false;
            }
            if (dy > 0.0f && (swipeFlags & 2) == 0) {
                return false;
            }
        }
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)0);
        this.select(vh, 1);
        return true;
    }

    private View findChildView(MotionEvent event) {
        View selectedView;
        float x = event.getX();
        float y = event.getY();
        if (this.mSelected != null && ItemTouchHelper.hitTest(selectedView = this.mSelected.itemView, x, y, this.mSelectedStartX + this.mDx, this.mSelectedStartY + this.mDy)) {
            return selectedView;
        }
        for (int i = this.mRecoverAnimations.size() - 1; i >= 0; --i) {
            RecoverAnimation anim = this.mRecoverAnimations.get(i);
            View view = anim.mViewHolder.itemView;
            if (!ItemTouchHelper.hitTest(view, x, y, anim.mX, anim.mY)) continue;
            return view;
        }
        return this.mRecyclerView.findChildViewUnder(x, y);
    }

    public void startDrag(RecyclerView.ViewHolder viewHolder) {
        if (!this.mCallback.hasDragFlag(this.mRecyclerView, viewHolder)) {
            Log.e((String)TAG, (String)"Start drag has been called but swiping is not enabled");
            return;
        }
        if (viewHolder.itemView.getParent() != this.mRecyclerView) {
            Log.e((String)TAG, (String)"Start drag has been called with a view holder which is not a child of the RecyclerView which is controlled by this ItemTouchHelper.");
            return;
        }
        this.obtainVelocityTracker();
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.select(viewHolder, 2);
    }

    public void startSwipe(RecyclerView.ViewHolder viewHolder) {
        if (!this.mCallback.hasSwipeFlag(this.mRecyclerView, viewHolder)) {
            Log.e((String)TAG, (String)"Start swipe has been called but dragging is not enabled");
            return;
        }
        if (viewHolder.itemView.getParent() != this.mRecyclerView) {
            Log.e((String)TAG, (String)"Start swipe has been called with a view holder which is not a child of the RecyclerView controlled by this ItemTouchHelper.");
            return;
        }
        this.obtainVelocityTracker();
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.select(viewHolder, 1);
    }

    private RecoverAnimation findAnimation(MotionEvent event) {
        if (this.mRecoverAnimations.isEmpty()) {
            return null;
        }
        View target = this.findChildView(event);
        for (int i = this.mRecoverAnimations.size() - 1; i >= 0; --i) {
            RecoverAnimation anim = this.mRecoverAnimations.get(i);
            if (anim.mViewHolder.itemView != target) continue;
            return anim;
        }
        return null;
    }

    private void updateDxDy(MotionEvent ev, int directionFlags, int pointerIndex) {
        float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
        float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        this.mDx = x - this.mInitialTouchX;
        this.mDy = y - this.mInitialTouchY;
        if ((directionFlags & 4) == 0) {
            this.mDx = Math.max(0.0f, this.mDx);
        }
        if ((directionFlags & 8) == 0) {
            this.mDx = Math.min(0.0f, this.mDx);
        }
        if ((directionFlags & 1) == 0) {
            this.mDy = Math.max(0.0f, this.mDy);
        }
        if ((directionFlags & 2) == 0) {
            this.mDy = Math.min(0.0f, this.mDy);
        }
    }

    private int swipeIfNecessary(RecyclerView.ViewHolder viewHolder) {
        if (this.mActionState == 2) {
            return 0;
        }
        int originalMovementFlags = this.mCallback.getMovementFlags(this.mRecyclerView, viewHolder);
        int absoluteMovementFlags = this.mCallback.convertToAbsoluteDirection(originalMovementFlags, ViewCompat.getLayoutDirection((View)this.mRecyclerView));
        int flags = (absoluteMovementFlags & 0xFF00) >> 8;
        if (flags == 0) {
            return 0;
        }
        int originalFlags = (originalMovementFlags & 0xFF00) >> 8;
        if (Math.abs(this.mDx) > Math.abs(this.mDy)) {
            int swipeDir = this.checkHorizontalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                if ((originalFlags & swipeDir) == 0) {
                    return Callback.convertToRelativeDirection(swipeDir, ViewCompat.getLayoutDirection((View)this.mRecyclerView));
                }
                return swipeDir;
            }
            swipeDir = this.checkVerticalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                return swipeDir;
            }
        } else {
            int swipeDir = this.checkVerticalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                return swipeDir;
            }
            swipeDir = this.checkHorizontalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                if ((originalFlags & swipeDir) == 0) {
                    return Callback.convertToRelativeDirection(swipeDir, ViewCompat.getLayoutDirection((View)this.mRecyclerView));
                }
                return swipeDir;
            }
        }
        return 0;
    }

    private int checkHorizontalSwipe(RecyclerView.ViewHolder viewHolder, int flags) {
        if ((flags & 0xC) != 0) {
            int dirFlag;
            int n = dirFlag = this.mDx > 0.0f ? 8 : 4;
            if (this.mVelocityTracker != null && this.mActivePointerId > -1) {
                int velDirFlag;
                float xVelocity = VelocityTrackerCompat.getXVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId);
                int n2 = velDirFlag = xVelocity > 0.0f ? 8 : 4;
                if ((velDirFlag & flags) != 0 && dirFlag == velDirFlag && Math.abs(xVelocity) >= (float)this.mRecyclerView.getMinFlingVelocity()) {
                    return velDirFlag;
                }
            }
            float threshold = (float)this.mRecyclerView.getWidth() * this.mCallback.getSwipeThreshold(viewHolder);
            if ((flags & dirFlag) != 0 && Math.abs(this.mDx) > threshold) {
                return dirFlag;
            }
        }
        return 0;
    }

    private int checkVerticalSwipe(RecyclerView.ViewHolder viewHolder, int flags) {
        if ((flags & 3) != 0) {
            int dirFlag;
            int n = dirFlag = this.mDy > 0.0f ? 2 : 1;
            if (this.mVelocityTracker != null && this.mActivePointerId > -1) {
                int velDirFlag;
                float yVelocity = VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId);
                int n2 = velDirFlag = yVelocity > 0.0f ? 2 : 1;
                if ((velDirFlag & flags) != 0 && velDirFlag == dirFlag && Math.abs(yVelocity) >= (float)this.mRecyclerView.getMinFlingVelocity()) {
                    return velDirFlag;
                }
            }
            float threshold = (float)this.mRecyclerView.getHeight() * this.mCallback.getSwipeThreshold(viewHolder);
            if ((flags & dirFlag) != 0 && Math.abs(this.mDy) > threshold) {
                return dirFlag;
            }
        }
        return 0;
    }

    private void addChildDrawingOrderCallback() {
        if (Build.VERSION.SDK_INT >= 21) {
            return;
        }
        if (this.mChildDrawingOrderCallback == null) {
            this.mChildDrawingOrderCallback = new RecyclerView.ChildDrawingOrderCallback(){

                @Override
                public int onGetChildDrawingOrder(int childCount, int i) {
                    if (ItemTouchHelper.this.mOverdrawChild == null) {
                        return i;
                    }
                    int childPosition = ItemTouchHelper.this.mOverdrawChildPosition;
                    if (childPosition == -1) {
                        childPosition = ItemTouchHelper.this.mRecyclerView.indexOfChild(ItemTouchHelper.this.mOverdrawChild);
                        ItemTouchHelper.this.mOverdrawChildPosition = childPosition;
                    }
                    if (i == childCount - 1) {
                        return childPosition;
                    }
                    return i < childPosition ? i : i + 1;
                }
            };
        }
        this.mRecyclerView.setChildDrawingOrderCallback(this.mChildDrawingOrderCallback);
    }

    private void removeChildDrawingOrderCallbackIfNecessary(View view) {
        if (view == this.mOverdrawChild) {
            this.mOverdrawChild = null;
            if (this.mChildDrawingOrderCallback != null) {
                this.mRecyclerView.setChildDrawingOrderCallback(null);
            }
        }
    }

    private class RecoverAnimation
    implements AnimatorListenerCompat {
        final float mStartDx;
        final float mStartDy;
        final float mTargetX;
        final float mTargetY;
        final RecyclerView.ViewHolder mViewHolder;
        final int mActionState;
        private final ValueAnimatorCompat mValueAnimator;
        private final int mAnimationType;
        public boolean mIsPendingCleanup;
        float mX;
        float mY;
        boolean mOverridden = false;
        private boolean mEnded = false;
        private float mFraction;

        public RecoverAnimation(RecyclerView.ViewHolder viewHolder, int animationType, int actionState, float startDx, float startDy, float targetX, float targetY) {
            this.mActionState = actionState;
            this.mAnimationType = animationType;
            this.mViewHolder = viewHolder;
            this.mStartDx = startDx;
            this.mStartDy = startDy;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mValueAnimator = AnimatorCompatHelper.emptyValueAnimator();
            this.mValueAnimator.addUpdateListener(new AnimatorUpdateListenerCompat(){

                public void onAnimationUpdate(ValueAnimatorCompat animation) {
                    RecoverAnimation.this.setFraction(animation.getAnimatedFraction());
                }
            });
            this.mValueAnimator.setTarget(viewHolder.itemView);
            this.mValueAnimator.addListener((AnimatorListenerCompat)this);
            this.setFraction(0.0f);
        }

        public void setDuration(long duration) {
            this.mValueAnimator.setDuration(duration);
        }

        public void start() {
            this.mViewHolder.setIsRecyclable(false);
            this.mValueAnimator.start();
        }

        public void cancel() {
            this.mValueAnimator.cancel();
        }

        public void setFraction(float fraction) {
            this.mFraction = fraction;
        }

        public void update() {
            this.mX = this.mStartDx == this.mTargetX ? ViewCompat.getTranslationX((View)this.mViewHolder.itemView) : this.mStartDx + this.mFraction * (this.mTargetX - this.mStartDx);
            this.mY = this.mStartDy == this.mTargetY ? ViewCompat.getTranslationY((View)this.mViewHolder.itemView) : this.mStartDy + this.mFraction * (this.mTargetY - this.mStartDy);
        }

        public void onAnimationStart(ValueAnimatorCompat animation) {
        }

        public void onAnimationEnd(ValueAnimatorCompat animation) {
            if (!this.mEnded) {
                this.mViewHolder.setIsRecyclable(true);
            }
            this.mEnded = true;
        }

        public void onAnimationCancel(ValueAnimatorCompat animation) {
            this.setFraction(1.0f);
        }

        public void onAnimationRepeat(ValueAnimatorCompat animation) {
        }
    }

    private class ItemTouchHelperGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private ItemTouchHelperGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public void onLongPress(MotionEvent e) {
            RecyclerView.ViewHolder vh;
            View child = ItemTouchHelper.this.findChildView(e);
            if (child != null && (vh = ItemTouchHelper.this.mRecyclerView.getChildViewHolder(child)) != null) {
                if (!ItemTouchHelper.this.mCallback.hasDragFlag(ItemTouchHelper.this.mRecyclerView, vh)) {
                    return;
                }
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                if (pointerId == ItemTouchHelper.this.mActivePointerId) {
                    int index = MotionEventCompat.findPointerIndex((MotionEvent)e, (int)ItemTouchHelper.this.mActivePointerId);
                    float x = MotionEventCompat.getX((MotionEvent)e, (int)index);
                    float y = MotionEventCompat.getY((MotionEvent)e, (int)index);
                    ItemTouchHelper.this.mInitialTouchX = x;
                    ItemTouchHelper.this.mInitialTouchY = y;
                    ItemTouchHelper.this.mDy = 0.0f;
                    ItemTouchHelper.this.mDx = 0.0f;
                    if (ItemTouchHelper.this.mCallback.isLongPressDragEnabled()) {
                        ItemTouchHelper.this.select(vh, 2);
                    }
                }
            }
        }
    }

    public static abstract class SimpleCallback
    extends Callback {
        private int mDefaultSwipeDirs;
        private int mDefaultDragDirs;

        public SimpleCallback(int dragDirs, int swipeDirs) {
            this.mDefaultSwipeDirs = swipeDirs;
            this.mDefaultDragDirs = dragDirs;
        }

        public void setDefaultSwipeDirs(int defaultSwipeDirs) {
            this.mDefaultSwipeDirs = defaultSwipeDirs;
        }

        public void setDefaultDragDirs(int defaultDragDirs) {
            this.mDefaultDragDirs = defaultDragDirs;
        }

        public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return this.mDefaultSwipeDirs;
        }

        public int getDragDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return this.mDefaultDragDirs;
        }

        @Override
        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return SimpleCallback.makeMovementFlags(this.getDragDirs(recyclerView, viewHolder), this.getSwipeDirs(recyclerView, viewHolder));
        }
    }

    public static abstract class Callback {
        public static final int DEFAULT_DRAG_ANIMATION_DURATION = 200;
        public static final int DEFAULT_SWIPE_ANIMATION_DURATION = 250;
        static final int RELATIVE_DIR_FLAGS = 0x303030;
        private static final ItemTouchUIUtil sUICallback;
        private static final int ABS_HORIZONTAL_DIR_FLAGS = 789516;
        private static final Interpolator sDragScrollInterpolator;
        private static final Interpolator sDragViewScrollCapInterpolator;
        private static final long DRAG_SCROLL_ACCELERATION_LIMIT_TIME_MS = 2000L;
        private int mCachedMaxScrollSpeed = -1;

        public static ItemTouchUIUtil getDefaultUIUtil() {
            return sUICallback;
        }

        public static int convertToRelativeDirection(int flags, int layoutDirection) {
            int masked = flags & 0xC0C0C;
            if (masked == 0) {
                return flags;
            }
            flags &= ~masked;
            if (layoutDirection == 0) {
                return flags |= masked << 2;
            }
            flags |= masked << 1 & 0xFFF3F3F3;
            return flags |= (masked << 1 & 0xC0C0C) << 2;
        }

        public static int makeMovementFlags(int dragFlags, int swipeFlags) {
            return Callback.makeFlag(0, swipeFlags | dragFlags) | Callback.makeFlag(1, swipeFlags) | Callback.makeFlag(2, dragFlags);
        }

        public static int makeFlag(int actionState, int directions) {
            return directions << actionState * 8;
        }

        public abstract int getMovementFlags(RecyclerView var1, RecyclerView.ViewHolder var2);

        public int convertToAbsoluteDirection(int flags, int layoutDirection) {
            int masked = flags & 0x303030;
            if (masked == 0) {
                return flags;
            }
            flags &= ~masked;
            if (layoutDirection == 0) {
                return flags |= masked >> 2;
            }
            flags |= masked >> 1 & 0xFFCFCFCF;
            return flags |= (masked >> 1 & 0x303030) >> 2;
        }

        final int getAbsoluteMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int flags = this.getMovementFlags(recyclerView, viewHolder);
            return this.convertToAbsoluteDirection(flags, ViewCompat.getLayoutDirection((View)recyclerView));
        }

        private boolean hasDragFlag(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int flags = this.getAbsoluteMovementFlags(recyclerView, viewHolder);
            return (flags & 0xFF0000) != 0;
        }

        private boolean hasSwipeFlag(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int flags = this.getAbsoluteMovementFlags(recyclerView, viewHolder);
            return (flags & 0xFF00) != 0;
        }

        public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
            return true;
        }

        public abstract boolean onMove(RecyclerView var1, RecyclerView.ViewHolder var2, RecyclerView.ViewHolder var3);

        public boolean isLongPressDragEnabled() {
            return true;
        }

        public boolean isItemViewSwipeEnabled() {
            return true;
        }

        public int getBoundingBoxMargin() {
            return 0;
        }

        public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
            return 0.5f;
        }

        public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
            return 0.5f;
        }

        public RecyclerView.ViewHolder chooseDropTarget(RecyclerView.ViewHolder selected, List<RecyclerView.ViewHolder> dropTargets, int curX, int curY) {
            int right = curX + selected.itemView.getWidth();
            int bottom = curY + selected.itemView.getHeight();
            RecyclerView.ViewHolder winner = null;
            int winnerScore = -1;
            int dx = curX - selected.itemView.getLeft();
            int dy = curY - selected.itemView.getTop();
            int targetsSize = dropTargets.size();
            for (int i = 0; i < targetsSize; ++i) {
                int score;
                int diff;
                RecyclerView.ViewHolder target = dropTargets.get(i);
                if (dx > 0 && (diff = target.itemView.getRight() - right) < 0 && target.itemView.getRight() > selected.itemView.getRight() && (score = Math.abs(diff)) > winnerScore) {
                    winnerScore = score;
                    winner = target;
                }
                if (dx < 0 && (diff = target.itemView.getLeft() - curX) > 0 && target.itemView.getLeft() < selected.itemView.getLeft() && (score = Math.abs(diff)) > winnerScore) {
                    winnerScore = score;
                    winner = target;
                }
                if (dy < 0 && (diff = target.itemView.getTop() - curY) > 0 && target.itemView.getTop() < selected.itemView.getTop() && (score = Math.abs(diff)) > winnerScore) {
                    winnerScore = score;
                    winner = target;
                }
                if (dy <= 0 || (diff = target.itemView.getBottom() - bottom) >= 0 || target.itemView.getBottom() <= selected.itemView.getBottom() || (score = Math.abs(diff)) <= winnerScore) continue;
                winnerScore = score;
                winner = target;
            }
            return winner;
        }

        public abstract void onSwiped(RecyclerView.ViewHolder var1, int var2);

        public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
            if (viewHolder != null) {
                sUICallback.onSelected(viewHolder.itemView);
            }
        }

        private int getMaxDragScroll(RecyclerView recyclerView) {
            if (this.mCachedMaxScrollSpeed == -1) {
                this.mCachedMaxScrollSpeed = recyclerView.getResources().getDimensionPixelSize(R.dimen.item_touch_helper_max_drag_scroll_per_frame);
            }
            return this.mCachedMaxScrollSpeed;
        }

        public void onMoved(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, int fromPos, RecyclerView.ViewHolder target, int toPos, int x, int y) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof ViewDropHandler) {
                ((ViewDropHandler)((Object)layoutManager)).prepareForDrop(viewHolder.itemView, target.itemView, x, y);
                return;
            }
            if (layoutManager.canScrollHorizontally()) {
                int maxRight;
                int minLeft = layoutManager.getDecoratedLeft(target.itemView);
                if (minLeft <= recyclerView.getPaddingLeft()) {
                    recyclerView.scrollToPosition(toPos);
                }
                if ((maxRight = layoutManager.getDecoratedRight(target.itemView)) >= recyclerView.getWidth() - recyclerView.getPaddingRight()) {
                    recyclerView.scrollToPosition(toPos);
                }
            }
            if (layoutManager.canScrollVertically()) {
                int maxBottom;
                int minTop = layoutManager.getDecoratedTop(target.itemView);
                if (minTop <= recyclerView.getPaddingTop()) {
                    recyclerView.scrollToPosition(toPos);
                }
                if ((maxBottom = layoutManager.getDecoratedBottom(target.itemView)) >= recyclerView.getHeight() - recyclerView.getPaddingBottom()) {
                    recyclerView.scrollToPosition(toPos);
                }
            }
        }

        private void onDraw(Canvas c, RecyclerView parent, RecyclerView.ViewHolder selected, List<RecoverAnimation> recoverAnimationList, int actionState, float dX, float dY) {
            int recoverAnimSize = recoverAnimationList.size();
            for (int i = 0; i < recoverAnimSize; ++i) {
                RecoverAnimation anim = recoverAnimationList.get(i);
                anim.update();
                int count = c.save();
                this.onChildDraw(c, parent, anim.mViewHolder, anim.mX, anim.mY, anim.mActionState, false);
                c.restoreToCount(count);
            }
            if (selected != null) {
                int count = c.save();
                this.onChildDraw(c, parent, selected, dX, dY, actionState, true);
                c.restoreToCount(count);
            }
        }

        private void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.ViewHolder selected, List<RecoverAnimation> recoverAnimationList, int actionState, float dX, float dY) {
            int recoverAnimSize = recoverAnimationList.size();
            for (int i = 0; i < recoverAnimSize; ++i) {
                RecoverAnimation anim = recoverAnimationList.get(i);
                int count = c.save();
                this.onChildDrawOver(c, parent, anim.mViewHolder, anim.mX, anim.mY, anim.mActionState, false);
                c.restoreToCount(count);
            }
            if (selected != null) {
                int count = c.save();
                this.onChildDrawOver(c, parent, selected, dX, dY, actionState, true);
                c.restoreToCount(count);
            }
            boolean hasRunningAnimation = false;
            for (int i = recoverAnimSize - 1; i >= 0; --i) {
                RecoverAnimation anim = recoverAnimationList.get(i);
                if (anim.mEnded && !anim.mIsPendingCleanup) {
                    recoverAnimationList.remove(i);
                    continue;
                }
                if (anim.mEnded) continue;
                hasRunningAnimation = true;
            }
            if (hasRunningAnimation) {
                parent.invalidate();
            }
        }

        public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            sUICallback.clearView(viewHolder.itemView);
        }

        public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            sUICallback.onDraw(c, recyclerView, viewHolder.itemView, dX, dY, actionState, isCurrentlyActive);
        }

        public void onChildDrawOver(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            sUICallback.onDrawOver(c, recyclerView, viewHolder.itemView, dX, dY, actionState, isCurrentlyActive);
        }

        public long getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
            RecyclerView.ItemAnimator itemAnimator = recyclerView.getItemAnimator();
            if (itemAnimator == null) {
                return animationType == 8 ? 200L : 250L;
            }
            return animationType == 8 ? itemAnimator.getMoveDuration() : itemAnimator.getRemoveDuration();
        }

        public int interpolateOutOfBoundsScroll(RecyclerView recyclerView, int viewSize, int viewSizeOutOfBounds, int totalSize, long msSinceStartScroll) {
            float timeRatio;
            float outOfBoundsRatio;
            int maxScroll = this.getMaxDragScroll(recyclerView);
            int absOutOfBounds = Math.abs(viewSizeOutOfBounds);
            int direction = (int)Math.signum(viewSizeOutOfBounds);
            int cappedScroll = (int)((float)(direction * maxScroll) * sDragViewScrollCapInterpolator.getInterpolation(outOfBoundsRatio = Math.min(1.0f, 1.0f * (float)absOutOfBounds / (float)viewSize)));
            int value = (int)((float)cappedScroll * sDragScrollInterpolator.getInterpolation(timeRatio = msSinceStartScroll > 2000L ? 1.0f : (float)msSinceStartScroll / 2000.0f));
            if (value == 0) {
                return viewSizeOutOfBounds > 0 ? 1 : -1;
            }
            return value;
        }

        static {
            sDragScrollInterpolator = new Interpolator(){

                public float getInterpolation(float t) {
                    return t * t * t * t * t;
                }
            };
            sDragViewScrollCapInterpolator = new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            };
            sUICallback = Build.VERSION.SDK_INT >= 21 ? new ItemTouchUIUtilImpl.Lollipop() : (Build.VERSION.SDK_INT >= 11 ? new ItemTouchUIUtilImpl.Honeycomb() : new ItemTouchUIUtilImpl.Gingerbread());
        }
    }

    public static interface ViewDropHandler {
        public void prepareForDrop(View var1, View var2, int var3, int var4);
    }
}

