/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.LruCache;
import android.support.v7.appcompat.R;
import android.support.v7.widget.ThemeUtils;
import android.support.v7.widget.TintInfo;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.WeakHashMap;

public final class AppCompatDrawableManager {
    private static final String TAG = "TintManager";
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static AppCompatDrawableManager INSTANCE;
    private static final ColorFilterLruCache COLOR_FILTER_CACHE;
    private static final int[] COLORFILTER_TINT_COLOR_CONTROL_NORMAL;
    private static final int[] TINT_COLOR_CONTROL_NORMAL;
    private static final int[] COLORFILTER_COLOR_CONTROL_ACTIVATED;
    private static final int[] COLORFILTER_COLOR_BACKGROUND_MULTIPLY;
    private static final int[] TINT_COLOR_CONTROL_STATE_LIST;
    private static final int[] TINT_CHECKABLE_BUTTON_LIST;
    private WeakHashMap<Context, SparseArray<ColorStateList>> mTintLists;
    private ArrayList<InflateDelegate> mDelegates;

    public static AppCompatDrawableManager get() {
        if (INSTANCE == null) {
            INSTANCE = new AppCompatDrawableManager();
        }
        return INSTANCE;
    }

    public Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        return this.getDrawable(context, resId, false);
    }

    public Drawable getDrawable(@NonNull Context context, @DrawableRes int resId, boolean failIfNotKnown) {
        Drawable drawable2;
        if (this.mDelegates != null) {
            int count = this.mDelegates.size();
            for (int i = 0; i < count; ++i) {
                InflateDelegate delegate = this.mDelegates.get(i);
                Drawable result = delegate.onInflateDrawable(context, resId);
                if (result == null) continue;
                return result;
            }
        }
        if ((drawable2 = ContextCompat.getDrawable((Context)context, (int)resId)) != null) {
            ColorStateList tintList;
            if (Build.VERSION.SDK_INT >= 8) {
                drawable2 = drawable2.mutate();
            }
            if ((tintList = this.getTintList(context, resId)) != null) {
                drawable2 = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)tintList);
                PorterDuff.Mode tintMode = this.getTintMode(resId);
                if (tintMode != null) {
                    DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)tintMode);
                }
            } else {
                if (resId == R.drawable.abc_cab_background_top_material) {
                    return new LayerDrawable(new Drawable[]{this.getDrawable(context, R.drawable.abc_cab_background_internal_bg), this.getDrawable(context, R.drawable.abc_cab_background_top_mtrl_alpha)});
                }
                if (resId == R.drawable.abc_seekbar_track_material) {
                    LayerDrawable ld = (LayerDrawable)drawable2;
                    AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(0x1020000), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                    AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                    AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                } else {
                    boolean tinted = this.tintDrawableUsingColorFilter(context, resId, drawable2);
                    if (!tinted && failIfNotKnown) {
                        drawable2 = null;
                    }
                }
            }
        }
        return drawable2;
    }

    public final boolean tintDrawableUsingColorFilter(@NonNull Context context, @DrawableRes int resId, @NonNull Drawable drawable2) {
        PorterDuff.Mode tintMode = DEFAULT_MODE;
        boolean colorAttrSet = false;
        int colorAttr = 0;
        int alpha = -1;
        if (AppCompatDrawableManager.arrayContains(COLORFILTER_TINT_COLOR_CONTROL_NORMAL, resId)) {
            colorAttr = R.attr.colorControlNormal;
            colorAttrSet = true;
        } else if (AppCompatDrawableManager.arrayContains(COLORFILTER_COLOR_CONTROL_ACTIVATED, resId)) {
            colorAttr = R.attr.colorControlActivated;
            colorAttrSet = true;
        } else if (AppCompatDrawableManager.arrayContains(COLORFILTER_COLOR_BACKGROUND_MULTIPLY, resId)) {
            colorAttr = 0x1010031;
            colorAttrSet = true;
            tintMode = PorterDuff.Mode.MULTIPLY;
        } else if (resId == R.drawable.abc_list_divider_mtrl_alpha) {
            colorAttr = 0x1010030;
            colorAttrSet = true;
            alpha = Math.round(40.8f);
        }
        if (colorAttrSet) {
            int color2 = ThemeUtils.getThemeAttrColor(context, colorAttr);
            drawable2.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(color2, tintMode));
            if (alpha != -1) {
                drawable2.setAlpha(alpha);
            }
            return true;
        }
        return false;
    }

    public void addDelegate(@NonNull InflateDelegate delegate) {
        if (this.mDelegates == null) {
            this.mDelegates = new ArrayList();
        }
        if (!this.mDelegates.contains(delegate)) {
            this.mDelegates.add(delegate);
        }
    }

    public void removeDelegate(@NonNull InflateDelegate delegate) {
        if (this.mDelegates != null) {
            this.mDelegates.remove(delegate);
        }
    }

    private static boolean arrayContains(int[] array, int value) {
        for (int id2 : array) {
            if (id2 != value) continue;
            return true;
        }
        return false;
    }

    final PorterDuff.Mode getTintMode(int resId) {
        PorterDuff.Mode mode = null;
        if (resId == R.drawable.abc_switch_thumb_material) {
            mode = PorterDuff.Mode.MULTIPLY;
        }
        return mode;
    }

    public final ColorStateList getTintList(@NonNull Context context, @DrawableRes int resId) {
        ColorStateList tint = this.getTintListFromCache(context, resId);
        if (tint == null) {
            if (resId == R.drawable.abc_edit_text_material) {
                tint = this.createEditTextColorStateList(context);
            } else if (resId == R.drawable.abc_switch_track_mtrl_alpha) {
                tint = this.createSwitchTrackColorStateList(context);
            } else if (resId == R.drawable.abc_switch_thumb_material) {
                tint = this.createSwitchThumbColorStateList(context);
            } else if (resId == R.drawable.abc_btn_default_mtrl_shape || resId == R.drawable.abc_btn_borderless_material) {
                tint = this.createDefaultButtonColorStateList(context);
            } else if (resId == R.drawable.abc_btn_colored_material) {
                tint = this.createColoredButtonColorStateList(context);
            } else if (resId == R.drawable.abc_spinner_mtrl_am_alpha || resId == R.drawable.abc_spinner_textfield_background_material) {
                tint = this.createSpinnerColorStateList(context);
            } else if (AppCompatDrawableManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, resId)) {
                tint = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorControlNormal);
            } else if (AppCompatDrawableManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, resId)) {
                tint = this.createDefaultColorStateList(context);
            } else if (AppCompatDrawableManager.arrayContains(TINT_CHECKABLE_BUTTON_LIST, resId)) {
                tint = this.createCheckableButtonColorStateList(context);
            } else if (resId == R.drawable.abc_seekbar_thumb_material) {
                tint = this.createSeekbarThumbColorStateList(context);
            }
            if (tint != null) {
                this.addTintListToCache(context, resId, tint);
            }
        }
        return tint;
    }

    private ColorStateList getTintListFromCache(@NonNull Context context, @DrawableRes int resId) {
        if (this.mTintLists != null) {
            SparseArray<ColorStateList> tints = this.mTintLists.get(context);
            return tints != null ? (ColorStateList)tints.get(resId) : null;
        }
        return null;
    }

    private void addTintListToCache(@NonNull Context context, @DrawableRes int resId, @NonNull ColorStateList tintList) {
        SparseArray themeTints;
        if (this.mTintLists == null) {
            this.mTintLists = new WeakHashMap();
        }
        if ((themeTints = this.mTintLists.get(context)) == null) {
            themeTints = new SparseArray();
            this.mTintLists.put(context, (SparseArray<ColorStateList>)themeTints);
        }
        themeTints.append(resId, (Object)tintList);
    }

    private ColorStateList createDefaultColorStateList(Context context) {
        int colorControlNormal = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        int colorControlActivated = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        int[][] states = new int[7][];
        int[] colors = new int[7];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.FOCUSED_STATE_SET;
        colors[i] = colorControlActivated;
        states[++i] = ThemeUtils.ACTIVATED_STATE_SET;
        colors[i] = colorControlActivated;
        states[++i] = ThemeUtils.PRESSED_STATE_SET;
        colors[i] = colorControlActivated;
        states[++i] = ThemeUtils.CHECKED_STATE_SET;
        colors[i] = colorControlActivated;
        states[++i] = ThemeUtils.SELECTED_STATE_SET;
        colors[i] = colorControlActivated;
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = colorControlNormal;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createCheckableButtonColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.CHECKED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSwitchTrackColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, 0x1010030, 0.1f);
        states[++i] = ThemeUtils.CHECKED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated, 0.3f);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, 0x1010030, 0.3f);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSwitchThumbColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        ColorStateList thumbColor = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorSwitchThumbNormal);
        if (thumbColor != null && thumbColor.isStateful()) {
            states[i] = ThemeUtils.DISABLED_STATE_SET;
            colors[i] = thumbColor.getColorForState(states[i], 0);
            states[++i] = ThemeUtils.CHECKED_STATE_SET;
            colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
            states[++i] = ThemeUtils.EMPTY_STATE_SET;
            colors[i] = thumbColor.getDefaultColor();
            ++i;
        } else {
            states[i] = ThemeUtils.DISABLED_STATE_SET;
            colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
            states[++i] = ThemeUtils.CHECKED_STATE_SET;
            colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
            states[++i] = ThemeUtils.EMPTY_STATE_SET;
            colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
            ++i;
        }
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createEditTextColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.NOT_PRESSED_OR_FOCUSED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createDefaultButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, R.attr.colorButtonNormal);
    }

    private ColorStateList createColoredButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, R.attr.colorAccent);
    }

    private ColorStateList createButtonColorStateList(Context context, int baseColorAttr) {
        int[][] states = new int[4][];
        int[] colors = new int[4];
        int i = 0;
        int baseColor = ThemeUtils.getThemeAttrColor(context, baseColorAttr);
        int colorControlHighlight = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlHighlight);
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorButtonNormal);
        states[++i] = ThemeUtils.PRESSED_STATE_SET;
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)baseColor);
        states[++i] = ThemeUtils.FOCUSED_STATE_SET;
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)baseColor);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = baseColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSpinnerColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.NOT_PRESSED_OR_FOCUSED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSeekbarThumbColorStateList(Context context) {
        int[][] states = new int[2][];
        int[] colors = new int[2];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlActivated);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    public static void tintDrawable(Drawable drawable2, TintInfo tint, int[] state) {
        if (AppCompatDrawableManager.shouldMutateBackground(drawable2) && drawable2.mutate() != drawable2) {
            Log.d((String)TAG, (String)"Mutated drawable is not the same instance as the input.");
            return;
        }
        if (tint.mHasTintList || tint.mHasTintMode) {
            drawable2.setColorFilter((ColorFilter)AppCompatDrawableManager.createTintFilter(tint.mHasTintList ? tint.mTintList : null, tint.mHasTintMode ? tint.mTintMode : DEFAULT_MODE, state));
        } else {
            drawable2.clearColorFilter();
        }
        if (Build.VERSION.SDK_INT <= 10) {
            drawable2.invalidateSelf();
        }
    }

    private static boolean shouldMutateBackground(Drawable drawable2) {
        Drawable.ConstantState state;
        if (Build.VERSION.SDK_INT >= 16) {
            return true;
        }
        if (drawable2 instanceof LayerDrawable) {
            return Build.VERSION.SDK_INT >= 16;
        }
        if (drawable2 instanceof InsetDrawable) {
            return Build.VERSION.SDK_INT >= 14;
        }
        if (drawable2 instanceof DrawableContainer && (state = drawable2.getConstantState()) instanceof DrawableContainer.DrawableContainerState) {
            DrawableContainer.DrawableContainerState containerState = (DrawableContainer.DrawableContainerState)state;
            for (Drawable child : containerState.getChildren()) {
                if (AppCompatDrawableManager.shouldMutateBackground(child)) continue;
                return false;
            }
        }
        return true;
    }

    private static PorterDuffColorFilter createTintFilter(ColorStateList tint, PorterDuff.Mode tintMode, int[] state) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(state, 0);
        return AppCompatDrawableManager.getPorterDuffColorFilter(color2, tintMode);
    }

    private static PorterDuffColorFilter getPorterDuffColorFilter(int color2, PorterDuff.Mode mode) {
        PorterDuffColorFilter filter = COLOR_FILTER_CACHE.get(color2, mode);
        if (filter == null) {
            filter = new PorterDuffColorFilter(color2, mode);
            COLOR_FILTER_CACHE.put(color2, mode, filter);
        }
        return filter;
    }

    private static void setPorterDuffColorFilter(Drawable d, int color2, PorterDuff.Mode mode) {
        d.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(color2, mode == null ? DEFAULT_MODE : mode));
    }

    static {
        COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
        COLORFILTER_TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha, R.drawable.abc_ab_share_pack_mtrl_alpha};
        TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_ab_back_mtrl_am_alpha, R.drawable.abc_ic_go_search_api_mtrl_alpha, R.drawable.abc_ic_search_api_mtrl_alpha, R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_ic_clear_mtrl_alpha, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha, R.drawable.abc_ic_menu_moreoverflow_mtrl_alpha, R.drawable.abc_ic_voice_search_api_mtrl_alpha};
        COLORFILTER_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha, R.drawable.abc_text_cursor_material};
        COLORFILTER_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
        TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_edit_text_material, R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material, R.drawable.abc_spinner_mtrl_am_alpha, R.drawable.abc_spinner_textfield_background_material, R.drawable.abc_ratingbar_full_material, R.drawable.abc_switch_track_mtrl_alpha, R.drawable.abc_switch_thumb_material, R.drawable.abc_btn_default_mtrl_shape, R.drawable.abc_btn_borderless_material};
        TINT_CHECKABLE_BUTTON_LIST = new int[]{R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material};
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color2, mode));
        }

        PorterDuffColorFilter put(int color2, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color2, mode), filter);
        }

        private static int generateCacheKey(int color2, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color2;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }

    public static interface InflateDelegate {
        @Nullable
        public Drawable onInflateDrawable(@NonNull Context var1, @DrawableRes int var2);
    }
}

