﻿Imports System
Imports System.Threading
Imports System.IO.Ports
Imports System.ComponentModel

'http://www.theengineeringprojects.com/2012/10/microsoft-visual-basic-2010-com-port.html
Public Class Form1

    ' we want to have the serial port thread report back data received, but to display
    ' that data we must create a delegate function to show the data in the richTextBox
    ' define the delegate
    Public Delegate Sub SetText()
    ' define an instance of the delegate
    Private setTextI As SetText
    ' create a string that will be loaded with the data received from the port
    Public str As String = ""
    Public Dte As DateTime = DateTime.Now

    Public ExtTempF As Double
    Public TempF As Double
    Public ExtRH As Double
    Public ExtVcc As Double
    Public ExtBP As Double     'Barometric pressure
    Public ExtRainAccum As Double
    Public MPH As Double
    Public GustMPH As Double
    Public Twc As Double        'Temperature Wind Chill
    Public WindDir As Double    'Wind direction
    Public Counter As Long
    Public DirInt As Double     'Direction Integer
    Public TotalRain As Double

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        SerialPort1.Encoding = System.Text.Encoding.Default
        TextBox2.Text = FormatDateTime(Dte, DateFormat.GeneralDate)

        GetSerialPortNames()
    End Sub
    Sub GetSerialPortNames()
        ' Show all available COM ports. 
        For Each sp As String In My.Computer.Ports.SerialPortNames
            ListBox1.Items.Add(sp)
        Next
    End Sub

    Private Sub ListBox1_SelectedValueChanged(sender As Object, e As EventArgs) Handles ListBox1.SelectedValueChanged
        SerialPort1.PortName = ListBox1.Text

        Try
            SerialPort1.Close()
            SerialPort1.Open()
            ListBox1.Visible = False
        Catch ex As Exception
            MessageBox.Show("Could not open Serial port!")
        End Try
    End Sub
 
    Private Sub Form1_Leave(sender As Object, e As EventArgs) Handles MyBase.Leave
        SerialPort1.Close()
    End Sub

    Private Sub SerialPort1_DataReceived(sender As Object, e As IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived
        ' instantiate the delegate to be invoked by this thread
        setTextI = New SetText(AddressOf mySetText)
        ' load the data into the string
        Try
            str = SerialPort1.ReadLine

        Catch ex As System.Exception
            MessageBox.Show("Error - port_DataReceived Exception: ", ex.ToString())
        End Try
        ' invoke the delegate in the MainForm thread
        Me.Invoke(setTextI)

    End Sub

    ' create the instance of the delegate to be used to write the received data
    Public Sub mySetText()

        Dte = DateTime.Now
        TextBox2.Text = FormatDateTime(Dte, DateFormat.GeneralDate)

        'Serial.println("$, ExtTempC, ExtRH, ExtVCC, ExtBP, ExtRainAccum, MPH, GustMPH, WindDir
        Dim SplitSTR() As String = str.Split(",")

        SplitSTR(0) = Strings.Right(SplitSTR(0), Len(SplitSTR(0)) - 1) 'Strip off $
        Try

            If (Double.TryParse(SplitSTR(0), ExtTempF)) Then
                txtTempF.Text = ExtTempF
            End If
            If (Double.TryParse(SplitSTR(1), ExtRH)) Then
                txtRH.Text = ExtRH
            End If
            If (Double.TryParse(SplitSTR(2), ExtVcc)) Then
                txtBatVolt.Text = ExtVcc
            End If
            If (Double.TryParse(SplitSTR(3), ExtBP)) Then
                txtBP.Text = ExtBP
            End If
            If (Double.TryParse(SplitSTR(4), ExtRainAccum)) Then
                txtRain.Text = Format(ExtRainAccum * 0.010791, "0.0")
            End If
            If (Double.TryParse(SplitSTR(5), MPH)) Then
                txtMPH.Text = MPH
            End If
            If (Double.TryParse(SplitSTR(6), GustMPH)) Then
                txtGust.Text = GustMPH
            End If
            If (Double.TryParse(SplitSTR(7), WindDir)) Then
                GetDirection()
            End If
            If (Double.TryParse(SplitSTR(8), Twc)) Then
                txtTwc.Text = Twc
            End If
            If (Long.TryParse(SplitSTR(9), Counter)) Then
                txtCounter.Text = Counter
            End If
        Catch ex As Exception

        End Try
        TotalRain += Format((ExtRainAccum * 0.010791), "0.0")
        txtTotalRain.Text = TotalRain
        If (txtMPH.Text > txtMaxWind.Text) Then
            txtMaxWind.Text = txtMPH.Text
        End If
        If (txtGust.Text > txtMaxGust.Text) Then
            txtMaxGust.Text = txtGust.Text
        End If

    End Sub
    Public Sub GetDirection()
        If (WindDir > 348.75) Or (WindDir <= 11.25) Then
            txtDirection.Text = "North"
        End If
        If (WindDir > 11.25) And (WindDir <= 33.75) Then
            txtDirection.Text = "NNE"
        End If
        If (WindDir > 33.75) And (WindDir <= 56.25) Then
            txtDirection.Text = "NE"
        End If
        If (WindDir > 56.25) And (WindDir <= 78.75) Then
            txtDirection.Text = "ENE"
        End If
        If (WindDir > 78.75) And (WindDir <= 101.25) Then
            txtDirection.Text = "East"
        End If
        If (WindDir > 101.25) And (WindDir <= 123.75) Then
            txtDirection.Text = "ESE"
        End If
        If (WindDir > 123.75) And (WindDir <= 146.25) Then
            txtDirection.Text = "SE"
        End If
        If (WindDir > 146.25) And (WindDir <= 168.75) Then
            txtDirection.Text = "SSE"
        End If
        If (WindDir > 168.75) And (WindDir <= 191.25) Then
            txtDirection.Text = "South"
        End If
        If (WindDir > 191.25) And (WindDir <= 213.75) Then
            txtDirection.Text = "SSW"
        End If
        If (WindDir > 213.75) And (WindDir <= 236.25) Then
            txtDirection.Text = "SW"
        End If
        If (WindDir > 236.25) And (WindDir <= 258.75) Then
            txtDirection.Text = "WSW"
        End If
        If (WindDir > 258.75) And (WindDir <= 281.25) Then
            txtDirection.Text = "West"
        End If
        If (WindDir > 281.25) And (WindDir <= 303.75) Then
            txtDirection.Text = "WNW"
        End If
        If (WindDir > 303.75) And (WindDir <= 326.25) Then
            txtDirection.Text = "NW"
        End If
        If (WindDir > 326.25) And (WindDir <= 348.75) Then
            txtDirection.Text = "NNW"
        End If
    End Sub
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        TotalRain = 0
        txtTotalRain.Text = 0
    End Sub
End Class
