package org.android.uploadthingspeakapp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import android.os.Message;

public class ConnectedThread extends Thread {
	
	//this class enables listening on the serial port (BluetoothSocket)
	//as well as updating data on ThingSpeak
	
	private final BluetoothSocket socket;
    private final InputStream inputStream;
    private final Handler handler;
    private final int MESSAGE_READ = 1;
    private final int DEVICE_CONNECTED = 2;
    
	//sensor labels, and the fields they correspond to in my Thingspeak account
    private final String labels[] = {"tempDHT",  "lumin",  "humidDHT",  "airQUAL",  "sonEB",   "sonDFR", "tempTMP" };
    private final String fields[] = { "field1",  "field7",  "field3",   "field8",   "field5",  "field6", "field2" };
    static final String SERVER   = "http://api.thingspeak.com/update?key=US69F23NS765DXXG"; //the root of the Thingpseak update url
    String url; //the http command used to update Thingspeak
    
    ConnectedThread(BluetoothSocket s, Handler h){
    	socket = s;
    	handler = h;
    	InputStream tmpIn = null;
    	
    	try {
    		socket.connect();
    		if (socket.isConnected()){
    			Message msg;
            	msg = handler.obtainMessage(DEVICE_CONNECTED, 0, 0, null);
            	msg.sendToTarget();
    		}
    		
    		tmpIn = socket.getInputStream();
        } 
    	catch (IOException e) {
    		e.printStackTrace();
    	}
 
    	inputStream = tmpIn;
    }
    
    public void run() {
        byte[] buffer = new byte[1];  // buffer store for the stream. only one byte, to do unbuffered reading
        String dataRead;
        String dataToSend = ""; //when we hit a line break, we send the data
    	
        // Keep listening to the InputStream until an exception occurs
        while (true) {
        try{
        	/*
        	//int bytes = inputStream.read(buffer);
        	//buffered reading
        	//not really feasible, because we don't know how many "lines" we get in one read()
        	if (bytes > 0){
        		String tmp = new String(buffer);
        		dataBuffer += tmp;
        		String[] splitString = dataBuffer.split(";");
        	}*/
        	
        	//unbuffered read
        	inputStream.read(buffer);
        	dataRead = new String (buffer);
        	
        	if (dataRead.equals("-1")){
        		//no more content in the input stream. continue looping without doing anything
        	}
        	else if (dataRead.equals("\n")){
        		//end of line: send data to Thingspeak
        		updateThingspeak(dataToSend);
        		//communicate back to the UI that we have read the line
        		Message msg;
            	msg = handler.obtainMessage(MESSAGE_READ, 0, 0, dataToSend);
            	msg.sendToTarget();
            	/*another possibility
                Bundle b = new Bundle();
                b.putString("receivedData", data);
                msg.setData(b);
                handler.sendMessage(msg);
                */
            	//then reset data
            	dataToSend = "";
        	}
        	else{
        		dataToSend += dataRead;
        	}
        }
        catch (IOException e) {
        	e.printStackTrace();
        }
        }
    }
 
    private void updateThingspeak(String data) {
        //parse the message and send to Thingspeak.
        //reset of the URL adress
        url = SERVER;
        
        //all the data fields are split by semicolon
        String[] data_fields = data.split(";");
        
        //each data_field is composed of the label, then the value, separated by a coma
        for (int j = 0; j < data_fields.length; j++){
          String[] data_split = data_fields[j].split(",");
          
          if (data_split[0] != null && data_split[1] != null){
            String data_label = data_split[0];
            float data_value = Float.valueOf(data_split[1]);
            
            //check which label it is, and update the URL with the relevant field number
            for (int i = 0; i < labels.length; i++)
                if (data_label.equals(labels[i]))
                	url += "&" + fields[i] + "=" + data_value;
          }
        }
        
        //Lastly, send the URL to ThingSpeak for update
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new java.net.URL(url).openStream()));
        }
        catch (java.io.IOException e) {} 
		
	}
}
