/*

this program is for measuring the distance between the ultrasonic sensor and any other object in front of the sensor 
if the distance is greater than 20CM is Buzzer will make a noisy beeb sound.
if the distance is not greater than 20CM the Buzzer will make no sound.

*/

#define trigPin A1                       //define a constant called trigPin for the pin A1
#define echoPin A0                       //define a constant called echoPin for the pin A0

#define buzzer A2                        //define a constant called buzzer for the pin A2

void setup() {

  pinMode(trigPin, OUTPUT);                     //set the trigPin as an OUTPUT Pin, the trigPin responsible for sending a signal to the sensor to send out the ultrasonic wave
  pinMode(echoPin, INPUT);                      //set the echoPin as an INPUT pin, the choPin responsible for receiving the wave.

  pinMode(buzzer, OUTPUT);                      //set the buzzer as an OUTPUT pin, the buzzer responsible for making the sound.


  Serial.begin(9600);                           //initialize the serial monitor at baud rate 9600

}

void loop() {

  if(measuredDistance() >= 20){                 //if the distance is greater tha 20CM the Buzzer will make a noisy sound
    tone(buzzer, 500);                              
  }
  else {                                        //if the distance is not greater than 20CM the Buzzer will make no Sound
    noTone(buzzer);
  }

  Serial.print("distance in CM is equal:  ");                      //print on the Serial Monitor   "distance in CM is equal:  "
  Serial.println(measuredDistance());                              //calling the measuredDistance function which returns the distance measured.
  
}

/*
  This function Takes No Arguments
  return the distance in CM which measured by the ultrasonic sensor, 
  the Data type of the returned value is (long)
  this function is responsible for sending out the ultrasonic wave and receiving it back and calculationg the distance
*/

long measuredDistance() {

  long duration, distance; 
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);                           // delays are required for a succesful sensor operation.
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);                            //this delay is required
  digitalWrite(trigPin, LOW);
  duration = pulseIn(echoPin, HIGH);              //reseiving back the ultrasonic wave
  distance = (duration / 2) / 29.1;                // convert the distance to centimeters.
  delay(2);                                         //delay 2 milliseconds to not make the buffer full which will cause a problem with the serial communication.
  return distance;
}

