/*
 * interfacing the ultrasonic sensor HC-SR04 only with the PICO board
*/

#define trigPin A1                              //define a constant called trigPin for the pin A1
#define echoPin A0                              //define a constant called echoPin for the pin A0

void setup() {


  pinMode(trigPin, OUTPUT);                             //set the trigPin as an OUTPUT Pin, the trigPin is responsible for sending a signal to the sensor to send out the ultrasonic wave
  pinMode(echoPin, INPUT);                              //set the echoPin as an INPUT pin, the choPin is responsible for receiving the wave.

  Serial.begin(9600);                                   //initialize the serial monitor at baud rate 9600

}

void loop() {

  Serial.print("distance in CM is equal:  ");                     //print on the Serial Monitor   "distance in CM is equal:  "
  Serial.println(measuredDistance());                             //calling the measuredDistance function which returns the distance measured.

}

/*
  This function Takes No Arguments
  return the distance in CM which measured by the ultrasonic sensor, 
  the Data type of the returned value is (long)
  this function is responsible for sending out the ultrasonic wave and receiving it back and calculationg the distance
*/

long measuredDistance() {

  long duration, distance;
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);                                //delays are required for succesful sensor operation.
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);                               //this delay is required
  digitalWrite(trigPin, LOW);
  duration = pulseIn(echoPin, HIGH);                   //receiving back the ultrasonic wave
  distance = (duration / 2) / 29.1;                    //convert the distance to centimeters.
  delay(2);                                            //delay 2 milliseconds to not make the buffer full which will cause a problem with the serial communication.
  return distance;
}

