/*
 Author : MEZIERE Fabien
 Project : SRO2003
 Website : https://www.instructables.com/member/-SRO2-/
 Description : This is the source code of my UVLamp, for more information or any suggestion go to the website ;)

   This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>. 1
*/

#include "E:\Projets electronique\UVLamp\Programmation\UVLamp.h"

// Boolean variable (flag)
short switchDigit=0;
short inhibitTimer=1;
short uvLightOn=0;
short startBuzzer=0;

// Set segments of 7-seg display for each digit
const int numberZero=0x40 , numberOne=0x79 , numberTwo=0x24 , numberThree=0x30 , numberFour=0x19 , numberFive=0x12 , numberSix=0x02 , numberSeven=0x78 , numberEight=0x00 , numberNine=0x10;
// Set the previous variables in an array to access its easly
int arrayNumber[10] = {numberZero , numberOne , numberTwo , numberThree , numberFour  ,numberFive , numberSix , numberSeven , numberEight , numberNine};

int countdown=0; // Variable containing the countdown value
long minuteCounter=0; // Variable used to count the number of minutes actually elapsed
long delaybuzzer=0; // Variable used to control the duration of alarm sound
int unit; // Variable containing the unit of the countdown
int ten; // Variable containing the ten of the countdown

// Function declaration
void TimeManagment();


// Overflow RTCC 2ms for countdown and multiplex display
#int_RTCC
RTCC_isr() 
{	
	TimeManagment();

	unit = countdown%10; // Detect the number of the unit of countdown
 	ten = (countdown/10)%10; // Detect the number of the ten of countdown
 	
	if (switchDigit==0)	// Set the good value on port B and power on the digit display of ten
	{
		output_low(pin_a7);
		output_high(pin_a6);
		output_b(arrayNumber[ten]);
		switchDigit=1;
	}
	else	// Set the good value on port B and power on the digit display of unit
	{	
		output_low(pin_a6);
		output_high(pin_a7);
		output_b(arrayNumber[unit]);
		switchDigit=0;
	}
	
	if (startBuzzer==1)
	{	
		delaybuzzer++;
		if (delaybuzzer==1)
		{
			output_high(pin_A3);
		}
		if (delaybuzzer==500)
		{
			output_low(pin_A3);
			startBuzzer=0;
			delaybuzzer=0;
		}		
	}
}


#int_TIMER2
TIMER2_isr() 
{

}


void main()
{
	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_8);
	setup_timer_1(T1_DISABLED);
	setup_timer_2(T2_DIV_BY_16,250,1);
	setup_comparator(NC_NC_NC_NC);
	setup_vref(FALSE);
	enable_interrupts(INT_RTCC);
	enable_interrupts(INT_TIMER2);
	enable_interrupts(GLOBAL);

	while(1)
	{
		if (input(pin_A0)==1 && countdown<99)	// The user push the "set timer button" to set the LED lighting duration
		{
			countdown++;
			delay_ms(150);
		}
		
		if (input(pin_A1)==1)
		{
			do							// Waiting to debounce the button
			{
				delay_ms(5);
			}while(input(pin_A1)==1);	// Wait until user release the button
			if (uvLightOn==0)			// If UV LEDs are off
			{
				inhibitTimer=0;			// Allow the timer to run (in order to count second and decrease the countdown)
				uvLightOn=1;			// Set flag UV LEDs on to 1
				output_low(pin_A4);		// Power on "status LED"
				output_high(pin_A2);	// Power on UV LEDs
			}
			else						// If UV LEDs are already on
			{							
				output_high(pin_A4);	// Power off "status LED"
				output_low(pin_A2);		// Power off UV LEDs
				inhibitTimer=1;			// Inhibit the timer
				uvLightOn=0;			// Set flag UV LEDs on to 0
				countdown=0;			// Set countdown to 0
			}
		}	
		delay_us(1);
	}
}

// This function is called every 2ms by RTCC timer, it manages the countdown
void TimeManagment()
{
	if (inhibitTimer==0)
	{
		minuteCounter++;
		if (minuteCounter==30000 && countdown!=0)	// When the function is called 30000 times it means that one minute has passed, so the counter is reduced by one minute
		{
			countdown--;
			minuteCounter=0;
			if (countdown==0)			// When the countdown reaches 0 (finish)
			{
				output_high(pin_A4);	// Power off "status LED"
				output_low(pin_A2);		// Power off UV LEDs
				uvLightOn=0;			// Set the flag uvLightOn to false because UV LEDs are power off
				startBuzzer=1;			// Set the flag startBuzzer to true in order to start the sound alarm
				inhibitTimer=1;			// Inhibit the timer in order to forbiden the descrease of the countdown
			}
		}
	}
}