   /************************************************************************************************

American flag representation, not to scale

*  * * * * *  * =================================
* *  * * *  * * =================================
* *  * *  * * * =================================
* * * * * * * * =================================
* * *  * * *  * =================================
* *  * *  * * * =================================
* * *  * * *  * =================================
=================================================
=================================================
=================================================
=================================================
=================================================
=================================================
  
    Name      LED Patterns for American Flag Project                                
    Author    Abdul Tairu
    Date      August 22, 2014    
    Modified                                  
    Version   1.0.0      
    Arduino Version   1.0.4
    Arduino Boards: Any board with free output pin (digital or analog)
    
    LED Count:
    ------------------------
    Red:     960
    White:   905
    Blue:    475
    Grand Total: 2,340
    Pixel Resolution: 60X39
    ------------------------
    
    Notes     I have utilized the Software Pulse Width Modulation by bhagman found at at the following URL:
              https://code.google.com/p/rogue-code/wiki/SoftPWMLibraryDocumentation
              I have also used pattern ideas got from modified Bob Powell's sketch at -
              https://github.com/texanfromiowa/Demo_10leds_1
              
  ************************************************************************************************/
  
  /* Sketch start */
  
  /* Global stuffs start*/
  
  //Adding ref to software pwm so any output pin can be used for pulse width modulation (digital or analog)
  #include <SoftPWM.h>
  
  // Define a constant variable to hold the number of pins on the Arduino to be control (This is for the 13 stripes)
  const int NUM_LED = 13;
  
  // Define a constant variable to hold the number of pins on the Arduino to be control (This is for Blue and white star)
  // This is separated so they can be controlled independent of the 13 stripes
  const int BWBlue = 35;
  const int BWWhite = 36;
  
  // Define a constant variable to hold the leds Brightness, made possible by the software PWM on any Arduino pin
  // This brightness level is based on the super brite LED, for difussed leds, this can be increased
  int BlueBright = 50; // Brightness of blue leds
  int WhiteBright = 70; // Brightness of white star leds
  
  // Brightness levels for individual red and white leds on the 13 stripes
  int strpRedBright = 35; // Brightness of red in the 13 stripes leds
  int strpWhiteBright = 70; // Brightness of white in the 13 stripes leds
  
  // Array of LED for the 13 stripes, to make them contigous
  bool LED[NUM_LED];
  
  // Define a array variable to hold the number of pins on the Arduino to be control (The 13 stripes)
  uint8_t leds[] = {22,23,24,25,26,27,28,29,30,31,32,33,34}; // MEGA Pin outs 
  
  /* Global stuffs ends*/
  
  /* Setup */
  
  void setup(void) {
    
    // Start the software PWM
    SoftPWMBegin();
    
    //Turn everything off
    allOff();
    
    SoftPWMSetFadeTime(BWWhite, 1000, 1000);
  }
  
  /* Setup ends */
  
  /* Loop start */
  
  //Loop through all the effects...
  void loop(void) {
    
      // Define variable that establishes delay between effects
      int loopDelay = 1500;
      
      // Stay on for timed period
      stayOnTimed(300000L); //One minute = 60000 milliseconds; 120000 = 2 minutes, 300000 = 5 minutes
      delay(loopDelay);
      
      //Now resume patterns
      
      // Flash all leds, to let us know its on
        flashAll(500, 5);
        delay(loopDelay);
      
      // Flash odd leds only
        flashOdd(500, 5);
        delay(loopDelay);
        
      // Flash even leds only  
        flashEven(500, 5);
        delay(loopDelay);

       //Flickers all leds - on
        flickerOn(210);
        delay(loopDelay);
     
       // criss-cross effect
        crissCross(200, 5);
        delay(loopDelay);
      
      // Count up from a number to another -- in binary!!
        countUp(0, 4400, 20, false); //count up to 4400 got as far as 13th stripe. Long effect, better to run it one time
        delay(loopDelay);
    
      // The Knight Rider effect
          knightRider(40, 2, 3);
          delay(loopDelay);
      
      //Flickers all leds - off
        flickerOff(210);
        delay(loopDelay);

}
  
  /* Loop ends */
  
  /* Functions definition start */


    /**************************************************************
    Function: blinkWhiteStars
    Purpose:  Blinks all white star leds
    Args:     int duration - how long an led is on 
              int sbright - max brightness of white star leds
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void blinkWhiteStars(int duration, int mBright) //
    {      
        
        SoftPWMSet(BWWhite, mBright);
        delay(duration);
        SoftPWMSet(BWWhite, 0);
        delay(duration);
    }

    /**************************************************************
    Function: stayOnTimed
    Purpose:  Flashes all leds
    Args:     int duration - how long an led is on 
    Returns:  nothing
    Notes:    
    ***************************************************************/
    //Had to use unsigned long because staying on for more than 30sec caused issues with milis function, thanks to a friend here - Razaq
    void stayOnTimed(unsigned long duration) 
    { 
      long previousMillis = 0;                 // Variable to store last time white leds were updated
      unsigned long currentMillis = millis();  // Variable to current time of white leds update
      
      //Keep blue leds on
      SoftPWMSet(BWBlue, BlueBright);
      
      //Keep the 13 stripes on
      for (int i = 0; i < NUM_LED; i++)
       {
         if (i % 2 == 0){
         SoftPWMSet(leds[i], strpRedBright);
         }
         else
         {
           SoftPWMSet(leds[i], strpWhiteBright);
         }
       }
            
      previousMillis = millis();
      
      do {
        blinkWhiteStars(500,BlueBright); // Blink the white stars at brightness level of the set white star leds
        currentMillis = millis();
      }
      while (currentMillis - previousMillis < duration); // Keep blinking white star leds while the difference between current time and last time they blinked is less than
                                                         // the time the entire time the whole leds will stay on
    }
    
    /**************************************************************
    Function: allOn
    Purpose:  Turns on all leds
    Args:     none
    Returns:  none
    Notes:    
    /**************************************************************/  
    void allOn()
    {
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      for (int i = 0; i < NUM_LED; i++)
       {
         if (i % 2 == 0){
         SoftPWMSet(leds[i], strpRedBright);
         }
         else
         {
           SoftPWMSet(leds[i], strpWhiteBright);
         }
       }
        
    }
    
    /**************************************************************
    Function: allOff
    Purpose:  Turns off all leds
    Args:     none
    Returns:  none
    Notes:    
    **************************************************************/  
    void allOff()
    {
      SoftPWMSet(BWBlue, 0);
      SoftPWMSet(BWWhite, 0); 
      
      for (int i = 0; i < NUM_LED; i++)
       {
         SoftPWMSet(leds[i], 0);
       }
    }
 
    /**************************************************************
    Function: flashAll
    Purpose:  Flashes all leds
    Args:     int duration - how long an led is on 
              int count - how many times to flash
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void flashAll(int duration, int count)
    {
      for(int i = 0; i < count; i++)
      {
        allOn();
        delay(duration);
        allOff();
        delay(duration);
      }  
     
    }
    
    /**************************************************************
    Function: evenOn
    Purpose:  Turns ON even leds
    Args:     none
    Returns:  none
    Notes:    
    **************************************************************/  
    void evenOn()
    {
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      for (int i = 1; i < NUM_LED; i += 2)
       {
         if (i % 2 == 0){
         SoftPWMSet(leds[i], strpRedBright);
         }
         else
         {
           SoftPWMSet(leds[i], strpWhiteBright);
         }
       }
    }
    
    /**************************************************************
    Function: oddOn
    Purpose:  Turns ON even leds
    Args:     none
    Returns:  none
    Notes:    
    **************************************************************/  
    void oddOn()
    {
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      for (int i = 0; i < NUM_LED; i += 2)
       {
         if (i % 2 == 0){
         SoftPWMSet(leds[i], strpRedBright);
         }
         else
         {
           SoftPWMSet(leds[i], strpWhiteBright);
         }
       }
    }
    
    /**************************************************************
    Function: flashOdd
    Purpose:  Flashes odd leds
    Args:     int duration - how long an led is on 
              int count - how many times to flash
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void flashOdd(int duration, int count)
    {
      allOff();
      
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      for(int i = 0; i < count; i++)
      {
        oddOn(); 
        delay(duration);
        allOff();
        delay(duration);
      }
    }  
    
    /**************************************************************
    Function: flashEven
    Purpose:  Flashes even leds
    Args:     int duration - how long an led is on 
              int count - how many times to flash
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void flashEven(int duration, int count)
    {
      allOff();
      
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      for(int i = 0; i < count; i++)
      {
        evenOn(); 
        delay(duration);
        allOff();
        delay(duration);
      }
    }  
    
    /**************************************************************
    Function: crissCross
    Purpose:  Criss-Cross effect
    Args:     int duration - how long an led is on 
              int count - how many times to cycle through effect
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void crissCross(int duration, int count)
    {
      // Clear the array and turns off any leds still on 
      allOff();
      
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      // Create variables
      int firstled;
      int lastled;
      
      for(int i = 0; i < count; i++)
      {
        for(int j = 0; j < NUM_LED; j++)
        {
          // if its the start of a loop through the leds,
          // reset the variables to their starting position.
          if(j == 0){
            firstled = 0;
            lastled = NUM_LED -1;
          }
          
         if (firstled % 2 == 0){
           SoftPWMSet(leds[firstled], strpRedBright);
           SoftPWMSet(leds[lastled], strpWhiteBright);        
         }
         else
         {
           SoftPWMSet(leds[lastled], strpWhiteBright);
           SoftPWMSet(leds[firstled], strpRedBright);
         }
         
          //SoftPWMSet(leds[firstled], RedWhiteBright);
          //SoftPWMSet(leds[lastled], RedWhiteBright);
          
          // Skip the delay if the center leds are crossing
          // or if the leds have reached the ends.
          // This code was changed to be human readable and 
          // is not the most effecient.
          if(lastled == (firstled +1)){}
            // do nothing - skip delay
          else if (lastled == 0){}
            // do nothing - skip delay
          else
            delay(duration);
            
          // Turn off the last leds we just turned on
          SoftPWMSet(leds[firstled], 0);
          SoftPWMSet(leds[lastled], 0);
          // increment variables
          firstled++;
          lastled--;
        }
      }
      
      // turn the last leds off
      delay(duration);
      allOff();
    }

   
    /**************************************************************
    Function: flickerOn
    Purpose:  Flashes all leds in flicker fashion from off to on
    Args:     int dur duration of flikering
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void flickerOn(int dur)
    {
      int i = dur;
      while(i != 0)
      {
        allOn();
        delay(i);
        allOff();
        delay(i);
        i-= 5;
      }
    }
  
    /**************************************************************
    Function: flickerOff
    Purpose:  Flashes all leds in flicker fashion from off to on
    Args:     int dur duration of flikering
    Returns:  nothing
    Notes:    
    ***************************************************************/
    void flickerOff(int dur)
    {
      allOn();
      for(int i = 0; i!= dur; i+=5)
      {
        allOff();
        delay(i+50);
        allOn();
        delay(i);
      }
    }
  
    /**************************************************************
    Function: countUp
    Purpose:  Count up, in binary, from one number to another
    Args:     int duration - how long an led is on 
              int startNum - starting number
              int endNum - ending number
              bool reverse - true or false - a value of true
                           - reverses the normal direction
    Returns:  nothing
    Notes:    
    **************************************************************/
    void countUp(int startNum, int endNum, int duration, bool reverse)
    {
     // Clear the array and turns off any leds still on 
     allOff(); 
     
     if((endNum <= startNum) || (endNum < 0))
        return;
    
      for (int numberToDisplay = startNum; numberToDisplay <= endNum; numberToDisplay++) {
      
        setArray(numberToDisplay);
        if(reverse == true){
          writeBytesRev();
        }
        else{
          writeBytes();
        }
        delay(duration);
      }
      
      allOff(); 
      writeBytes();
    
    } 
    
    /**************************************************************
    Function: countDown
    Purpose:  Count down, in binary, from one number to another
    Args:     int duration - how long an led is on 
              int startNum - starting number
              int endNum - ending number
              bool reverse - true or false - a value of true
                           - reverses the normal direction
    Returns:  nothing
    Notes:    
    **************************************************************/
    void countDown(int startNum, int endNum, int duration, bool reverse)
    {
     // Clear the array and turns off any leds still on 
     allOff(); 
    
     if(endNum >= startNum)
        return;
        
      for (int numberToDisplay = startNum; numberToDisplay > endNum; numberToDisplay--) {
        setArray(numberToDisplay);
    
        if(reverse == true)
          writeBytesRev();
        else
          writeBytes();
        
        delay(duration);
      }
      
      // turn off the last led
      allOff(); 
      writeBytes();
    }  
    
    /**************************************************************
    Function: knightRider
    Purpose:  "Knight Rider" effect from the TV show
    Args:     int duration - how long an led is on 
              int count - how many times to cycle through effect
              int numleds - how many leds are on at a time
    Returns:  nothing
    Notes:    This is not a perfect implementaion of the effect.
              A perfect effect would include a dimming of the 
              trainling leds (using PWM). Its still cool! 
    **************************************************************/
    void knightRider(int duration, int count, int numleds)
    {
      // Clear the array and turns off any leds still on 
      allOff();
      
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      writeBytes();
      
      duration = duration / numleds;
      int trailingleds = numleds - 1;
      int ledcounter = NUM_LED + trailingleds;
      
      for(int i = 0; i < count; i++)
      {
        // cycle through one direction
        for(int j = 0; j < ledcounter -1 ; j++)
        {
          if (j % 2 == 0){
           SoftPWMSet(leds[j], strpRedBright);        
         }
         else
         {
           SoftPWMSet(leds[j], strpWhiteBright);
         }
         
          //SoftPWMSet(leds[j], RedWhiteBright);
          
          writeBytes();
          delay(duration);
          SoftPWMSet(leds[j + 1], 0);
          SoftPWMSet(leds[j - trailingleds], 0);
          writeBytes();
          // Skip the extra delay() commands as the 
          // trailing leds catch up.
          if(j < NUM_LED)
            delay(duration);    
        }
        // cycle back in the oppisite direction
        for(int j = ledcounter; j > -trailingleds; j--)
        {
          if (j % 2 == 0){
           SoftPWMSet(leds[j], strpRedBright);        
         }
         else
         {
           SoftPWMSet(leds[j], strpWhiteBright);
         }
         
          //SoftPWMSet(leds[j], RedWhiteBright);
          
          writeBytes();
          // Skip the initial delay() commands as the 
          // trailing leds start back.
          if(j < NUM_LED -1){
            delay(duration);
          
          if (j % 2 == 0){
           SoftPWMSet(leds[j -1], strpRedBright);        
         }
         else
         {
           SoftPWMSet(leds[j -1], strpWhiteBright);
         }
          //SoftPWMSet(leds[j - 1], RedWhiteBright);
          
          SoftPWMSet(leds[j + trailingleds], 0);
          writeBytes();
          delay(duration);
          }   
        }
      }
      
     // Turn the last led off 
     allOff(); 
     writeBytes();
    }
   
  /**************************************************************
    Function: sumArray
    Purpose:  Take a binary representation of the array of ON and OFF
              positions, and generates an integer.
    Args:     int array[]
    Returns:  integer of the total
    Notes:    See comments on bit shifting at the beginning
              of this file.
    **************************************************************/  
    int sumArray(bool array[])
    {
       int total = 0;
       
       for (int i = 0; i < NUM_LED; i++)
       {
         if (array[i] == 1)
    	 total = total + (1<<i);
       }
       
       return(total);
    }
    
    /**************************************************************
    Function: setArray
    Purpose:  Sets the primary array to the binary of the number
              given.
    Args:     int num - number to put into array
    Returns:  nothing
    Notes:    See comments on bit shifting at the beginning
              of this file.  Since this is an integer, it must be
              between -32,768 and 32,767, HOWEVER, it should 
              always be a positive number (0 to 32,767).
    **************************************************************/  
    void setArray(int num)
    {
      // Clear the array
      allOff();
      
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
            
      int i = 0;
      bool value;
      
       while (num > 0)
       {
         value = num & 1;
         if(value == true)
          // leds[i] = ON;
          if (i % 2 == 0){
           SoftPWMSet(leds[i], strpRedBright);        
         }
         else
         {
           SoftPWMSet(leds[i], strpWhiteBright);
         }
          //SoftPWMSet(leds[i], RedWhiteBright);
         else
         //  leds[i] = OFF;
           SoftPWMSet(leds[i], 0);
           
         num >>= 1;
         i++;
       }  
    }
    
    
    /**************************************************************
    Function: writeBits
    Purpose:  Write the array with Most Significant Bit first (MSFBFIRST)
    Args:     none
    Returns:  nothing
    Notes:    This function is a wrapper function for outBytes()
    ***************************************************************/
    void writeBytes()
    {
      outBytes(MSBFIRST);
    }
    
    
    /**************************************************************
    Function: writeBytesRev
    Purpose:  Write the array with Least Significant Bit first (MSFBFIRST)
    Args:     none
    Returns:  nothing
    Notes:    This function is a wrapper function for outBytes()
    ***************************************************************/
    void writeBytesRev()
    {
      outBytes(LSBFIRST);
    }
    
    /**************************************************************
    Function: outBytes
    Purpose:  Send array data to shift register
    Args:     int dir - First or Least significant bit first
    Returns:  nothing
    Notes:    This is where data is actually sent out, but is not 
              intended to be used directly.  writeBytes() and
              writeBytesRev() should be used instead.
    ***************************************************************/
    void outBytes(int dir)
    {
    
      //Keep blue & stars on
      SoftPWMSet(BWBlue, BlueBright);
      SoftPWMSet(BWWhite, WhiteBright);
      //blinkWhiteStars(WhiteBrightDur, WhiteBright);
      
      if(dir == MSBFIRST){
        for(int i = 0; i < NUM_LED; i++)
        {
          if(leds[i] == 1){
            digitalWrite(leds[i], HIGH);
          }
          else{
            digitalWrite(leds[i], LOW);
          }
        }
      }  
      else{ // (dir == LSBFIRST)
        int j = 0;
        for(int i = NUM_LED -1; i >= 0; i--)
        {
          if(leds[i] == 1)
            digitalWrite(leds[j], HIGH);
          else
            digitalWrite(leds[j], LOW);
          j++;
        }
      } 
    }
   /* Functions definition ends */
   
   /* Sketch Ends */
