/* Information to the Arduino and some Twitter ::
 * ::::::::::::::::::::::::::::::::::::::::::::::
 *
 * robotgrrl.com Sept. 13, 2010
 *
 * Sends info from Twitter or other things to the connected
 * Arduino. 
 *
 * v0.2 - Sept. 14
 * ---------------
 * Added Twitter functionality. Had to get the fancy-shmancy
 * oauth thing to work. To retrieve the access token, call
 * initTwitter(). It will save the URL to a file, where you
 * go there and get the PIN. Put the PIN in pin.txt WITH AN
 * EMPTY LINE AT THE END! So you paste the PIN, then press
 * enter. It's weird, but I was debugging that for hours.
 * Able to retrieve search queries. Have to implement a pop
 * and push system for the tweets to determine which ones are
 * new.
 *
 * v0.1 - Sept. 13
 * ---------------
 * Established connection to the Arduino. Able to write
 * single characters to the arduino port to turn on a
 * light.
 *
 */

import processing.serial.*;
import cc.arduino.*;
import controlP5.*;

PrintWriter output;
static PrintWriter accessTokenOutput;
String[] lines;

Serial port;

String myTimeline;
java.util.List statuses = null;
User[] friends;

Twitter twitter = new TwitterFactory().getInstance();
RequestToken requestToken;

static String token;
static String secret;

String[] theTweets = new String[11];
String[] theRawTweets = new String[11];
String previousTweet;

String[] theSearchTweets = new String[11];
String[] theRawSearchTweets = new String[11];
String[] theSearchUsers = new String[11];
String previousSearchTweet;

int numberOfNewTweets = 10;
int numberOfSearchTweets = 10;
int previousTimeRequestedAt = 0;

String pin = "";

boolean useArduino = false;

int iterations = 0;

void setup() {

	size(500, 500);
	noStroke();
	frameRate(10);
	
	// Used to write some info while initializing the oauth connection
	output = createWriter("url.txt");
	accessTokenOutput = createWriter("tokens.txt");

	//Open the port that the board is connected to and use the same speed (9600bps)
	if(useArduino) port = new Serial(this, Serial.list()[0], 9600);

	// Twitter functions that can be used
	//initTwitter();
	connectTwitter();
	//getStatuses(millis(), true);
	//getTimeline();
	getSearchTweets(millis(), true);

	// Sending the tweets to the Arduino
	for(int i=0; i<numberOfSearchTweets; i++) {
		
		// Will have to double check if this actually works,
		// as it is a String and not a char. The documentation
		// says it supports Strings, so crossing fingers! (TODO)
		if(useArduino) port.write(theSearchTweets[i]);
		if(useArduino) println("Sent message to Arduino!");

	}

}


void draw() {

	background (128);

	// Checking to see if the light is turned on
	if (mouseOverRect() == true) {  //If mouse if over square
		fill(242, 204, 47);                    //change color
		if(useArduino) port.write('H');              //send H to serial port
	} else {            //If mouse is NOT over square
		fill(0);          //change color
		if(useArduino) port.write('L');  //send L to serial port
	}

	rect(50, 50, 100, 100);  //Draws the square

}


boolean mouseOverRect() {    //Tests if mouse is over square

	// Yeah a hit test!
	return ((mouseX >= 50) && (mouseX <= 150) && (mouseY >= 50) && (mouseY <= 150));

}

// This is used to initialize the Twitter, to get the access tokens
void initTwitter() {

	// Put your application's info here.       ###
	twitter.setOAuthConsumer("***", "***");
	//RequestToken requestToken;// = twitter.getOAuthRequestToken();

	// Get the first token, the request token. That's used to get the authourization URL.
	try {
		requestToken = twitter.getOAuthRequestToken();
		println("Got the request token OK");
	} catch(TwitterException e) { 
		println(e.getStatusCode());
	}

	AccessToken accessToken = null;
	String url;

	// This is repeated forever until we get the access token
	while (null == accessToken) {
		
		url = requestToken.getAuthorizationURL();

		// Only do this once to avoid mayhem
		if(iterations == 0) {
			println("Open the following URL and grant access to your account:");
			println(url);
			output.println(url);
			output.flush();
			output.close();
		}

		// Reading in the pin from the file. Default contents is just a space
		lines = loadStrings("pin.txt");
		pin = lines[0];
		println("Pin is: " + pin);
		
		try {

			// See if it has anything more than a space
			if(pin.length() > 1){
				accessToken = twitter.getOAuthAccessToken(requestToken, pin);
			}

			println("Access token: " + accessToken);

		} catch (TwitterException te) {
			if(401 == te.getStatusCode()){
				println("Unable to get the access token.");
				te.printStackTrace();
			} else {
				te.printStackTrace();
			}
		}

		iterations++;

	}

	// Persist to the accessToken for future reference.
	storeAccessToken(accessToken);

	// Send a success tweet if you so desire!
	try {
		Status status = twitter.updateStatus("It worked!");
		println("Successfully updated the status to [" + status.getText() + "].");
	} catch(TwitterException e) { 
		println(e.getStatusCode());
	}

}


// This is for connecting once you obtained the access token info
void connectTwitter() {

	twitter.setOAuthConsumer("4Su2adIesB44mggV8z8nA", "g3lGpewYPLZfLLB5YJJycqJJypoSPz1AJVbSpvbyY");
	AccessToken accessToken = loadAccessToken();
	twitter.setOAuthAccessToken(accessToken);
	
	boolean wantToTweet = false;

	// If you want to tweet...
	if(wantToTweet) {
		try {
			Status status = twitter.updateStatus("It worked!");
			println("Successfully updated the status to [" + status.getText() + "].");
		} catch(TwitterException e) { 
			println(e.getStatusCode());
		}
	}

}


// Printing the access token info to a file
private static void storeAccessToken(AccessToken accessToken){

	token = accessToken.getToken();
	secret = accessToken.getTokenSecret();

	accessTokenOutput.println(token);
	accessTokenOutput.println(secret);
	accessTokenOutput.flush();
	accessTokenOutput.close();
}


// Loading up the access token
private static AccessToken loadAccessToken(){
	// Put your values here...       ###
	String token = "***";// load from a persistent store
	String tokenSecret = "***"; // load from a persistent store
	return new AccessToken(token, tokenSecret);
}


// Get your tweets
void getTimeline() {

	try {
		statuses = twitter.getUserTimeline(); 
	} catch(TwitterException e) { 
		println(e.getStatusCode());
	}

	for(int i=0; i<statuses.size(); i++) {
		Status status = (Status)statuses.get(i);
		println(status.getUser().getName() + ": " + status.getText());
	}

}


// Get your tweets (yeah for some reason it's the same as the above function)
void getStatuses(int timeRequestedAt, boolean initialLoad) {

	String tempTweet;

	try {
		statuses = twitter.getUserTimeline(); 
	} catch(TwitterException e) { 
		println(e.getStatusCode());
	}

	if(initialLoad == false) {

		int i=0;
		Status status = (Status)statuses.get(i);
		tempTweet = status.getText();
		previousTweet = theRawTweets[i];

		while(tempTweet.equals(previousTweet) == false) {
			previousTweet = theRawTweets[i];
			theRawTweets[i] = tempTweet;
			theTweets[i] = tempTweet;
			//formatTweet(account,i);
			i++;
			status = (Status)statuses.get(i);
			tempTweet = status.getText();
		}

		numberOfNewTweets = i;
		println("Number of new tweets: " + numberOfNewTweets);

	} else {

		for(int i=0; i<numberOfNewTweets; i++) {
			Status status = (Status)statuses.get(i); 
			theRawTweets[i] = status.getText();      
			theTweets[i] = theRawTweets[i];
			//formatTweet(account,i);
		}

	}

	previousTimeRequestedAt = timeRequestedAt;

}


// Search for tweets
void getSearchTweets(int timeRequestedAt, boolean initialLoad) {

	String tempTweet;
	boolean failed;

	previousSearchTweet = theRawSearchTweets[0];

	try {
		Query query = new Query("@RobotGrrlsBots");    
		query.setRpp(numberOfNewTweets); // Get 10 of the 100 search results  
		QueryResult result = twitter.search(query);    
		ArrayList tweets = (ArrayList) result.getTweets();    

		for (int i=0; i<tweets.size(); i++) {	
			Tweet t = (Tweet)tweets.get(i);	
			String user = t.getFromUser();
			String msg = t.getText();
			Date d = t.getCreatedAt();	
			theRawSearchTweets[i] = msg;
			theSearchUsers[i] = user;

			println(msg);
		}

		numberOfSearchTweets = tweets.size();
		failed = false;

	} catch (TwitterException e) {    
		println("Couldn't connect: " + e);  
		failed = true;
	}

}



