/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.util;

import java.util.Date;

public final class TimeSpanUtil {
    private static int ONE_HOUR_IN_SECONDS = 3600;
    private static int ONE_DAY_IN_SECONDS = 24 * ONE_HOUR_IN_SECONDS;

    private TimeSpanUtil() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static String toTimeSpanString(Date date) {
        return TimeSpanUtil.toTimeSpanString(date.getTime());
    }

    public static String toTimeSpanString(long milliseconds) {
        int deltaInSeconds = (int)((System.currentTimeMillis() - milliseconds) / 1000L);
        return TimeSpanUtil.toTimeSpanString(deltaInSeconds);
    }

    public static String toTimeSpanString(int deltaInSeconds) {
        int hours;
        if (deltaInSeconds < 5) {
            return "less than 5 seconds ago";
        }
        if (deltaInSeconds < 10) {
            return "less than 10 seconds ago";
        }
        if (deltaInSeconds < 20) {
            return "less than 20 seconds ago";
        }
        if (deltaInSeconds < 40) {
            return "half a minute ago";
        }
        if (deltaInSeconds < 60) {
            return "less than a minute ago";
        }
        if (deltaInSeconds < 2700) {
            int minutes = deltaInSeconds / 60;
            if (minutes == 1) {
                return "1 minute ago";
            }
            return minutes + " minutes ago";
        }
        if (deltaInSeconds < 6300) {
            return "about an hour ago";
        }
        if (deltaInSeconds < ONE_DAY_IN_SECONDS && (hours = (deltaInSeconds + 900) / ONE_HOUR_IN_SECONDS) < 24) {
            return "about " + hours + " hours ago";
        }
        if (deltaInSeconds < 172800) {
            return "1 day ago";
        }
        int days = deltaInSeconds / ONE_DAY_IN_SECONDS;
        return "" + days + " days ago";
    }
}

