/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.Serializable;
import twitter4j.FilterQuery;
import twitter4j.RateLimitStatusListener;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.TwitterException;
import twitter4j.TwitterOAuthSupportBaseImpl;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.RequestToken;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponseEvent;
import twitter4j.internal.logging.Logger;

public final class TwitterStream
extends TwitterOAuthSupportBaseImpl
implements Serializable {
    private final HttpClientWrapper http;
    private static final Logger logger = Logger.getLogger(TwitterStream.class);
    private StatusListener statusListener;
    private StreamHandlingThread handler = null;
    private static final long serialVersionUID = -762817147320767897L;
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;

    public TwitterStream() {
        super(ConfigurationContext.getInstance());
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
    }

    public TwitterStream(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
    }

    public TwitterStream(String screenName, String password, StatusListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.statusListener = listener;
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
    }

    TwitterStream(Configuration conf, Authorization auth, StatusListener listener) {
        super(conf, auth);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(conf));
        this.statusListener = listener;
    }

    public void firehose(final int count) {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFirehoseStream(count);
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/firehose.json", count);
    }

    public void links(final int count) {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getLinksStream(count);
            }
        });
    }

    public StatusStream getLinksStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/links.json", count);
    }

    public void stream(final String relativeUrl, final int count, boolean handleUserStream) {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(handleUserStream){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getCountStream(relativeUrl, count);
            }
        });
    }

    private StatusStream getCountStream(String relativeUrl, int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.ensureBasicEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + relativeUrl, new HttpParameter[]{new HttpParameter("count", String.valueOf(count))}, this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void retweet() {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getRetweetStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/retweet.json", new HttpParameter[0], this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void sample() {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getSampleStream();
            }
        });
    }

    public StatusStream getSampleStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.get(this.conf.getStreamBaseURL() + "statuses/sample.json", this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void user() {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(true){

            public UserStream getStream() throws TwitterException {
                return TwitterStream.this.getUserStream();
            }

            public /* synthetic */ StatusStream getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public UserStream getUserStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!(this.statusListener instanceof UserStreamListener)) {
            logger.warn("Use of UserStreamListener is suggested.");
        }
        try {
            return new StatusStreamImpl(this.http.get(this.conf.getUserStreamBaseURL() + "user.json", this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void filter(final FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream(query);
            }
        });
    }

    public StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/filter.json", query.asHttpParameterArray(), this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void filter(final int count, final int[] follow, final String[] track) {
        this.ensureAuthorizationEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream(count, follow, track);
            }
        });
    }

    public StatusStream getFilterStream(int count, int[] follow, String[] track) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getFilterStream(new FilterQuery(count, follow, track, null));
    }

    private synchronized void startHandler(StreamHandlingThread handler) {
        this.cleanup();
        if (null == this.statusListener) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    private synchronized void startUserStreamHandler(StreamHandlingThread handler) {
        this.cleanup();
        if (null == this.statusListener) {
            throw new IllegalStateException("UserStreamListener is not set.");
        }
        if (!(this.statusListener instanceof UserStreamListener)) {
            throw new IllegalStateException("UserStreamListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    public synchronized void cleanup() {
        if (null != this.handler) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public void setUserStreamListener(UserStreamListener statusListener) {
        this.statusListener = statusListener;
    }

    public /* synthetic */ void setOAuthConsumer(String x0, String x1) {
        super.setOAuthConsumer(x0, x1);
    }

    public /* synthetic */ boolean isOAuthEnabled() {
        return super.isOAuthEnabled();
    }

    public /* synthetic */ void setOAuthAccessToken(String x0, String x1) {
        super.setOAuthAccessToken(x0, x1);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(String x0, String x1, String x2) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1, x2);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(String x0, String x1) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1);
    }

    public /* synthetic */ void setOAuthAccessToken(AccessToken x0) {
        super.setOAuthAccessToken(x0);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(RequestToken x0, String x1) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(RequestToken x0) throws TwitterException {
        return super.getOAuthAccessToken(x0);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(String x0) throws TwitterException {
        return super.getOAuthAccessToken(x0);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken() throws TwitterException {
        return super.getOAuthAccessToken();
    }

    public /* synthetic */ RequestToken getOAuthRequestToken(String x0) throws TwitterException {
        return super.getOAuthRequestToken(x0);
    }

    public /* synthetic */ RequestToken getOAuthRequestToken() throws TwitterException {
        return super.getOAuthRequestToken();
    }

    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }

    public /* synthetic */ void shutdown() {
        super.shutdown();
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    abstract class StreamHandlingThread
    extends Thread {
        private StatusStream stream;
        private UserStreamListener userStreamListener;
        private final boolean handleUserStream;
        private static final String NAME = "Twitter Stream Handling Thread";
        private boolean closed;

        StreamHandlingThread() {
            this(false);
        }

        StreamHandlingThread(boolean handleUserStream) {
            super("Twitter Stream Handling Thread[initializing]");
            this.stream = null;
            this.closed = false;
            this.handleUserStream = handleUserStream;
        }

        public void run() {
            int timeToSleep = 0;
            while (!this.closed) {
                try {
                    if (this.closed || null != this.stream) continue;
                    this.setStatus("[Establishing connection]");
                    this.stream = this.getStream();
                    timeToSleep = 0;
                    this.setStatus("[Receiving stream]");
                    while (!this.closed) {
                        if (this.handleUserStream) {
                            ((UserStream)this.stream).next((UserStreamListener)TwitterStream.this.statusListener);
                            continue;
                        }
                        this.stream.next(TwitterStream.this.statusListener);
                    }
                }
                catch (TwitterException te) {
                    if (this.closed) continue;
                    if (0 == timeToSleep) {
                        if (te.getStatusCode() > 200) {
                            timeToSleep = 10000;
                        } else if (0 == timeToSleep) {
                            timeToSleep = 250;
                        }
                    }
                    if (!this.closed) {
                        this.setStatus("[Waiting for " + timeToSleep + " milliseconds]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        timeToSleep = Math.min(timeToSleep * 2, te.getStatusCode() > 200 ? 240000 : 16000);
                    }
                    this.stream = null;
                    logger.debug(te.getMessage());
                    TwitterStream.this.statusListener.onException(te);
                }
            }
            try {
                if (null != this.stream) {
                    this.stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[Disposing thread]");
            this.closed = true;
        }

        private void setStatus(String message) {
            String actualMessage = NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }
}

