﻿Imports System.Windows.Forms
Imports System.Collections.Generic


Module Utils_LocaleNames

    Friend Language As String = "English"
    Private ld As New Dictionary(Of String, String)

    Friend Sub SetLocales()
        'If Application.ExecutablePath.ToUpper().EndsWith("JA.EXE") Then Language = "Japanese"
        ' ------------------------------------- read the file
        If Not ReadLocaleFile() Then Exit Sub
        ' ------------------------------------- rename
        RenameControls(Form_Main)
        RenameControls(Form_AutoSave)
        RenameControls(Form_BSpectrum)
        ' ------------------------------------- release the array
        'Log("Lc setup")

        ' Stupid vb can't modify dic during iteration...
        Dim k As String
        Dim lk As List(Of String) = New List(Of String)(Lc.Keys)
        For Each k In lk
            If ld.ContainsKey(k) Then Lc(k) = ld(k)
        Next
        Form_Main.set_btn_Graph_Lang(Spectrometer.mGraphType)
        Form_Main.MyListView1.Columns(0).Text = Lc("Isotope_Name")
        Form_Main.MyListView1.Columns(1).Text = Lc("Isotope_Energy")
        'Log("Lc setup done")
        ld.Clear()
    End Sub


    Private Function ReadLocaleFile() As Boolean
        Dim locfilename As String = PlatformAdjustedFileName(Application.StartupPath & "\Docs\Language_" & LanguageSuffix() & ".txt")
        If Not FileExists(locfilename) Then
            locfilename = PlatformAdjustedFileName(Application.StartupPath & "\Docs\Language_ENG.txt")
        End If
        If FileExists(locfilename) Then
            Dim i As Int32 = -1
            Dim s0 As String = ""
            Dim s1 As String = ""
            '
            Dim f As IO.StreamReader
            f = New System.IO.StreamReader(locfilename, System.Text.Encoding.Default)
            '
            Do While Not f.EndOfStream
                s1 = f.ReadLine()
                s1 = Trim(s1.Replace(vbTab, " "))
                s0 = ExtractParamName(s1)
                If s0.Length > 1 And s1.Length > 1 Then
                    i += 1
                    ld.Add(s0, s1)
                End If
            Loop
            f.Close()
        End If
        Return True
    End Function


    Private Sub RenameControls(ByVal container As Control, Optional ByVal ReplaceContainer As Boolean = False)
        ' 
        If ReplaceContainer And ld.ContainsKey(container.Name) Then
            container.Text = ld(container.Name)
            'Log(container.Name & " Found =" & container.Text)
        Else
            'Log(" *  The entry for <" & container.Name & "> Not found. ")
        End If
        '
        For Each ctrl As Control In container.Controls
            If ld.ContainsKey(ctrl.Name) Then
                ctrl.Text = ld(ctrl.Name)
                'Log(ctrl.Name & " Found =" & ctrl.Text)
            Else
                'Log(" *  The entry for <" & ctrl.Name & "> Not found. ")
            End If

            If TypeOf ctrl Is MenuStrip Then
                Dim ms As MenuStrip = DirectCast(ctrl, MenuStrip)
                RenameMenuStripItems(ms)
                'Log(ctrl.Name & "=Menu strip")
            ElseIf TypeOf ctrl Is ToolStrip Then
                Dim ts As ToolStrip = DirectCast(ctrl, ToolStrip)
                RenameToolStripItems(ts)
                'Log(ctrl.Name & "=Tool strip")
            Else
                'Log("  -- No TP MS")
            End If

            ' ---------------------------- Recursively call this function for any container controls.
            If container.HasChildren Then
                RenameControls(ctrl)
            End If
        Next
    End Sub

    Private Sub RenameToolStripItems(ByRef ts As ToolStrip)
        For j As Int32 = 0 To ts.Items.Count - 1
            If ld.ContainsKey(ts.Items(j).Name) Then
                ts.Items(j).Text = " " & ld(ts.Items(j).Name)
            End If
        Next
    End Sub

    Private Sub RenameMenuStripItems(ByRef ms As MenuStrip)
        For j As Int32 = 0 To ms.Items.Count - 1
            If ld.ContainsKey(ms.Items(j).Name) Then
                ms.Items(j).Text = " " & ld(ms.Items(j).Name)
            End If
            Dim tsmi As ToolStripMenuItem = DirectCast(ms.Items(j), ToolStripMenuItem)
            For k As Int32 = 0 To tsmi.DropDownItems.Count - 1
                If ld.ContainsKey(tsmi.DropDownItems(k).Name) Then
                    tsmi.DropDownItems(k).Text = " " & ld(tsmi.DropDownItems(k).Name)
                End If
            Next
        Next
    End Sub

    Friend Function LanguageSuffix() As String
        Dim i As Integer
        For i = 0 To Language_Abbreviation.Length() - 1
            If Language_Abbreviation(i, 0) = Language Then
                Return Language_Abbreviation(i, 1)
            ElseIf Language_Abbreviation(i, 0) = "" Then
                Exit For
            End If
        Next
        Return "ENG"
    End Function

    Friend Sub Show_Help(ByVal fn As String, ByVal ext As String)
        Dim path As String = fn & LanguageSuffix() & ext
        If Not FileExists(path) Then
            path = fn & "ENG" & ext
            If Not FileExists(path) Then
                Exit Sub
            End If
        End If
        Form_Help.rt_Help.LoadFile(path)
        Form_Help.Show()

    End Sub

End Module
