﻿
Module Module_Utils

    Friend HighlightColor As Color = Color.FromArgb(255, 230, 180)

    ' =======================================================================================================
    '   Mixed utils 
    ' =======================================================================================================
    Friend Sub LockTrackbar(ByVal sender As System.Object)
        Dim tk As TrackBar = CType(sender, TrackBar)
        If Math.Abs(tk.Value) < 50 Then
            tk.Value = 0
        End If
    End Sub

    Friend Function MouseButtonLeftPressed() As Boolean
        Return (Control.MouseButtons And Windows.Forms.MouseButtons.Left) <> Windows.Forms.MouseButtons.None
    End Function

    Friend Function MouseButtonRightPressed() As Boolean
        Return (Control.MouseButtons And Windows.Forms.MouseButtons.Right) <> Windows.Forms.MouseButtons.None
    End Function

    Friend Sub InitPictureboxImage(ByVal pbox As PictureBox)
        With pbox
            If .Width <= 0 Then .Width = 32
            If .Height <= 0 Then .Height = 32
            .Image = New Bitmap(.Width, .Height)
        End With
    End Sub

    Friend Function VoltToDecibel(ByRef v As Double) As Double
        VoltToDecibel = 20 * Math.Log10(v)
    End Function
    Friend Function VoltToDecibel(ByRef v As Single) As Single
        VoltToDecibel = CSng(20 * Math.Log10(v))
    End Function


    ' =======================================================================================================
    '  Interpolation functions
    ' -------------------------------------------------------------------------------------------------------
    '  Example (returned value x is 30)
    '   I1=1     ix=3     I2=5
    '   V1=10    x=??     V2=50
    ' =======================================================================================================
    Friend Function Interpolate(ByVal i1 As Single, ByVal i2 As Single, ByVal ix As Single, _
                                 ByVal v1 As Single, ByVal v2 As Single) As Single
        If ix > i2 Then Return 0
        If i2 = i1 Then Return v1
        Return v1 + (v2 - v1) * (ix - i1) / (i2 - i1)
    End Function
    Friend Function InterpolateAndExtrapolate(ByVal i1 As Single, ByVal i2 As Single, ByVal ix As Single, _
                                              ByVal v1 As Single, ByVal v2 As Single) As Single
        If i2 = i1 Then Return v1
        Return v1 + (v2 - v1) * (ix - i1) / (i2 - i1)
    End Function


    ' =======================================================================================================
    '   FadeIn and FadeOut 
    ' =======================================================================================================
    Friend Sub Forms_FadeTo(ByVal FinalValue As Double, ByVal TimeMillisec As Double)
        If TimeMillisec < 1 Then TimeMillisec = 1
        Dim v As Double
        Dim k As Double
        Dim date1 As Date
        '
        Dim StartValue As Double = Form_Main.Opacity
        '
        Application.DoEvents()
        System.Threading.Thread.Sleep(1)
        date1 = Date.Now
        Do
            k = Date.Now.Subtract(date1).TotalMilliseconds / TimeMillisec
            If k > 1 Then k = 1
            v = StartValue + (FinalValue - StartValue) * k
            If FinalValue = 0 Then
                v = v * 0.5
            End If
            Form_Tomy.Opacity = v
            Form_Equalizers.Opacity = v
            Form_Pulses.Opacity = v
            Form_Main.Opacity = v
            System.Threading.Thread.Sleep(20)
            'Debug.Print(v.ToString)
        Loop Until k >= 1
    End Sub

End Module
