﻿Module Module_FillBars

    ' =======================================================================================
    '  CPU USAGE   >>> MUST BE CALLED ONE TIME EVERY SECOND <<<
    ' =======================================================================================
    'Private ProcessCpuCounter As PerformanceCounter = New PerformanceCounter("Process", "% Processor Time", Process.GetCurrentProcess.ProcessName)
    'Private TotalCpuCounter As PerformanceCounter = New PerformanceCounter("Processor", "% Processor Time", "_Total")
    ''Private MemoryCounter As PerformanceCounter = New PerformanceCounter("Memory", "Available MBytes")
    'Friend Sub TestCpuUsage()
    '    Dim pcount As Int32 = System.Environment.ProcessorCount
    '    Dim app As Double = ProcessCpuCounter.NextValue / pcount
    '    Dim sys As Double = TotalCpuCounter.NextValue
    '    ProgressBar_ToolStripLabel(FrmMain.ToolStripLabel1, "App ", app)
    '    ProgressBar_ToolStripLabel(FrmMain.ToolStripLabel2, "Sys ", sys)
    'End Sub



    ' =======================================================================================
    '  CPU TIME MILLISEC   >>> MUST BE CALLED ABOUT 30 TIMES PER SECOND <<<
    ' =======================================================================================
    'Private cpuTime_Font As Font
    'Friend Sub ShowCpuTime(ByVal pbox As PictureBox, ByVal timeMicrosec As Double)

    '    If pbox.Image Is Nothing Then
    '        ' -------------------------------------------------------- using a image for best performance
    '        InitPictureboxImage(pbox)
    '        cpuTime_Font = New Font("Tahoma", pbox.ClientSize.Height - 2, FontStyle.Regular, GraphicsUnit.Pixel)
    '    End If

    '    Static tt As Double = 0
    '    Dim delta As Double
    '    'delta = (TimeMicrosec - tt) / (tt * 0.001 + 1)

    '    delta = (timeMicrosec - tt) * 0.005
    '    delta = Math.Sign(delta) * (Math.Abs(delta) ^ 2)
    '    If delta > 10000 Then delta = 10000
    '    If delta < -10000 Then delta = -10000
    '    tt += delta

    '    ' ----------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)
    '    g.Clear(Color.MintCream)
    '    g.DrawString((tt / 1000).ToString("0.0 mS"), cpuTime_Font, Brushes.Black, 2, 0)

    '    ' ----------------------------------------------------------- final refresh - no flickering
    '    pbox.Refresh()
    'End Sub



    'Friend Sub DisplayPictureBoxMarker(ByVal pbox As PictureBox, ByVal x As Double, ByVal y As Double)
    '    ' ------------------------------------------------ using a bitmap for best performance
    '    If pbox.Image Is Nothing Then
    '        InitPictureboxImage(pbox)
    '    End If
    '    ' ------------------------------------------------ using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)
    '    Const Diam As Single = 16
    '    Dim px As Single = CSng(x * (pbox.ClientSize.Width - Diam - 1))
    '    Dim py As Single = CSng((1 - y) * (pbox.ClientSize.Height - Diam - 1))
    '    Dim d2 As Single = CSng(Diam / 2)
    '    Dim p As Pen = New Pen(Color.Black, 2)
    '    ' ------------------------------------------------ delete old marker
    '    Static OldPx As Single
    '    Static OldPy As Single
    '    g.FillRectangle(New SolidBrush(Color.AliceBlue), OldPx, OldPy, Diam + 2, Diam + 2)
    '    pbox.Invalidate(New Rectangle(CInt(OldPx), CInt(OldPy), CInt(Diam + 2), CInt(Diam + 2)))
    '    OldPx = px
    '    OldPy = py
    '    ' ------------------------------------------------ draw new marker         
    '    g.DrawLine(p, px, py + d2, px + Diam, py + d2)
    '    g.DrawLine(p, px + d2, py, px + d2, py + Diam)
    '    pbox.Invalidate(New Rectangle(CInt(px), CInt(py), CInt(Diam), CInt(Diam)))
    'End Sub



    'Friend Sub DisplayCounterscope(ByVal pbox As PictureBox, ByVal count As Int32)
    '    ' ------------------------------------------------ using a bitmap for best performance
    '    If pbox.Image Is Nothing Then
    '        InitPictureboxImage(pbox)
    '    End If
    '    ' ------------------------------------------------ using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)
    '    Dim px As Single = pbox.Width - 1
    '    Dim py As Single = 2 * (count) + pbox.Height \ 2
    '    Static oldpy As Single
    '    If Math.Abs(oldpy - py) > 1000 Then oldpy = py
    '    Dim p As Pen = New Pen(Color.DarkGreen, 2)
    '    ' ------------------------------------------------ draw the scale
    '    For i As Int32 = 20 To pbox.Height Step 10 * 2
    '        g.DrawLine(Pens.Gray, px - 1, i, px, i)
    '    Next
    '    ' ------------------------------------------------ draw indicator
    '    g.DrawLine(p, px - 1, oldpy, px, py)
    '    oldpy = py
    '    ' ------------------------------------------------ scroll
    '    ImageScrollInPlace(pbox.Image, -1, 0, 0)
    '    'pbox.Refresh()
    '    pbox.Invalidate()
    'End Sub

    ' =======================================================================================
    '  FILL PICTURE BOX - WITH SINGLE COLOR
    ' =======================================================================================

    'Friend Sub FillPictureBox(ByVal pbox As PictureBox, _
    '                          ByVal value As Double, _
    '                          ByVal c1 As Color, _
    '                          ByVal c2 As Color, _
    '                          Optional ByVal MarkPoint As Double = 0)
    '    ' ------------------------------------------------------- using a bitmap for best performance
    '    If pbox.Image Is Nothing Then
    '        InitPictureboxImage(pbox)
    '    End If
    '    ' -------------------------------------------------------
    '    If value < 0 Then value = 0
    '    If value > 1 Then value = 1
    '    Dim v As Int32 = CInt(value * pbox.Width)
    '    ' ------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)
    '    g.FillRectangle(New SolidBrush(c1), 0, 0, v, pbox.ClientSize.Height)
    '    g.FillRectangle(New SolidBrush(c2), v, 0, pbox.ClientSize.Width - v, pbox.ClientSize.Height)
    '    '
    '    'Dim f As Font = New Font("Tahoma", pbox.ClientSize.Height - 2, FontStyle.Regular, GraphicsUnit.Pixel)
    '    'g.TextRenderingHint = Drawing.Text.TextRenderingHint.AntiAliasGridFit
    '    'g.DrawString(Str(Int(value * 100)) & " %", f, Brushes.Black, CInt(pbox.Width / 2 - 17), 0)

    '    If MarkPoint > 0 Then
    '        v = CInt(MarkPoint * pbox.Width)
    '        g.DrawLine(Pens.Black, v, 0, v, pbox.ClientSize.Height)
    '    End If

    '    ' ------------------------------------------------------- final refresh - no flickering
    '    pbox.Refresh()
    'End Sub


    'Friend Sub FillPictureBoxHorizzontal(ByVal pbox As PictureBox, _
    '                                  ByVal value As Double, _
    '                                  ByVal c1 As Color, _
    '                                  ByVal c2 As Color)
    '    ' ------------------------------------------------------- using a bitmap for best performance
    '    If pbox.Image Is Nothing Then
    '        InitPictureboxImage(pbox)
    '    End If
    '    ' -------------------------------------------------------
    '    If value < 0 Then value = 0
    '    If value > 1 Then value = 1
    '    Dim v As Int32 = CInt(value * pbox.Width)
    '    ' ------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)
    '    g.FillRectangle(New SolidBrush(c1), 0, 0, v, pbox.ClientSize.Height)
    '    g.FillRectangle(New SolidBrush(c2), v, 0, pbox.ClientSize.Width - v, pbox.ClientSize.Height)
    '    '
    '    ' ------------------------------------------------------- final refresh - no flickering
    '    pbox.Refresh()
    'End Sub

    'Friend Sub FillPictureBoxVertical(ByVal pbox As PictureBox, _
    '                              ByVal value As Double, _
    '                              ByVal c1 As Color, _
    '                              ByVal c2 As Color)
    '    ' ------------------------------------------------------- using a bitmap for best performance
    '    If pbox.Image Is Nothing Then
    '        InitPictureboxImage(pbox)
    '    End If
    '    ' -------------------------------------------------------
    '    If value < 0 Then value = 0
    '    If value > 1 Then value = 1
    '    Dim v As Int32 = CInt((1 - value) * pbox.Height)
    '    ' ------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)
    '    g.FillRectangle(New SolidBrush(c1), 0, 0, pbox.ClientSize.Width, v)
    '    g.FillRectangle(New SolidBrush(c2), 0, v, pbox.ClientSize.Width, pbox.ClientSize.Height - v)
    '    '
    '    ' ------------------------------------------------------- final refresh - no flickering
    '    pbox.Refresh()
    'End Sub



    ' =======================================================================================
    '  FILL BARS - WITH GRADIENT
    ' =======================================================================================

    'Private Sub ProgressBar_Cpu(ByVal pbox As PictureBox, ByVal PercentualCPU As Double)
    '    '
    '    If pbox.Image Is Nothing Then
    '        InitPictureboxImage(pbox)
    '    End If
    '    '
    '    If PercentualCPU < 0 Then PercentualCPU = 0
    '    If PercentualCPU > 100 Then PercentualCPU = 100
    '    '
    '    Dim r As Rectangle
    '    r.X = 0
    '    r.Y = 0
    '    r.Width = CInt(pbox.Width / 2) - 1   ' <--- (-1) to correct the vertical green line in the middle
    '    r.Height = pbox.Height
    '    Dim b1 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
    '                                                                        Color.FromArgb(100, 255, 0), _
    '                                                                        Color.FromArgb(255, 200, 0), _
    '                                                                        Drawing2D.LinearGradientMode.Horizontal)
    '    Dim b2 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
    '                                                                        Color.FromArgb(255, 200, 0), _
    '                                                                        Color.FromArgb(255, 0, 0), _
    '                                                                        Drawing2D.LinearGradientMode.Horizontal)
    '    '
    '    Dim v As Int32 = CInt((PercentualCPU * pbox.Width) / 100)
    '    Dim vmid As Int32 = CInt(pbox.Width / 2)
    '    '
    '    ' ----------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)

    '    If PercentualCPU <= 50 Then
    '        g.FillRectangle(b1, 0, 0, v, pbox.ClientSize.Height)
    '    Else
    '        g.FillRectangle(b1, 0, 0, vmid, pbox.ClientSize.Height)
    '        g.FillRectangle(b2, vmid, 0, v - vmid, pbox.ClientSize.Height)
    '    End If
    '    Dim b As Brush = New SolidBrush(pbox.BackColor)
    '    g.FillRectangle(b, v, 0, pbox.ClientSize.Width - v, pbox.ClientSize.Height)
    '    '
    '    Dim f As Font = New Font("Tahoma", pbox.ClientSize.Height - 2, FontStyle.Regular, GraphicsUnit.Pixel)
    '    g.TextRenderingHint = Drawing.Text.TextRenderingHint.AntiAliasGridFit
    '    g.DrawString(Str(Int(PercentualCPU)) & "%", f, Brushes.Black, CInt(pbox.Width / 2 - 17), 0)
    '    '
    '    ' ----------------------------------------------------------- final refresh - no flickering
    '    pbox.Refresh()
    'End Sub



    'Private Sub ProgressBar_ToolStripLabel(ByRef lbl As ToolStripLabel, ByVal text As String, ByVal Percentual As Double)

    '    'Percentual *= 4

    '    Dim w As Int32 = lbl.Width
    '    Dim h As Int32 = lbl.Height

    '    If lbl.Image Is Nothing Then
    '        lbl.Image = New Bitmap(w, h)
    '    End If

    '    If Percentual < 0 Then Percentual = 0
    '    If Percentual > 100 Then Percentual = 100
    '    '
    '    Dim r As Rectangle
    '    r.X = 0
    '    r.Y = 0
    '    r.Width = CInt(w / 2) - CInt((w / 2) Mod 2)   ' <--- (-1) to correct the vertical green line in the middle
    '    r.Height = h
    '    Dim b1 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
    '                                                                        Color.FromArgb(120, 160, 0), _
    '                                                                        Color.FromArgb(255, 200, 0), _
    '                                                                        Drawing2D.LinearGradientMode.Horizontal)
    '    Dim b2 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
    '                                                                        Color.FromArgb(255, 200, 0), _
    '                                                                        Color.FromArgb(255, 0, 0), _
    '                                                                        Drawing2D.LinearGradientMode.Horizontal)
    '    '
    '    Dim v As Int32 = CInt((Percentual * w) / 100) + 1
    '    Dim vmid As Int32 = CInt(w / 2)

    '    ' ----------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    Dim g As Graphics = Graphics.FromImage(lbl.Image)

    '    If Percentual <= 50 Then
    '        g.FillRectangle(b1, 1, 1, v, 4)
    '    Else
    '        g.FillRectangle(b1, 1, 1, vmid, 4)
    '        g.FillRectangle(b2, vmid, 1, v - vmid, 4)
    '    End If
    '    Dim b As Brush = New SolidBrush(Color.FromArgb(160, 200, 240))
    '    g.FillRectangle(b, v, 1, w - v, 4)

    '    g.DrawLine(Pens.Gray, v, 1, v, 4)
    '    g.DrawRectangle(Pens.CadetBlue, 1, 0, w - 2, 5)
    '    '
    '    ' ----------------------------------------------------------- final refresh - no flickering
    '    Dim s As String = Percentual.ToString("0")
    '    If s.Length < 2 Then s = " " & s
    '    lbl.Text = text & s & " %"
    '    lbl.Invalidate()
    'End Sub


    'Friend Sub VuMeter_Horizzontal(ByVal pbox As PictureBox, ByVal value As Double)

    '    If Not pbox.Visible Then Return

    '    If pbox.Image Is Nothing Then InitPictureboxImage(pbox)

    '    If value < 0 Then value = 0
    '    If value > 1 Then value = 1
    '    '
    '    Dim r As Rectangle
    '    r.X = 0
    '    r.Y = 0
    '    r.Width = CInt(pbox.Width / 2) - 1   ' <--- (-1) to correct the vertical green line in the middle
    '    r.Height = pbox.Height
    '    Dim b1 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
    '                                                                        Color.FromArgb(100, 255, 0), _
    '                                                                        Color.FromArgb(255, 200, 0), _
    '                                                                        Drawing2D.LinearGradientMode.Horizontal)
    '    Dim b2 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
    '                                                                        Color.FromArgb(255, 200, 0), _
    '                                                                        Color.FromArgb(255, 0, 0), _
    '                                                                        Drawing2D.LinearGradientMode.Horizontal)
    '    '
    '    Dim v As Int32 = CInt(value * pbox.Width)
    '    Dim vmid As Int32 = CInt(pbox.Width / 2) - 1 ' <--- (-1) to correct the vertical green line in the middle

    '    ' ----------------------------------------------------------- using "Graphics.FromImage" for best performance
    '    'Dim g As Graphics = pbox.CreateGraphics
    '    Dim g As Graphics = Graphics.FromImage(pbox.Image)

    '    If value <= 0.5 Then
    '        g.FillRectangle(b1, 0, 0, v, pbox.ClientSize.Height)
    '    Else
    '        g.FillRectangle(b1, 0, 0, vmid, pbox.ClientSize.Height)
    '        g.FillRectangle(b2, vmid, 0, v - vmid, pbox.ClientSize.Height)
    '    End If
    '    Dim b As Brush = New SolidBrush(pbox.BackColor)
    '    g.FillRectangle(b, v, 0, pbox.ClientSize.Width - v, pbox.ClientSize.Height)
    '    '
    '    Dim dbStr As String = ""
    '    If value > 0.001 Then
    '        dbStr = VoltToDecibel(value).ToString("0") & " dB"
    '    End If
    '    '
    '    Dim f As Font = New Font("Tahoma", pbox.ClientSize.Height - 2, FontStyle.Regular, GraphicsUnit.Pixel)
    '    g.TextRenderingHint = Drawing.Text.TextRenderingHint.AntiAliasGridFit

    '    Dim stringFormat As New StringFormat()
    '    stringFormat.Alignment = StringAlignment.Far
    '    stringFormat.LineAlignment = StringAlignment.Center
    '    Dim rec As New Rectangle(0, 0, CInt(pbox.Width / 2 + 17), pbox.Height - 3)
    '    g.DrawString(dbStr, f, Brushes.Black, rec, stringFormat)

    '    ' ----------------------------------------------------------- final refresh - no flickering
    '    pbox.Refresh()
    'End Sub


    Friend Sub VuMeter_Vertical(ByVal pbox As PictureBox, _
                                ByVal value As Double, _
                                Optional ByVal MarkPoint As Double = 0)

        If Not pbox.Visible Then Return

        If pbox.Image Is Nothing Then InitPictureboxImage(pbox)

        If value < 0 Then value = 0
        If value > 1 Then value = 1
        '
        Dim h As Int32 = pbox.ClientSize.Height + 1
        Dim w As Int32 = pbox.ClientSize.Width

        Dim r As Rectangle
        r.X = 0
        r.Y = 0
        r.Width = w
        r.Height = h \ 2 - 1 ' <--- (-1) to correct the vertical green line in the middle
        Dim b1 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
                                                                            Color.FromArgb(255, 200, 0), _
                                                                            Color.FromArgb(100, 255, 0), _
                                                                            Drawing2D.LinearGradientMode.Vertical)
        Dim b2 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
                                                                            Color.FromArgb(255, 0, 0), _
                                                                            Color.FromArgb(255, 200, 0), _
                                                                            Drawing2D.LinearGradientMode.Vertical)
        '


        Dim v As Int32 = CInt(value * h)
        Dim vmid As Int32 = CInt(h / 2) - 1 ' <--- (-1) to correct the vertical green line in the middle

        ' ----------------------------------------------------------- using "Graphics.FromImage" for best performance
        Dim g As Graphics = Graphics.FromImage(pbox.Image)

        If value <= 0.5 Then
            g.FillRectangle(b1, 0, h - v, w, h)
        Else
            g.FillRectangle(b1, 0, vmid - 1, w, h)
            g.FillRectangle(b2, 0, h - v, w, v - vmid - 1)
        End If
        Dim b As Brush = New SolidBrush(pbox.BackColor)
        g.FillRectangle(b, 0, 0, w, h - v)
        '
        ' ----------------------------------------------------------- mark line
        If MarkPoint > 0 Then
            v = CInt(MarkPoint * pbox.Height)
            g.DrawLine(Pens.Black, 0, h - v, w, h - v)
        End If
        '
        ' ----------------------------------------------------------- final refresh - no flickering
        pbox.Refresh()
    End Sub



End Module
