﻿Public Class Form_Equalizers

    Private Sub Form_Equalizers_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        InitSnap()
    End Sub
    Private Sub Form_Equalizers_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'Save_INI()
        Me.Hide()
        e.Cancel = True
    End Sub

    ' =======================================================================================
    '   SNAP WINDOW
    ' =======================================================================================
    Private SnapPosition As Int32 = 0
    ' --------------------------------------------------------------------- InitSmap must be calle from FormLoad
    Private Sub InitSnap()
        ' ---------------------------------- prepare snap params (timer will be disabled automatically)
        SnapMouseMoveTimer.Enabled = True
        TestSnap()
    End Sub
    ' --------------------------------------------------------------------- Start snap when clicking on TitleBar
    Protected Overrides Sub WndProc(ByRef m As Message)
        Const WM_NCLBUTTONDOWN As Integer = 161
        Const HTCAPTION As Integer = 2
        If m.Msg = WM_NCLBUTTONDOWN AndAlso m.WParam.ToInt32 = HTCAPTION Then
            Me.Select()
            Snap_MouseDown()
            Return
        End If
        MyBase.WndProc(m)
    End Sub
    ' --------------------------------------------------------------------- test snap positions
    Private Sub TestSnap()
        Dim newSnap As Int32 = 0
        If Math.Abs(Me.Left - Form_Main.Left) < 40 And Math.Abs(Me.Top - Form_Main.Bottom) < 40 Then newSnap = 1
        If Math.Abs(Me.Left - (Form_Main.Left + 400)) < 40 And Math.Abs(Me.Top - Form_Main.Bottom) < 40 Then newSnap = 2
        If Math.Abs(Me.Left - Form_Main.Right) < 40 And Math.Abs(Me.Top - Form_Main.Top) < 40 Then newSnap = 3
        If Math.Abs(Me.Left - Form_Main.Right) < 40 And Math.Abs(Me.Top - (Form_Main.Top + 320)) < 40 Then newSnap = 4
        If newSnap <> SnapPosition Then
            SnapPosition = newSnap
            If newSnap <> 0 Then
                SnapMouseMoveTimer.Enabled = False
                SetSnap()
            End If
        End If
    End Sub
    ' --------------------------------------------------------------------- set position to snap positions
    '    must be called from MainForm:DockAllWindows and from ResizeEnd
    ' -----------------------------------------------------------------------------------------------------
    Friend Sub SetSnap()
        If Form_Main.Left < -30000 Then Return
        Select Case SnapPosition
            Case 1 : Me.Left = Form_Main.Left : Me.Top = Form_Main.Bottom
            Case 2 : Me.Left = Form_Main.Left + 400 : Me.Top = Form_Main.Bottom
            Case 3 : Me.Left = Form_Main.Right : Me.Top = Form_Main.Top
            Case 4 : Me.Left = Form_Main.Right : Me.Top = Form_Main.Top + 320
        End Select
    End Sub
    ' --------------------------------------------------------------------- move the window with the mouse
    Private CursorStartPos As Point
    Private FormStartPos As Point
    Private WithEvents SnapMouseMoveTimer As Timer = New Timer
    Private Sub Snap_Form_Move(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Move
        If Not SnapMouseMoveTimer.Enabled Then Return
        LimitFormPosition(Me)
        TestSnap()
    End Sub
    Private Sub Snap_MouseDown()
        CursorStartPos = Cursor.Position
        FormStartPos = Me.Location
        SnapMouseMoveTimer.Interval = 15
        SnapMouseMoveTimer.Enabled = True
    End Sub
    Private Sub SnapMouseMoveTimer_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles SnapMouseMoveTimer.Tick
        If MouseButtonLeftPressed() Then
            Me.Location = New Point(FormStartPos.X + Cursor.Position.X - CursorStartPos.X, _
                                    FormStartPos.Y + Cursor.Position.Y - CursorStartPos.Y)
        Else
            SnapMouseMoveTimer.Enabled = False
        End If
    End Sub


    ' ==========================================================================================================
    '   LOAD SAVE 
    ' ==========================================================================================================
    Private Sub btn_LodEq_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_LodEq.ClickButtonArea
        LoadEqualizer()
        CreateHeightCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub btn_SaveEq_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_SaveEq.ClickButtonArea
        SaveEqualizerAs()
    End Sub
    Private Sub btn_LoadLin_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_LoadLin.ClickButtonArea
        LoadLinearizer()
        CreateLinearityCurve()
        Form_Main.ShowSelectedBinData()
        Form_Pulses.SetProps()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub btn_SaveLin_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_SaveLin.ClickButtonArea
        SaveLinearizerAs()
    End Sub


    ' ==========================================================================================================
    '   ENABLE DISABLE CONTROLS
    ' ==========================================================================================================
    Friend Sub EnableDisableControls()
        'EnableLinControls(chk_LinOn.Checked)
        'EnableEqControls(chk_EqOn.Checked)
    End Sub
    Private Sub EnableLinControls(ByVal en As Boolean)
        tk_Lin1.Enabled = en
        tk_Lin2.Enabled = en
        tk_Lin3.Enabled = en
        tk_Lin4.Enabled = en
        tk_Lin5.Enabled = en
        tk_Lin6.Enabled = en
        tk_Lin7.Enabled = en
        tk_Lin8.Enabled = en
        txt_LinInterp.Enabled = en
    End Sub
    Private Sub EnableEqControls(ByVal en As Boolean)
        tk_Eq1.Enabled = en
        tk_Eq2.Enabled = en
        tk_Eq3.Enabled = en
        tk_Eq4.Enabled = en
        tk_Eq5.Enabled = en
        tk_Eq6.Enabled = en
        tk_Eq7.Enabled = en
        tk_Eq8.Enabled = en
        txt_EqInterp.Enabled = en
    End Sub


    ' ================================================================================================
    '   SAVE INI ON LOST-FOCUS
    ' ================================================================================================
    Private Sub Properties_LostFocus(ByVal sender As Object, _
                                     ByVal e As System.EventArgs) Handles tk_Eq1.LostFocus, _
                                                                          tk_Eq2.LostFocus, _
                                                                          tk_Eq3.LostFocus, _
                                                                          tk_Eq4.LostFocus, _
                                                                          tk_Eq5.LostFocus, _
                                                                          tk_Eq6.LostFocus, _
                                                                          tk_Eq7.LostFocus, _
                                                                          tk_Eq8.LostFocus, _
                                                                          tk_Lin1.LostFocus, _
                                                                          tk_Lin2.LostFocus, _
                                                                          tk_Lin3.LostFocus, _
                                                                          tk_Lin4.LostFocus, _
                                                                          tk_Lin5.LostFocus, _
                                                                          tk_Lin6.LostFocus, _
                                                                          tk_Lin7.LostFocus, _
                                                                          tk_Lin8.LostFocus, _
                                                                          txt_EqInterp.LostFocus, _
                                                                          txt_LinInterp.LostFocus, _
                                                                          chk_EqOn.LostFocus, _
                                                                          chk_LinOn.LostFocus
        If Not EventsAreEnabled Then Return
        '        Save_INI()
        'IVmode = False : SaveLoad_INI()
    End Sub



    ' ==========================================================================================================
    '   EIGHT EQUALIZER CONTROLS
    ' ==========================================================================================================
    Private Sub tk_Eq_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_Eq1.Scroll, _
                                                                                                 tk_Eq2.Scroll, _
                                                                                                 tk_Eq3.Scroll, _
                                                                                                 tk_Eq4.Scroll, _
                                                                                                 tk_Eq5.Scroll, _
                                                                                                 tk_Eq6.Scroll, _
                                                                                                 tk_Eq7.Scroll, _
                                                                                                 tk_Eq8.Scroll
        If Not EventsAreEnabled Then Return
        If MouseButtonLeftPressed() Then
            LockTrackbar(sender)
        End If
        CreateHeightCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub tk_Eq_MouseDown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_Eq1.MouseDown, _
                                                                                                    tk_Eq2.MouseDown, _
                                                                                                    tk_Eq3.MouseDown, _
                                                                                                    tk_Eq4.MouseDown, _
                                                                                                    tk_Eq5.MouseDown, _
                                                                                                    tk_Eq6.MouseDown, _
                                                                                                    tk_Eq7.MouseDown, _
                                                                                                    tk_Eq8.MouseDown
        If Not EventsAreEnabled Then Return
        If MouseButtonRightPressed() Then
            CType(sender, TrackBar).Value = 0
        End If
        CreateHeightCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub tk_Eq_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles tk_Eq1.ValueChanged, _
                                                                                                tk_Eq2.ValueChanged, _
                                                                                                tk_Eq3.ValueChanged, _
                                                                                                tk_Eq4.ValueChanged, _
                                                                                                tk_Eq5.ValueChanged, _
                                                                                                tk_Eq6.ValueChanged, _
                                                                                                tk_Eq7.ValueChanged, _
                                                                                                tk_Eq8.ValueChanged
        ' do not test EventsAreEnabled here (to init colors)
        Dim tk As TrackBar = CType(sender, TrackBar)
        If Math.Abs(tk.Value) < 1 Then
            tk.BackColor = GroupBox_HeightEq.BackColor
        Else
            tk.BackColor = HighlightColor
        End If
    End Sub
    Private Sub txt_EqInterp_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_EqInterp.TextChanged
        If Not EventsAreEnabled Then Return
        CreateHeightCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub chk_EqOn_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_EqOn.CheckedChanged
        If Not EventsAreEnabled Then Return
        CreateHeightCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
        EnableDisableControls()
    End Sub


    ' ==========================================================================================================
    '   ENERGY LINEARIIZER CONTROLS
    ' ==========================================================================================================
    Private Sub tk_Lin_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_Lin1.Scroll, _
                                                                                                  tk_Lin2.Scroll, _
                                                                                                  tk_Lin3.Scroll, _
                                                                                                  tk_Lin4.Scroll, _
                                                                                                  tk_Lin5.Scroll, _
                                                                                                  tk_Lin6.Scroll, _
                                                                                                  tk_Lin7.Scroll, _
                                                                                                  tk_Lin8.Scroll
        If Not EventsAreEnabled Then Return
        If MouseButtonLeftPressed() Then
            LockTrackbar(sender)
        End If
        CreateLinearityCurve()
        Form_Main.ShowSelectedBinData()
        Form_Pulses.SetProps()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub tk_Lin_MouseDown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_Lin1.MouseDown, _
                                                                                                     tk_Lin2.MouseDown, _
                                                                                                     tk_Lin3.MouseDown, _
                                                                                                     tk_Lin4.MouseDown, _
                                                                                                     tk_Lin5.MouseDown, _
                                                                                                     tk_Lin6.MouseDown, _
                                                                                                     tk_Lin7.MouseDown, _
                                                                                                     tk_Lin8.MouseDown
        If Not EventsAreEnabled Then Return
        If MouseButtonRightPressed() Then
            CType(sender, TrackBar).Value = 0
        End If
        CreateLinearityCurve()
        Form_Main.ShowSelectedBinData()
        Form_Pulses.SetProps()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub tk_Lin_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles tk_Lin1.ValueChanged, _
                                                                                                 tk_Lin2.ValueChanged, _
                                                                                                 tk_Lin3.ValueChanged, _
                                                                                                 tk_Lin4.ValueChanged, _
                                                                                                 tk_Lin5.ValueChanged, _
                                                                                                 tk_Lin6.ValueChanged, _
                                                                                                 tk_Lin7.ValueChanged, _
                                                                                                 tk_Lin8.ValueChanged
        ' do not test EventsAreEnabled here (to init colors)
        Dim tk As TrackBar = CType(sender, TrackBar)
        If Math.Abs(tk.Value) < 1 Then
            tk.BackColor = GroupBox_HeightEq.BackColor
        Else
            tk.BackColor = HighlightColor
        End If
    End Sub
    Private Sub txt_LinInterp_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_LinInterp.TextChanged
        If Not EventsAreEnabled Then Return
        CreateLinearityCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub chk_LinOn_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_LinOn.CheckedChanged
        If Not EventsAreEnabled Then Return
        CreateLinearityCurve()
        Form_Main.TimerDraw.Interval = 100 ' show changes immediately
        EnableDisableControls()
    End Sub


    ' ==========================================================================================================
    '   CREATE CURVES
    ' ==========================================================================================================
    Friend Sub CreateHeightCurve()
        ' --------------------------------------------------- Master cursor to HeightArray
        Dim x As Single = Form_Main.tk_EqMaster.Value / 500.0F
        Dim k As Single
        If x > 0 Then
            k = cSpline.CalcAttenuatorCoeff(Math.Abs(x), 100, 5)
            For i As Int32 = 0 To MAX_BIN_INDEX
                Spectrometer.HeightLinArray(i) = 1.0F + (k - 1.0F) * i / CSng(MAX_BIN_INDEX)
            Next
        Else
            k = cSpline.CalcAttenuatorCoeff(Math.Abs(x), 2.2, 2)
            For i As Int32 = 0 To MAX_BIN_INDEX
                Spectrometer.HeightLinArray(i) = 1.0F - (k - 1.0F) * i / CSng(MAX_BIN_INDEX)
            Next
        End If
   
        'Text = tk_EqMaster.Value & "   " & k.ToString & "   " & Spectrometer.HeightLinArray(0).ToString & "  " & Spectrometer.HeightLinArray(MAX_BIN_INDEX).ToString
        'Dim sw1 As Diagnostics.Stopwatch = New Diagnostics.Stopwatch : sw1.Start()
        ' --------------------------------------------------- 8 cursors to splined HeightArray
        If chk_EqOn.Checked Then
            Dim interpolator As cSpline = New cSpline
            interpolator.CreateHeightCurve(tk_Eq1.Value, _
                                            tk_Eq2.Value, _
                                            tk_Eq3.Value, _
                                            tk_Eq4.Value, _
                                            tk_Eq5.Value, _
                                            tk_Eq6.Value, _
                                            tk_Eq7.Value, _
                                            tk_Eq8.Value, _
                                            1000, _
                                            txt_EqInterp.NumericValueInteger * 0.005F)
        End If
        'Text = (sw1.Elapsed.TotalMilliseconds * 1000).ToString("0")
    End Sub

    Friend Sub CreateLinearityCurve()
        
        Spectrometer.TrimRight = Form_Main.tk_LinMaster.Value / 3.0F
        ' --------------------------------------------------- 
        For i As Int32 = 0 To MAX_BIN_INDEX
            Spectrometer.EnergyLinArray(i) = i * Form_Main.tk_LinMaster.Value / 3.0F
        Next
        ' --------------------------------------------------- 8 cursors to splined EnergyLinArray
        If chk_LinOn.Checked Then
            Dim interpolator As cSpline = New cSpline
            interpolator.CreateEnergyCurve(tk_Lin1.Value, _
                                           tk_Lin2.Value, _
                                           tk_Lin3.Value, _
                                           tk_Lin4.Value, _
                                           tk_Lin5.Value, _
                                           tk_Lin6.Value, _
                                           tk_Lin7.Value, _
                                           tk_Lin8.Value, _
                                           1000, _
                                           txt_LinInterp.NumericValueInteger * 0.005F)
        End If
    End Sub


    ' ==========================================================================================================
    '   TEST FILL
    ' ==========================================================================================================
    Private Sub btn_TestFill_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_TestFill1.ClickButtonArea
        FillAllBinsWith(100)
    End Sub
    Private Sub FillAllBinsWith(ByVal n As Int32)
        For i As Int32 = 0 To MAX_BIN_INDEX
            WaveRec.Bins(i) = n
        Next
    End Sub

End Class