﻿Public Class cSpectrometer

    Friend mNumBins As Int32 = 0
    Friend SelectedBin As Int32 = -1
    Friend SelectedEnergy As Single
    Friend SnapToPeak As Boolean
    Friend mLastBinIndex As Int32
    Friend mFirstBinIndex As Int32
    Friend LastAudioCardBin As Int32
    Friend LastDataBin As Int32 = MAX_BIN_INDEX

    Friend EnergyLinArray(MAX_BIN_INDEX) As Single
    Friend HeightLinArray(MAX_BIN_INDEX) As Single

    Friend mValues(MAX_BIN_INDEX) As Single
    Friend mMaxBinValue As Single
    Private mBinWithMaxValue As Int32
    Private mStrLastBin As String = ""
    Friend mGraphType As Integer = 0
    Friend HideSpectrum As Boolean = False
    Friend BKGsubtraction As Boolean = False

    'Friend mBKG(MAX_BIN_INDEX) As Single
    Friend LineGraph_Color As Color = Color.Green
    Friend LineGraph_Width As Single = 1
    Friend BarGraph_Color As Color = Color.FromArgb(0, 200, 0)
    Friend BarGraph_Width As Single = 3
    Friend DotGraph_Color As Color = Color.DarkBlue
    Friend DotGraph_Width As Single = 3

    Friend Line_Color As Color = Color.LightGray
    Friend Line2_Color As Color = Color.LightBlue
    Friend Line_Width As Single = 1

    Friend Marker_Color As Color = Color.Orange
    Friend Marker_Width As Single = 1
    Friend Marker_Font As String = "Arial"
    Friend Marker_Fontsize As Integer = 7

    Friend Identifier_Color As Color = Color.Blue
    Friend Identifier_Width As Single = 0.2

    Friend Selected_Color As Color = Color.Red
    Friend Selected_Width As Single = 1

    Friend Number_Color As Color = Color.Black
    Friend Number_Font As String = "Arial"
    Friend Number_Fontsize As Integer = 8

    Friend Extra_Division As Boolean = False

    Friend SaveReference(3) As Boolean
    Friend UseReference(3) As Boolean
    Friend mReferences(6, MAX_BIN_INDEX) As Single
    Friend mRefMaxBinValue(6) As Single
    Friend mRefLastDataBin(6) As Int32
    Friend mReferenceValid() As Boolean = {False, False, False, False}
    Friend mRefTotalPulses(3) As ULong
    Friend mRefTotalSeconds(3) As ULong
    Friend mRef_X_Factor() As Single = {1, 1, 1, 1, 1}
    Friend mRef_Offset() As Single = {0, 0, 0, 0, 0}
    Friend mRef_Y_Factor() As Single = {1, 1, 1, 1, 1}
    ' Friend mRef_BKG() As Integer = {0, 0, 0, 0, 0}
    Friend mRef_Color() As Color = {Color.Gray, Color.FromArgb(140, 80, 0), Color.FromArgb(0, 140, 160), Color.FromArgb(160, 150, 0)}

    Private mPBox As PictureBox
    Private mGraphics As Graphics
    Friend mPBoxW As Int32
    Private mPBoxH As Int32
    Private mTopSpace As Int32 = 40
    Private mBottomSpace As Int32 = 4
    Private mBottomY As Single
    Private mHeightY As Single

    Private mFilterValue As Int32

    Private mResCompEnabled As Boolean
    Private mResCompSize As Int32
    Private mResCompCenter As Int32
    Private mResCompLeft As Int32
    Private mResCompRight As Int32

    Private mMaxY As Int32
    Private mXlog As Boolean
    Private mYlog As Boolean
    Private mXlogExponent As Single
    Private mYlogExponent As Single
    Private mThickLines As Boolean
    Private mZoom As Single = 1
    Friend mTrimRight As Single = 750
    Friend mMinEnergy As Int32
    Friend mMaxEnergy As Int32
    Private mStepEnergy As Int32
    Friend mDBG As String = ""

    ' ================================================================================================
    '   PROPS
    ' ================================================================================================
    Friend Sub InitAll()
        mPBoxW = mPBox.ClientSize.Width
        mPBoxH = mPBox.ClientSize.Height
        mBottomY = mPBoxH - mBottomSpace
        mHeightY = mPBoxH - mTopSpace - mBottomSpace
        mMaxEnergy = CInt(XtoEnergy(mPBoxW))
        mFirstBinIndex = EnergyToBin(mMinEnergy)
        mMaxBinValue = 10
    End Sub

    Friend WriteOnly Property Picture_Box() As PictureBox
        Set(ByVal value As PictureBox)
            mPBox = value
            mGraphics = Graphics.FromImage(mPBox.Image)
        End Set
    End Property

    Friend WriteOnly Property Xlog() As Boolean
        Set(ByVal value As Boolean)
            mXlog = value
        End Set
    End Property

    Friend WriteOnly Property Ylog() As Boolean
        Set(ByVal value As Boolean)
            mYlog = value
        End Set
    End Property

    Friend WriteOnly Property MaxY() As Int32
        Set(ByVal value As Int32)
            mMaxY = value
        End Set
    End Property

    Friend WriteOnly Property ThickLines() As Boolean
        Set(ByVal value As Boolean)
            mThickLines = value
        End Set
    End Property

    Friend WriteOnly Property XlogExponent() As Double
        Set(ByVal value As Double)
            mXlogExponent = CSng(1 / value)
        End Set
    End Property

    Friend WriteOnly Property YlogExponent() As Double
        Set(ByVal value As Double)
            mYlogExponent = CSng(1 / value)
        End Set
    End Property

    Friend WriteOnly Property ScaleZoom() As Single
        Set(ByVal value As Single)
            mZoom = 300.0F / (610.0F - value)
        End Set
    End Property
    Friend WriteOnly Property TrimRight() As Single
        Set(ByVal value As Single)
            mTrimRight = value
        End Set
    End Property

    Friend Function SetNumBins(ByVal n As Int32) As Boolean
        If n <> mNumBins Then
            mNumBins = n
            Return True
        Else
            Return False
        End If
    End Function

    Friend Function GetNumBins() As Int32
        Return mNumBins
    End Function

    Friend Property Filter() As Int32
        Set(ByVal value As Int32)
            mFilterValue = value
        End Set
        Get
            Return mFilterValue
        End Get
    End Property

    Friend Property ResCompEnabled() As Boolean
        Set(ByVal value As Boolean)
            mResCompEnabled = value
        End Set
        Get
            Return mResCompEnabled
        End Get
    End Property
    Friend Property ResCompSize() As Int32
        Set(ByVal value As Int32)
            mResCompSize = value
        End Set
        Get
            Return mResCompSize
        End Get
    End Property
    Friend Property ResCompCenter() As Int32
        Set(ByVal value As Int32)
            mResCompCenter = value
            CompLeftIncreasing = value / 20.0F 'value / 10.0F '1.0F
            CompRightIncreasing = value / 2.0F 'value / 2.0F '5.0F
        End Set
        Get
            Return mResCompCenter
        End Get
    End Property
    Friend Property ResCompLeft() As Int32
        Set(ByVal value As Int32)
            mResCompLeft = value
            CompLeftDecreasing = value / 10.0F 'value / 33.0F '0.3F '0.1F
        End Set
        Get
            Return mResCompLeft
        End Get
    End Property
    Friend Property ResCompRight() As Int32
        Set(ByVal value As Int32)
            mResCompRight = value
            CompRightDecreasing = value / 10.0F 'value / 12.5F '0.8F
        End Set
        Get
            Return mResCompRight
        End Get
    End Property

    Friend Property MinEnergy() As Int32
        Set(ByVal value As Int32)
            mMinEnergy = value
        End Set
        Get
            Return mMinEnergy
        End Get
    End Property

    Friend Sub SetSelectedBinFromX(ByVal x As Int32)
        SelectedBin = XtoBin(x)
        If SelectedBin < 0 Then SelectedBin = 0
        SelectedEnergy = XtoEnergy(x)
        Form_Main.ShowSelectedBinData()
    End Sub

    Friend Sub ChangeSelectedBin(ByVal delta As Int32)
        SelectedBin += delta
        If SelectedBin > mLastBinIndex Then SelectedBin = mLastBinIndex
        If SelectedBin < mFirstBinIndex Then SelectedBin = mFirstBinIndex
        SelectedEnergy = BinToEnergy(SelectedBin)
        Form_Main.ShowSelectedBinData()
    End Sub

    Friend Function GetValidPulses() As ULong
        GetValidPulses = WaveRec.TotalPulses
        For i As Int32 = 0 To mFirstBinIndex - 1
            GetValidPulses -= CULng(WaveRec.Bins(i))
        Next
        If GetValidPulses < 0 Then GetValidPulses = 0
    End Function


    ' ================================================================================================
    '   DRAW SPECTRUM
    ' ================================================================================================
    Friend Sub Draw()
        ' --------------------------------------------------------------------- Scale coeff
        InitAll()
        ' --------------------------------------------------------------------- LastBinIndex
        ' -- Either the end of the spectrum PBox, upper limit of AudioCard bin, or the MAX_BIN_INDEX
        mStrLastBin = ""
        Dim n As Int32 = XtoBin(mPBoxW)
        If n >= MAX_BIN_INDEX Then
            n = MAX_BIN_INDEX
            ' mStrLastBin = "Limited by bins - Decrease bin number"
        End If
        LastAudioCardBin = CInt(MillivoltToBin(1000 * WaveRec.AudioGain) - 1)
        If n > LastAudioCardBin Then
            n = LastAudioCardBin
            ' mStrLastBin = "Limited by audio card saturation - Decrease signal level"
        End If
        mLastBinIndex = n
        ' --------------------------------------------------------------------- Clear graphics
        mGraphics.Clear(Form_Main.PBox_Spectrum.BackColor)
        ' --------------------------------------------------------------------- IIR Filter and MaxBinValue
        ' -- Copy from source (WaveRec.Bins)  to Dest (mValues)
        '        ApplyFilter(mFirstBinIndex, _
        ApplyFilter(0, _
                        mLastBinIndex, _
                        WaveRec.Bins, _
                        mValues, _
                        mMaxBinValue, _
                        mBinWithMaxValue, _
                        Not Form_Main.btn_IIR_Filter.Checked)
        ' --------------------------------------------------------------------- Scale divisions
        DrawScaleDivisions()
        ' --------------------------------------------------------------------- Mark Isotopes 
        MarkIsotopes()
        ' --------------------------------------------------------------------- Denormalize if MaxY is manual
        If mMaxY > 0 Then
            Dim ts As Single = CSng(TotalSeconds + Form_Main.Tickbits / 9.825)
            If ts = 0 Then ts = 0.1
            If Form_Main.btn_cps.Checked Then
                mMaxBinValue = mMaxY * ts / 1000
                If Form_Main.btn_MaxY.Checked Then mMaxBinValue *= 2
            Else
                mMaxBinValue = mMaxY * 2
            End If
            ' ----------------------------------------------------------------- Adjust for Integration time
            If IntegrationMode Then mMaxBinValue *= IntegrationFactor
        End If
        ' --------------------------------------------------------------------- Background and References
        BackgroundAndReferences()
        ' --------------------------------------------------------------------- Draw spectrum
        If Not HideSpectrum Then DrawSpectrum()
        ' --------------------------------------------------------------------- Draw Back Ground
        If UseReference(0) Then DrawReference(0)
        ' --------------------------------------------------------------------- Draw Selected Bin red line
        DrawSelectedBin()
        ' --------------------------------------------------------------------- Debug print
        'mDBG = "UseReference(1)=" & Spectrometer.UseReference(1).ToString & "  mReferenceValid(1)=" & Spectrometer.mReferenceValid(1).ToString

        If mDBG <> "" Then mGraphics.DrawString(mDBG, New Font("Arial", 8), Brushes.Black, mPBoxW - 440, 40)
        ' --------------------------------------------------------------------- Final refresh
        mPBox.Invalidate()
        'mPBox.Refresh()
    End Sub




    ' =========================================================================================================
    '   Mark Isotopes
    ' =========================================================================================================
    Private Sub MarkIsotopes()
        If IdentiFinder IsNot Nothing AndAlso IdentiFinder.Enabled Then
            IdentiFinder.MarkIsotopes(mGraphics)
        Else
            If IsotopeEdited Then
                Form_Main.MyListView1.Sort()
                IsotopeEdited = False
            End If

            Dim it As ListViewItem
            Dim ss As String = ""
            For Each it In Form_Main.MyListView1.Items
                If it.Text.Contains("=") Then it.Text = it.Text.Substring(0, it.Text.IndexOf("="))
                If it.SubItems(1).Text.Contains(",") Then it.SubItems(1).Text = it.SubItems(1).Text.Replace(",", ".").Trim
                If it.Checked Then
                    ss = it.SubItems(1).Text.Replace(",", ".").Trim
                    If ss = "" Then Exit For
                    If IsNumeric(ss) Then MarkIsotope(it.Text, CSng(ss))
                End If
            Next
        End If
    End Sub

    Friend Sub MarkIsotope(ByVal name As String, ByVal e As Single)
        Dim f As Font = New Font(Marker_Font, Marker_Fontsize)
        Dim x As Single = EnergyToX(e) - 1
        mGraphics.DrawLine(New Pen(Marker_Color, Marker_Width), x, 2, x, mPBoxH)
        mGraphics.DrawString(name, f, New SolidBrush(Number_Color), x, 2)
    End Sub

    Friend Sub MarkPeak(ByVal text As String, ByVal e As Single)
        'Dim f As Font = New Font("tahoma", 9, FontStyle.Regular)
        Dim f As Font = New Font(Number_Font, Number_Fontsize)
        Dim x As Single = EnergyToX(e)
        Dim y As Single = mPBoxH - 34
        mGraphics.FillRectangle(Brushes.AliceBlue, x - 20, y + 2, 40, 24)
        'mGraphics.DrawLine(Pens.Red, x, y - 10, x, y - 5)
        mGraphics.DrawString(text, f, New SolidBrush(Number_Color), x - 22, y)
    End Sub


    ' =========================================================================================================
    '   Scale divisions
    ' =========================================================================================================
    Private Sub DrawScaleDivisions()
        Dim x, y As Single
        ' --------------------------------------------------------------------- vert. divisions
        Dim k As Single = mMaxEnergy / CSng(mPBoxW)
        If mXlog Then k *= CSng(3.5 * 0.2 ^ mXlogExponent)
        Select Case k
            Case Is > 6.8F : mStepEnergy = 500
            Case Is > 3.2F : mStepEnergy = 200
            Case Is > 1.6F : mStepEnergy = 100
            Case Is > 0.9F : mStepEnergy = 50
            Case Is > 0.4F : mStepEnergy = 20
            Case Is > 0.2F : mStepEnergy = 10
            Case Is > 0.1F : mStepEnergy = 5
            Case Is > 0.04F : mStepEnergy = 2
            Case Else : mStepEnergy = 1
        End Select
        Dim f As Font = New Font(Number_Font, Number_Fontsize)
        Dim b As Brush = New SolidBrush(Number_Color)
        '        For i As Int32 = mStepEnergy To mMaxEnergy Step mStepEnergy
        Dim p As Pen = New Pen(Line_Color, Line_Width)
        Dim p2 As Pen = New Pen(Line2_Color, Line_Width)
        'Dim b As Brush = Brush(Number.coler)
        For i As Int32 = 0 To mMaxEnergy Step mStepEnergy
            x = EnergyToX(i)
            mGraphics.DrawLine(p, x, 15, x, mPBoxH)
            mGraphics.DrawString(i.ToString, f, b, x, 15)
        Next
        If Extra_Division Then
            Dim h As Single = CSng(mStepEnergy / 2)
            For i As Int32 = mStepEnergy To mMaxEnergy Step mStepEnergy
                x = EnergyToX(i + h)
                mGraphics.DrawLine(p, x, 35, x, mPBoxH)
            Next
        End If

        ' --------------------------------------------------------------------- horiz. divisions
        Dim maxy As Double
        Dim maxdivf As Integer = 25
        Dim divf As Int32 = 25
        Dim divstep As Double
        Dim ts As Single = 1
        Dim z As String = "000000000000000"
        If Form_Main.btn_cps.Checked Then ts = CSng(TotalSeconds + Form_Main.Tickbits / 10)
        If ts = 0 Then ts = 0.1
        If Form_Main.btn_MaxY.Checked Then
            maxy = Form_Main.txt_MaxY.NumericValueInteger
            If Form_Main.btn_cps.Checked Then
                maxy = maxy / 1000 * ts
            End If
        Else
            maxy = mMaxBinValue / 2
            If IntegrationMode Then maxy /= IntegrationFactor
        End If
        If maxy = 0 Then maxy = 10
        If Form_Main.btn_cps.Checked Then
            maxdivf = 20
            divstep = CULng((maxy / maxdivf) * 10000000 / ts)
            'mGraphics.DrawString(CStr(divstep), f, Brushes.Black, mPBoxW - 180, 28)
            If divstep.ToString.Length > 1 Then divstep = CDbl(divstep.ToString.Substring(0, 1) & z.Substring(0, divstep.ToString.Length - 1))
            'mGraphics.DrawString(CStr(divstep), f, Brushes.Black, mPBoxW - 40, 28)
            divstep /= 10000000
            divf = CInt((maxy - 0) / ts / divstep)
        Else
            divstep = CULng((maxy) / maxdivf)
            divstep = CSng(divstep.ToString.Substring(0, 1) & z.Substring(0, divstep.ToString.Length - 1))
            If maxy > divstep * maxdivf Then divstep += 10 ^ (CUInt(divstep).ToString.Length - 1)
            divf = CInt((maxy - 0.1) / divstep)
        End If

        'If Form_Main.btn_MaxY.Checked And Form_Main.btn_cps.Checked Then divstep /= 2

        Dim s As String
        Dim yl(divf) As Single
        For i As Int32 = 0 To divf
            y = ValueToY(CSng(i * divstep * ts / maxy))
            yl(i) = y  ' save y for 2nd loop
            'If i = 1 Or i Mod 5 = 0 Then
            If i Mod 5 = 0 Then
                mGraphics.DrawLine(p2, 0, y, mPBoxW, y)
            Else
                mGraphics.DrawLine(p, 0, y, mPBoxW, y)
            End If
        Next
        '  ----- Debug string
        'mGraphics.DrawString("MaxCount=" & CInt(mMaxBinValue / 2) & vbCrLf & "At bin=" & CStr(mBinWithMaxValue), f, Brushes.Black, mPBoxW - 100, 40)
        'mGraphics.DrawString(CStr(mMaxY) & " , " & CStr(mMaxBinValue) & " , " & CStr(mBinWithMaxValue) & vbCrLf & CStr(divstep) & " , " & CStr(divf) & vbCrLf & CInt(maxy) & "=" & CStr(maxy), f, Brushes.Black, mPBoxW - 80, 40)
        For i As Int32 = 0 To divf
            If i = 1 Or i Mod 5 = 0 Then
                If Form_Main.btn_cps.Checked Then
                    s = (i * divstep).ToString()
                    If s.Length > 7 Then s = s.Substring(0, 7)
                    If s.StartsWith("0.00") Then s = s.Substring(3, 1) & "," & s.Substring(4) & "m"
                Else
                    s = CInt(i * divstep).ToString()
                End If
                If s.EndsWith("000000") Then s = s.Substring(0, s.Length - 6) & "M"
                If s.EndsWith("000") Then s = s.Substring(0, s.Length - 3) & "K"
                mGraphics.DrawString(s, f, b, 4, yl(i) - 11)
            End If
        Next
    End Sub


    ' =========================================================================================================
    '   FILTER
    ' =========================================================================================================
    Private CompLeftIncreasing As Single = 1.0F
    Private CompLeftDecreasing As Single = 0.3F '0.1F
    Private CompRightIncreasing As Single = 5.0F
    Private CompRightDecreasing As Single = 0.8F
    Friend CompOldValues(MAX_BIN_INDEX + 120) As Single

    Private Sub ApplyFilter(ByVal FirstBin As Int32, _
                        ByVal LastBin As Int32, _
                        ByVal ArraySource() As Single, _
                        ByRef ArrayDest() As Single, _
                        ByRef MaxBinValue As Single, _
                        ByRef BinWithMaxValue As Int32, _
                        Optional ByVal JustCopy As Boolean = False)

        MaxBinValue = 1
        BinWithMaxValue = 0

        Dim vComp As Single

        ' --------------------------------------------------------------------- filter coeff
        Dim FilterCoeff As Single = 0.3F * (50000.0F / mNumBins) / (mFilterValue + 10)
        If FilterCoeff > 1 Then FilterCoeff = 1

        '---------------------------------------------------------------------- prepare values 0 to FirstBinIndex -1
        For i As Int32 = 0 To FirstBin - 1
            ArrayDest(i) = 0
        Next

        ' ----------------------------------------------------- If IIR filter setting is off, just copy and exit
        If JustCopy Then
            For i As Int32 = 0 To LastDataBin
                ArrayDest(i) = ArraySource(i) * 2
                If i >= mFirstBinIndex And ArrayDest(i) > MaxBinValue Then
                    MaxBinValue = ArrayDest(i)
                    BinWithMaxValue = i
                End If
            Next
            For i As Int32 = LastDataBin To MAX_BIN_INDEX
                ArrayDest(i) = 0
            Next
            Exit Sub
        End If

        If ResCompEnabled AndAlso mResCompSize > 0 Then
            ' -----------------------------------------------------------------
            '   WITH COMPENSATION  
            '------------------------------------------------------------------ IIR Filter - first pass - UP
            Dim v, vnew As Single
            v = ArraySource(FirstBin)
            For i As Int32 = 0 To mResCompSize
                CompOldValues(i) = v
            Next
            For i As Int32 = FirstBin To LastBin
                vnew = ArraySource(i) * HeightLinArray(i)
                ' ----------------------------------------- filter
                v += (vnew - v) * FilterCoeff
                ' ----------------------------------------- scintillator resolution compensation
                CompOldValues(i + mResCompSize) = v
                vComp = v - CompOldValues(i)
                If vComp > 0 Then
                    vComp *= CompLeftIncreasing
                Else
                    vComp *= CompRightDecreasing
                End If
                ' ----------------------------------------- store filtered value
                ArrayDest(i) = v + vComp
            Next
            '---------------------------------------------------------------------- IIR Filter - second pass - DOWN
            For i As Int32 = LastBin To LastBin + mResCompSize
                CompOldValues(i) = v
            Next
            For i As Int32 = LastBin To FirstBin Step -1
                vnew = ArraySource(i) * HeightLinArray(i)
                ' ----------------------------------------- filter
                v += (vnew - v) * FilterCoeff
                ' ----------------------------------------- scintillator resolution compensation
                CompOldValues(i) = v
                vComp = v - CompOldValues(i + mResCompSize)
                If vComp > 0 Then
                    vComp *= CompRightIncreasing
                Else
                    vComp *= CompLeftDecreasing
                End If
                ' ----------------------------------------- add up and down filter passes
                ArrayDest(i) += v + vComp
                ' ----------------------------------------- update MaxBinValue
                If i >= mFirstBinIndex And ArrayDest(i) > MaxBinValue Then
                    MaxBinValue = ArrayDest(i)
                    BinWithMaxValue = i
                End If
            Next
        Else
            ' -----------------------------------------------------------------
            '   WITHOUT COMPENSATION  
            '---------------------------------------------------------------------- IIR Filter - first pass - UP
            Dim v, vnew As Single
            FirstBin = mFirstBinIndex
            v = ArraySource(FirstBin)
            For i As Int32 = FirstBin To LastBin
                vnew = ArraySource(i) * HeightLinArray(i)
                ' ----------------------------------------- filter
                v += (vnew - v) * FilterCoeff
                ' ----------------------------------------- store filtered value
                ArrayDest(i) = v
            Next
            '---------------------------------------------------------------------- IIR Filter - second pass - DOWN
            For i As Int32 = LastBin To FirstBin Step -1
                vnew = ArraySource(i) * HeightLinArray(i)
                ' ----------------------------------------- filter
                v += (vnew - v) * FilterCoeff
                ' ----------------------------------------- add up and down filter passes
                ArrayDest(i) += v
                ' ----------------------------------------- update MaxBinValue
                If i >= mFirstBinIndex And ArrayDest(i) > MaxBinValue Then
                    MaxBinValue = ArrayDest(i)
                    BinWithMaxValue = i
                End If
            Next
        End If
    End Sub

    ' =========================================================================================================
    '   Background and References
    ' =========================================================================================================
    Private Sub BackgroundAndReferences()
        For i As Integer = 0 To 3
            SaveAndDrawReference(i)
        Next
    End Sub

    Private Sub SaveAndDrawReference(ByVal nref As Int32)
        If SaveReference(nref) Then
            ' -------------------------------------------------------------------- save reference
            Dim i As Int32
            For i = 1 To LastDataBin  'mReferences.GetUpperBound(1)
                mReferences(nref, i) = mValues(i)
            Next
            Dim n As Int32 = i
            For i = n To MAX_BIN_INDEX
                mReferences(nref, i) = 0
            Next
            mRefLastDataBin(nref) = LastDataBin
            mRefMaxBinValue(nref) = mMaxBinValue
            mReferenceValid(nref) = True
            SaveReference(nref) = False
            mRefTotalSeconds(nref) = TotalSeconds
            If nref = 0 Then
                BackgroundSeconds = TotalSeconds
                SaveReference(0) = False
                ApplyInterporation(0, 4, MAX_BIN_INDEX)
            End If
        End If
        If nref <> 0 And UseReference(nref) Then DrawReference(nref) ' ------------- Draw (other than background)
    End Sub

    Private Sub DrawReference(ByVal nref As Int32)

        If Not mReferenceValid(nref) Then Exit Sub
        ' -------------------------------------------------------------------- draw reference and background
        Dim p As Pen
        p = New Pen(mRef_Color(nref), 1)
        Dim x, y As Single
        Dim oldx As Single = -100
        Dim oldy As Single = mPBox.ClientSize.Height
        Dim RefMaxBinValue As Single = mRefMaxBinValue(nref)

        If mMaxY > 0 Then ' ------------------------------------------------- Adjust if denormalized
            If Form_Main.btn_cps.Checked Then
                Dim ts As Single = mRefTotalSeconds(nref)
                If ts = 0 Then ts = 1
                RefMaxBinValue = mMaxY * ts / 1000
                If Form_Main.btn_MaxY.Checked Then RefMaxBinValue *= 2
            Else
                RefMaxBinValue = mMaxY * 2
            End If
            If IntegrationMode Then RefMaxBinValue *= IntegrationFactor
            'ElseIf nref = 0 And Not Form_Main.btn_cps.Checked Then
            'RefMaxBinValue *= TotalSeconds /BackgroundSeconds
        End If

        RefMaxBinValue /= mRef_Y_Factor(nref)
        If RefMaxBinValue < 0 Then Exit Sub
        Dim FirstBin As Integer = mFirstBinIndex
        If mRef_Offset(nref) < 0 Then FirstBin += EnergyToBin(-mRef_Offset(nref))
        Dim zy As Integer = mPBoxH
        ' ----------------------------------------------------------------- draw  line
        If nref = 0 Then ' For the background, use copied line
            nref = 4
            mRefLastDataBin(4) = mRefLastDataBin(0)
        End If
        For i As Int32 = FirstBin To mRefLastDataBin(nref) + 5
            x = BinToX_with_X_Factor(nref, i)
            y = ValueToY(mReferences(nref, i) / RefMaxBinValue)
            If oldx >= 0 Then
                mGraphics.DrawLine(p, oldx, oldy, x, y)
                'If mThickLines Then mGraphics.DrawLine(p, oldx + 1, oldy, x + 1, y)
            End If
            oldx = x
            oldy = y
        Next
    End Sub


    ' =========================================================================================================
    '   Draw Spectrum
    ' =========================================================================================================
    Private Sub DrawSpectrum()
        Dim x, y, v As Single
        Dim oldx, oldy As Single
        Dim kbkg As Single
        If BackgroundSeconds > 0 Then ' ----  Adjust background height 
            kbkg = CSng(TotalSeconds / BackgroundSeconds)
            If IntegrationMode Then kbkg *= IntegrationFactor
        Else
            kbkg = mMaxBinValue / mRefMaxBinValue(0)
        End If

        oldx = -100
        oldy = mPBoxH
        Dim w As Single = 1
        If mThickLines Then w *= 2
        If mGraphType > 0 Then
            ' ----------------------------------------------------------------- draw dot or vertical line
            Dim Bar As Boolean = mGraphType = 1
            Dim p As Pen
            If Bar Then
                p = New Pen(BarGraph_Color, BarGraph_Width * w) ' Light Green
            Else
                p = New Pen(DotGraph_Color, DotGraph_Width * w) ' Green
            End If
            Dim zy As Integer = mPBoxH
            For i As Int32 = mFirstBinIndex To LastDataBin
                x = BinToX(i)
                v = mValues(i)
                If BKGsubtraction Then
                    '  v -= mReferences(0, i) * kbkg
                    v -= mReferences(4, i) * kbkg
                End If
                y = ValueToY(v / mMaxBinValue)
                'If False And oldx >= 0 And y < zy Then
                If oldx >= 0 Then
                    If Bar Then
                        mGraphics.DrawLine(p, x, y, x, zy) ' --- vertical line
                        'If mThickLines Then mGraphics.DrawLine(p, x + 1, y, x + 1, zy)
                    Else
                        mGraphics.DrawLine(p, x, y, x, y + 2) ' --- dot
                        'If mThickLines Then mGraphics.DrawLine(p, x + 1, y + 1, x, y + 2) ' --- double dot
                    End If
                End If
                oldx = x
                oldy = y
            Next
        Else
            ' ----------------------------------------------------------------- draw thin or thick line
            Dim p As Pen = New Pen(LineGraph_Color, LineGraph_Width * w)
            For i As Int32 = mFirstBinIndex To LastDataBin
                x = BinToX(i)
                v = mValues(i)
                If BKGsubtraction Then
                    v -= mReferences(4, i) * kbkg
                End If
                y = ValueToY(v / mMaxBinValue)
                If oldx >= 0 Then
                    mGraphics.DrawLine(p, oldx, oldy, x, y)
                    'If mThickLines Then mGraphics.DrawLine(p, oldx + 1, oldy, x + 1, y)
                End If
                oldx = x
                oldy = y
            Next
        End If
        ' --------------------------------------------------------------------- signal the end of the valid zone
        If mStrLastBin <> "" Then
            Dim f As Font = New Font("Arial", 11)
            Dim s As SizeF = mGraphics.MeasureString(mStrLastBin, f)
            mGraphics.FillRectangle(Brushes.AliceBlue, x - s.Width, mPBoxH - 24, s.Width, s.Height)
            mGraphics.DrawString(mStrLastBin, f, Brushes.Black, x - s.Width + 8, mPBoxH - 24)
        End If
    End Sub


    ' =========================================================================================================
    '   Selected bin
    ' =========================================================================================================
    Private Sub DrawSelectedBin()
        Dim x As Single
        If SelectedBin > 0 Then
            If SnapToPeak Then
                SelectedBin = CalcFWHM_NearTo(SelectedBin)
            End If
            x = BinToX(SelectedBin)
            If x >= 0 And x < mPBoxW Then
                Dim p As Pen = New Pen(Selected_Color, Selected_Width)
                mGraphics.DrawLine(p, x, mTopSpace - 4, x, mPBoxH - If(SnapToPeak, 35, 2))
            End If
            Form_Main.ShowSelectedBinData()
        End If
        ' --------------------------------------------------------------------- FWHM
        'CalcFWHM(mBinWithMaxValue)
    End Sub
    Private Function CalcFWHM_NearTo(ByVal bin As Int32) As Int32
        Dim bin1 As Int32 = bin - 20
        Dim bin2 As Int32 = bin + 20
        If bin1 < mFirstBinIndex Then bin1 = mFirstBinIndex
        If bin2 > mLastBinIndex Then bin2 = mLastBinIndex
        Dim v As Single = 0
        For i As Int32 = bin1 To bin2
            If mValues(i) > v Then
                v = mValues(i)
                bin = i
            End If
        Next
        CalcFWHM(bin)
        Return bin
    End Function
    Private Sub CalcFWHM(ByVal bin As Int32)
        If bin >= MAX_BIN_INDEX Then Return
        Dim e As Single = BinToEnergy(bin)
        ' -------------------------------------------------- cesium only
        'If Math.Abs(e - 660) > 100 Then Return
        '
        Dim bin1, bin2 As Int32
        Dim halfvalue As Single = mValues(bin) / 2.0F
        ' -------------------------------------------------- find left bin with count = 50%
        For j As Int32 = bin To mFirstBinIndex Step -1
            If mValues(j) < halfvalue Then
                bin1 = j + 1
                Exit For
            End If
        Next
        ' -------------------------------------------------- find right bin with count = 50%
        For j As Int32 = bin To mLastBinIndex
            If mValues(j) < halfvalue Then
                bin2 = j - 1
                Exit For
            End If
        Next
        ' -------------------------------------------------- 
        If bin1 = 0 Or bin2 = 0 Then Return
        Dim e1 As Single = BinToEnergy(bin1)
        Dim e2 As Single = BinToEnergy(bin2)
        Dim fwhm As Single = (e2 - e1) / e
        MarkPeak(fwhm.ToString(" 0.0 %", Globalization.CultureInfo.InvariantCulture) & vbCrLf & "(fwhm)", e)

        ' -------------------------------------------------- trying to find the noise baseline
        'Dim midsize As Single = Math.Min(bin - bin1, bin2 - bin) * 1.4F

        'Dim b1 As Int32 = CInt(bin - midsize)
        'Dim b2 As Int32 = CInt(bin + midsize)
        'If b1 < 0 Then Return
        'Dim x1 As Single = EnergyToX(BinToEnergy(b1))
        'Dim x2 As Single = EnergyToX(BinToEnergy(b2))

        'Dim y1 As Single = ValueToY(mValues(CInt(b1)) / mMaxBinValue)
        'Dim y2 As Single = ValueToY(mValues(CInt(b2)) / mMaxBinValue)

        'mGraphics.DrawLine(Pens.Black, x1, y1, x2, y2)


        ' ------------------------------ unused
        'mGraphics.DrawRectangle(Pens.Black, x1, mPBoxH - 40, x2 - x1, 10)
        'mGraphics.DrawLine(Pens.Black, x1, mPBoxH - 40, x1, mPBoxH - 300)
        'mGraphics.DrawLine(Pens.Black, x2, mPBoxH - 40, x2, mPBoxH - 300)
    End Sub



    ' =========================================================================================================
    '   Export and Import
    ' =========================================================================================================
    Friend Function GetBinDataString(ByVal ExportWithHeader As Boolean, ByVal DecimalSeparator As String, ByVal FieldSeparator As String, Optional ByVal nref As Integer = -1) As String
        Dim s As String = ""

        Dim sd As String = ""
        Dim s2 As String
        Dim tp As ULong = 0
        If nref < 0 Then
            For i As Int32 = 0 To LastDataBin '  mFirstBinIndex To mLastBinIndex
                s2 = BinToEnergy(i).ToString(" 0.0", System.Globalization.CultureInfo.InvariantCulture)
                s2 = s2.Replace(".", DecimalSeparator)
                sd &= s2 & FieldSeparator & StrDup(15 - s2.Length, " ") & WaveRec.Bins(i).ToString & vbCrLf
                tp += CULng(WaveRec.Bins(i))
            Next
        Else
            For i As Int32 = 0 To mRefLastDataBin(nref) '  mFirstBinIndex To mLastBinIndex
                s2 = BinToEnergy(i).ToString(" 0.0", System.Globalization.CultureInfo.InvariantCulture)
                s2 = s2.Replace(".", DecimalSeparator)
                sd &= s2 & FieldSeparator & StrDup(15 - s2.Length, " ") & Spectrometer.mReferences(nref, i).ToString & vbCrLf
                tp += CULng(Spectrometer.mReferences(nref, i))
            Next
        End If

        If ExportWithHeader Then
            s &= "-------------------------------------------" & vbCrLf
            s &= " Theremino_MCA - Pulse Height Histogram    " & vbCrLf
            s &= "-------------------------------------------" & vbCrLf
            s &= "       Started at: " & StartTime.ToString("yyyy/MM/dd HH':'mm':'ss") & vbCrLf
            s &= "       Total time: " & TotalSeconds.ToString & " sec." & vbCrLf
            s &= "     Total pulses: " & tp.ToString & vbCrLf
            s &= "  Pulses per sec.: " & (tp / TotalSeconds).ToString("0.0") & vbCrLf
            s &= "         Sampling: " & WaveRec.SamplesPerSec.ToString & " Hz" & vbCrLf
            s &= "   Minimum energy: " & mMinEnergy.ToString() & " KeV" & vbCrLf
            s &= "   Bin multiplier: " & BinFactor.ToString() & vbCrLf
            's &= "         Num bins: " & (mLastBinIndex - mFirstBinIndex).ToString & vbCrLf
            's &= " BLT_Position(uS): " & AudioIn.BLT_Position_uS.ToString & " uS" & vbCrLf
            's &= "     BLT_Size(uS): " & AudioIn.BLT_Size_uS.ToString & " uS" & vbCrLf
            's &= "     Max slope(%): " & AudioIn.BLT_MaxSlope.ToString & " uS" & vbCrLf
            's &= "     Max noise(%): " & AudioIn.BLT_MaxNoise.ToString & " uS" & vbCrLf
            s &= "-------------------------------------------" & vbCrLf
            s &= " Energy(KeV)    Counts                     " & vbCrLf
            s &= "-------------------------------------------" & vbCrLf
        End If
        Return s & sd
    End Function


    Private FieldSep As String
    Private FirstData As Int32

    Friend Sub SetmBuf()
        Dim nref As Integer
        If Form_BSpectrum.rad_BS_Current.Checked Then
            nref = -1
        ElseIf Form_BSpectrum.rad_BS_Ref1.Checked Then
            nref = 1
        ElseIf Form_BSpectrum.rad_BS_Ref2.Checked Then
            nref = 2
        ElseIf Form_BSpectrum.rad_BS_Ref3.Checked Then
            nref = 3
        ElseIf Form_BSpectrum.rad_BS_BKG.Checked Then
            nref = 0
        End If

        Dim i As Integer
        Dim p As Single
        Dim ttlp As Double
        If nref >= 0 Then
            For i = 0 To MAX_BIN_INDEX
                mBuf(i) = mReferences(nref, i)
            Next
            mBufmbv = mRefMaxBinValue(nref)
            mBufpul = mRefTotalPulses(nref)
            mBufsec = mRefTotalSeconds(nref)
        Else
            For i = 0 To MAX_BIN_INDEX
                '                p = WaveRec.Bins(i)
                p = mValues(i)
                mBuf(i) = p
                ttlp += p
            Next
            mBufmbv = mMaxBinValue
            mBufpul = CULng(ttlp)
            mBufsec = TotalSeconds
        End If
    End Sub

    ' -------- Interporate (zoom in, zoom out, and offset + - ) and copy into a mReference buffer
    Friend Sub ApplyInterporation(ByVal sref As Integer, _
                        ByVal dref As Integer, ByVal max As Int32)

        Dim x_Fac As Single = mRef_X_Factor(sref)
        Dim y_Fac As Single = mRef_Y_Factor(sref)
        Dim offset As Single = mRef_Offset(sref)
        If sref = dref Then
            dref = 5
        End If

        Dim i As Int32
        Dim start As Int32 = 0
        Dim fin As Int32 = max - 1
        Dim x As Int32 = EnergyToBin(CSng(Math.Abs(offset)))
        If offset > 0 Then
            For i = 0 To x - 1
                mReferences(dref, i) = 0
            Next
            start = x
        Else
            fin -= x
            x = -x
        End If
        If x_Fac = 1 Then
            For i = start To fin
                mReferences(dref, i) = mReferences(sref, i - x) * y_Fac
            Next
        Else
            x = CInt(x / x_Fac)
            Dim j As Int32 = 0
            Dim a_F As Single = 1 / x_Fac
            Dim js As Single = 0
            If x_Fac > 1 Then
                For i = start To fin
                    js = i * a_F
                    j = CInt(Math.Truncate(js))
                    js -= j
                    mReferences(dref, i) = (mReferences(sref, j - x) * (1 - js) + mReferences(sref, j + 1 - x) * js) * y_Fac
                Next
            Else
                Dim m As Int32 = CInt(max * x_Fac)
                If x < 0 Then
                    m += x
                End If
                Dim v As Single = 0
                Dim r As Single = 0
                Dim jx As Int32 = start
                j = start
                For i = start To m
                    v = r
                    js += a_F
                    Do While j < js
                        v += mReferences(sref, j - x)
                        j += 1
                    Loop
                    jx = j - x
                    If j > m - 1 Or jx >= max Then Exit For
                    r = mReferences(sref, jx) * (1 - js + j)
                    v += mReferences(sref, jx) - r
                    mReferences(dref, i) = v * y_Fac * x_Fac
                    j += 1
                Next
            End If
        End If
        While i < max
            mReferences(dref, i) = 0
            i += 1
        End While
        If dref = 5 Then  ' ------------- If source and destination was the same, copy it back
            For i = 0 To max
                mReferences(sref, i) = mReferences(dref, i)
            Next
        End If
    End Sub


    Friend Function FillBinsFromStringArray(ByVal destination As Int32, ByVal StringArray() As String, _
           Optional ByVal q As Boolean = False, Optional ByVal rawdata As Boolean = False, _
           Optional ByVal fn As String = "") As Boolean
        ' destination: 0 = background, 1,2,3 = Ref1,2,3,  -1 = Current data (WaveRec.Bins)
        ' --------------------------------------------------- find first line
        Dim FirstLine As Int32
        Dim FirstData As Int32
        Dim EnerOffset As Single = 0
        Dim EnerF As Single = 1
        Dim ss As String
        If destination = 0 Then BackgroundSeconds = 0
        Dim SPE As Boolean = System.IO.Path.GetExtension(fn) = ".spe"
        Dim ndata As Int32 = 0
        Dim s2() As String
        Dim DecimalSep As String = ""
        Dim Lsec As ULong = 0UL
        Dim Lpulses As ULong = 0
        Dim ArraySource(MAX_BIN_INDEX) As Single
        Dim ArrayDest(MAX_BIN_INDEX) As Single
        Dim MaxBinValue As Single
        Dim en(MAX_BIN_INDEX) As Single
        Dim cts(MAX_BIN_INDEX) As Single
        If fn <> "" And SPE Then
            ' ---------------- Check SPE format header ----------------
            For i As Int32 = 0 To StringArray.Length - 1
                If StringArray(i).Contains("$MEAS_TIM:") Then
                    ss = StringArray(i + 1)
                    ss = Left(ss, ss.IndexOf(" "))
                    If destination = 0 Then BackgroundSeconds = CULng(ss)
                    Lsec = CULng(ss)
                ElseIf StringArray(i).Contains("$DATA:") Then
                    FirstData = i + 2
                    Exit For
                End If
            Next
            If FirstData = 0 Or Lsec = 0 Then
                Log("FirstData = " & FirstData & " <<< >>>  Lsec = " & Lsec)
                If Not q Then MsgBox("Could not find Total time or the start of data line in the file")
                Return False
            End If
            Dim nds As String
            nds = StringArray(FirstData - 1)
            nds = Mid(nds, 2).Trim()
            Try
                ndata = CInt(nds)
            Catch ex As Exception
                Return False
            End Try
            If ndata > MAX_BIN_INDEX Then ndata = MAX_BIN_INDEX
            For i As Int32 = i + ndata - 1 To StringArray.Length - 1
                If StringArray(i).Contains("$ENER_FIT:") Then
                    ss = StringArray(i + 1)
                    EnerOffset = CSng(Left(ss, ss.IndexOf(" ")))
                    If EnerOffset < 0 Then EnerOffset = 0
                    ss = Mid(ss, ss.IndexOf(" ") + 2)
                    If ss.Contains(" ") Then ss = Left(ss, ss.IndexOf(" "))
                    EnerF = CSng(ss)
                    Exit For
                End If
            Next
            Dim pv As Single = 0
            Dim ttlp As Double = 0
            For i As Int32 = 0 To ndata
                Try
                    pv = CSng(StringArray(i + FirstData))
                    ttlp += pv
                    en(i) = EnerOffset + EnerF * (i + 1)
                    cts(i) = pv
                Catch ex As Exception
                    Exit For
                End Try
                '                If pv > Loadedmbv Then Loadedmbv = pv
            Next
            '           Loadedmbv *= 2
            Lpulses = CULng(ttlp)
        ElseIf StringArray(0).StartsWith("*** SinmatrikX") Then
            ' ----------- Check IFKR Format header ----------
            For i As Int32 = 0 To StringArray.Length - 1
                If StringArray(i).StartsWith("Live Time,") Then
                    ss = Mid(StringArray(i), 12)
                    If destination = 0 Then BackgroundSeconds = CULng(ss)
                    Lsec = CULng(ss)
                ElseIf StringArray(i).StartsWith("Mca Ch Size,") Then
                    ss = Mid(StringArray(i), 14)
                    ndata = CInt(ss)
                    If destination < 0 Then ValidPulses = LoadedPulses
                ElseIf StringArray(i).Contains("ch  ,  data") Then
                    FirstData = i + 1
                    FirstLine = FirstData
                    Exit For
                End If
            Next
            If FirstData = 0 Or FirstLine = 0 Or Lsec = 0 Then
                Log("FirstData = " & FirstData & " <<< >>>  FirstLine = " & FirstLine & " <<< >>> Lsec = " & Lsec)
                If Not q Then MsgBox("Could not find Total time or the start of data line in the file")
                Return False
            End If
            Dim pv As Single = 0
            Dim ttlp As Double = 0
            Dim s As String
            ndata -= 2     ' Last channel seems to contain noise. So cut it out.
            If ndata > MAX_BIN_INDEX Then ndata = MAX_BIN_INDEX
            For i As Int32 = 0 To ndata
                Try
                    s = Mid(StringArray(i + FirstData), 6).Replace(" ", "")
                    pv = CSng(s)
                    ttlp += pv
                    en(i) = i 'EnerOffset + EnerF * (i + 1)
                    cts(i) = pv
                Catch ex As Exception
                    Exit For
                End Try
                '                If pv > Loadedmbv Then Loadedmbv = pv
            Next
            '           Loadedmbv *= 2
            Lpulses = CULng(ttlp)
        Else
            ' ----------- Check Theremino MCA Format header ----------
            For i As Int32 = 0 To StringArray.Length - 1
                If StringArray(i).Contains("Total time:") Then
                    ss = Mid(StringArray(i), StringArray(i).IndexOf(":") + 3)
                    ss = Left(ss, ss.Length - 5)
                    If destination = 0 Then BackgroundSeconds = CULng(ss)
                    Lsec = CULng(ss)
                ElseIf StringArray(i).Contains("Total pulses:") Then
                    ss = Mid(StringArray(i), StringArray(i).IndexOf(":") + 3)
                    'ss = Left(ss, ss.Length - 5)
                    Lpulses = CULng(ss)
                    If destination < 0 Then ValidPulses = LoadedPulses
                ElseIf StringArray(i).Contains("Energy(KeV)    Counts") Then
                    FirstData = i + 2
                    FirstLine = FirstData
                    Exit For
                End If
                'If Val(StringArray(i)) > 0 Then
                '   FirstLine = i
                '   Exit For
                'End If
            Next
            If FirstData = 0 Or FirstLine = 0 Or Lsec = 0 Then
                Log("FirstData = " & FirstData & " <<< >>>  FirstLine = " & FirstLine & " <<< >>> Lsec = " & Lsec)
                If Not q Then MsgBox("Could not find Total time or the start of data line in the file")
                Return False
            End If
            ' --------------------------------------------------- find separators
            Dim s As String = StringArray(FirstLine)
            Dim dotpos As Int32 = InStr(s, ".")
            Dim commapos As Int32 = InStr(s, ",")
            Dim semicolonpos As Int32 = InStr(s, ";")
            'Dim FieldSep As String
            If semicolonpos = 0 And dotpos = 0 And commapos > 0 Then
                DecimalSep = ""
                FieldSep = ","
            ElseIf semicolonpos = 0 And dotpos > 0 And commapos > dotpos Then
                DecimalSep = "."
                FieldSep = ","
            ElseIf dotpos = 0 And commapos > 0 And semicolonpos > commapos Then
                DecimalSep = ","
                FieldSep = ";"
            Else
                If Not q Then
                    MsgBox("Unrecognized file separators." & vbCrLf & _
                           "Please use a dot as decimal separator and a comma as field separator" & vbCrLf & _
                           "or a comma as decimal separator and a semicolon as field separator")
                End If
                Return False
            End If
            ndata = StringArray.Length - FirstLine - 1
            If ndata > MAX_BIN_INDEX Then ndata = MAX_BIN_INDEX

            For i As Int32 = 0 To ndata
                s2 = Strings.Split(StringArray(i + FirstLine), FieldSep)
                s2(0) = s2(0).Replace(DecimalSep, ".")
                en(i) = CSng(Val(s2(0)))
                cts(i) = CSng(Val(s2(1)))
            Next
        End If

        ' --------------------------------------------------- fill bins with interpolated data
        Dim SourceIndex1 As Int32
        Dim SourceIndex2 As Int32
        Dim DestBinEnergy As Single
        Dim v As Single
        If (Not rawdata) Or Form_BSpectrum.chk_BS_EnergyAdj.Checked Then

            For i As Int32 = 0 To MAX_BIN_INDEX
                DestBinEnergy = BinToEnergy(i)
                ' ----------------------------------------------- find index of inporting-data with more energy
                For j As Int32 = 0 To ndata
                    If en(j) >= DestBinEnergy Then
                        SourceIndex2 = j
                        Exit For
                    End If
                Next
                If SourceIndex2 > ndata Then SourceIndex1 = ndata
                SourceIndex1 = SourceIndex2 - 1
                If SourceIndex1 < 0 Then SourceIndex1 = 0

                ' ------------------------------------------- interpolate values
                v = Interpolate(en(SourceIndex1), _
                                en(SourceIndex2), _
                                DestBinEnergy, _
                                cts(SourceIndex1), _
                                cts(SourceIndex2))
                'v = cts(SourceIndex2)
                ArraySource(i) = v
            Next
        Else   ' ------------------------------------ rawdata. No interporation
            For i As Int32 = 0 To ndata
                ArraySource(i) = cts(i)
            Next
        End If

        ' --------------------------------------------------- apply filter with actual FilterCoeff and HeightEqualization
        Dim BinWithMaxValue As Int32
        '        ApplyFilter(mFirstBinIndex, _
        ApplyFilter(0, _
                        ndata, _
                        ArraySource, _
                        ArrayDest, _
                        MaxBinValue, _
                        BinWithMaxValue, _
                        rawdata)            ' <-----------   AppyFilter() takes care of rawdata mode

        'MaxBinValue /= Y_Factor
        Loadedmbv = MaxBinValue
        ' --------------------------------------------------- copy the destination array
        If destination <> 4 Then ' Ref1,2,3 or BKG
            Select Case Form_BSpectrum.Mode
                Case 0 ' Normal
                    For i As Int32 = 0 To ndata
                        mReferences(destination, i) = ArrayDest(i)
                    Next
                    mRefMaxBinValue(destination) = MaxBinValue
                    Loadedmbv = MaxBinValue
                    LoadedPulses = Lpulses
                    LoadedSeconds = Lsec
                Case 1 ' Sum
                    For i As Int32 = 0 To ndata
                        mReferences(destination, i) += ArrayDest(i)
                    Next
                    mRefMaxBinValue(destination) += MaxBinValue
                    Loadedmbv += MaxBinValue
                    LoadedPulses += Lpulses
                    LoadedSeconds += Lsec
                Case 2 ' Diff
                    For i As Int32 = 0 To ndata
                        mReferences(destination, i) = ArrayDest(i) - mBuf(i)
                        mBuf(i) = ArrayDest(i)
                    Next
                    mRefMaxBinValue(destination) = MaxBinValue - mBufmbv
                    Loadedmbv = MaxBinValue - mBufmbv
                    mBufmbv = MaxBinValue
                    LoadedPulses = Lpulses - mBufpul
                    mBufpul = Lpulses
                    LoadedSeconds = Lsec - mBufsec
                    mBufsec = Lsec
                Case 3 ' Add
                    For i As Int32 = 0 To ndata
                        mReferences(destination, i) = mBuf(i) + ArrayDest(i)
                    Next
                    mRefMaxBinValue(destination) = mBufmbv + MaxBinValue
                    Loadedmbv = mBufmbv + MaxBinValue
                    LoadedPulses = mBufpul + Lpulses
                    LoadedSeconds = mBufsec + Lsec
                Case 4 ' Sub
                    For i As Int32 = 0 To ndata
                        mReferences(destination, i) = mBuf(i) - ArrayDest(i)
                    Next
                    mRefMaxBinValue(destination) = mBufmbv - MaxBinValue
                    Loadedmbv = mBufmbv - MaxBinValue
                    LoadedPulses = mBufpul - Lpulses
                    LoadedSeconds = mBufsec - Lsec
            End Select
            mRefTotalSeconds(destination) = LoadedSeconds
            mRefTotalPulses(destination) = LoadedPulses
            mReferenceValid(destination) = True
            UseReference(destination) = True
            mRefLastDataBin(destination) = ndata
        Else                    ' Load into current Bins
            Form_Main.AllBinsToZero()
            Select Case Form_BSpectrum.Mode
                Case 0
                    For i As Int32 = 0 To ndata
                        WaveRec.Bins(i) = ArrayDest(i) / 2
                    Next
                    TotalSeconds = Lsec
                    WaveRec.TotalPulses = Lpulses
                    mMaxBinValue = MaxBinValue
                Case 1
                    For i As Int32 = 0 To ndata
                        WaveRec.Bins(i) += ArrayDest(i) / 2
                    Next
                    TotalSeconds += LoadedSeconds
                    WaveRec.TotalPulses += Lpulses
                    mMaxBinValue += MaxBinValue
                Case 2
                    For i As Int32 = 0 To ndata
                        WaveRec.Bins(i) = ArrayDest(i) / 2 - mBuf(i)
                        mBuf(i) = WaveRec.Bins(i)
                    Next
                    mMaxBinValue = MaxBinValue * 2 - mBufmbv
                    mBufmbv = mMaxBinValue
                    WaveRec.TotalPulses = Lpulses - mBufpul
                    mBufpul = ValidPulses
                    TotalSeconds = Lsec - mBufsec
                    mBufsec = TotalSeconds
                Case 3
                    For i As Int32 = 0 To ndata
                        WaveRec.Bins(i) = mBuf(i) + ArrayDest(i) / 2
                    Next
                    mMaxBinValue = mBufmbv - MaxBinValue
                    WaveRec.TotalPulses = mBufpul - Lpulses
                    TotalSeconds = mBufsec - Lsec
                Case 4
                    For i As Int32 = 0 To ndata
                        WaveRec.Bins(i) = mBuf(i) - ArrayDest(i) / 2
                    Next
                    mMaxBinValue = mBufmbv + MaxBinValue
                    WaveRec.TotalPulses = mBufpul + Lpulses
                    TotalSeconds = mBufsec + Lsec
            End Select
            LoadedSeconds = TotalSeconds
            LoadedPulses = WaveRec.TotalPulses
            ValidPulses = GetValidPulses()
            Form_Main.lbl_TotalSeconds.Text = TotalSeconds.ToString
            Form_Main.lbl_TotalPulses.Text = ValidPulses.ToString
            PulsesPerSec = CSng(ValidPulses / TotalSeconds)
            Form_Main.lbl_PulsesPerSec.Text = PulsesPerSec.ToString("0.0")
            LastDataBin = ndata
        End If
        Return True
    End Function

    ' ================================================================================================
    '   Y SCALE CONVERSIONS
    ' ================================================================================================
    Private Function ValueToY(ByVal value As Single) As Single
        If value > 0 Then
            If mYlog Then
                value = CSng(value ^ mYlogExponent)
            End If
        Else
            value = 0
        End If
        Return mBottomY - value * mHeightY
    End Function


    ' ================================================================================================
    '   X SCALE CONVERSIONS
    ' ================================================================================================
    Private Function x_to_exp(ByVal x As Single) As Single
        If x < 0 Then Return x
        x /= mPBoxW
        x = CSng(x ^ (1.0 / mXlogExponent))
        x *= mPBoxW
        Return x
    End Function
    Private Function x_to_log(ByVal x As Single) As Single
        If x < 0 Then Return x
        x /= mPBoxW
        x = CSng(x ^ mXlogExponent)
        x *= mPBoxW
        Return x
    End Function

    '  XSCALE <--> ENERGY
    ' =============================================================================== original
    Friend Function XtoEnergy(ByVal x As Single) As Single
        x -= 40
        If mXlog Then
            x = x_to_exp(x)
        End If
        Return x * HalfMaxEnergy / mPBoxW / mZoom
        '        Return x * 1600.0F / mPBoxW / mZoom
    End Function
    Friend Function EnergyToX(ByVal e As Single) As Single
        e = e * mPBoxW / HalfMaxEnergy * mZoom
        '        e = e * mPBoxW / 1600.0F * mZoom
        If mXlog Then
            e = x_to_log(e)
        End If
        Return e + 40
    End Function

    '  XSCALE <--> BINS
    ' =============================================================================== simplified (without mZoom)
    Friend Function XtoBin(ByVal x As Single) As Int32
        Return EnergyToBin(XtoEnergy(x))
    End Function

    Friend Function BinToX(ByVal bin As Int32) As Single
        Return EnergyToX(BinToEnergy(bin))
    End Function

    Friend Function BinToX_with_X_Factor(ByVal nref As Int32, ByVal bin As Int32) As Single
        Return EnergyToX(BinToEnergy(bin) * mRef_X_Factor(nref) + mRef_Offset(nref))
    End Function


    '  ENERGY <--> BINS
    ' =============================================================================== WITHOUT LINEARIZER
    'Friend Function EnergyToBin(ByVal e As Single) As Int32
    '    Return CInt(e / 8.0F * mNumBins / mTrimRight)
    'End Function
    'Friend Function BinToEnergy(ByVal b As Int32) As Single
    '    Return b * 8 * mTrimRight / mNumBins
    'End Function
    'Friend Function BinToEnergy(ByVal b As Single) As Single
    '    Return b * 8 * mTrimRight / mNumBins
    'End Function
    ' =============================================================================== WITH LINEARIZER
    Friend Function EnergyToBin(ByVal e As Single) As Int32
        If e <= 0 Then Return 0
        Dim bin As Int32 = CInt(e * mNumBins / 8 / mTrimRight)
        If bin > MAX_BIN_INDEX Then Return MAX_BIN_INDEX
        If bin < 0 Then Return 0
        Dim etmp As Single = BinToEnergy(bin)
        If etmp = e Then
            Return bin
        ElseIf etmp > e Then
            While BinToEnergy(bin) >= e
                bin -= 1
            End While
            Return bin + 1
        Else
            While BinToEnergy(bin) < e
                bin += 1
            End While
            Return bin
        End If
        Return MAX_BIN_INDEX
    End Function

    Friend Function EnergyToBinOLD(ByVal e As Single) As Int32
        ' TODO ---------------------------------------------------- use a more efficient lookup-table
        For bin As Int32 = 0 To MAX_BIN_INDEX
            If BinToEnergy(bin) >= e Then
                Return bin
            End If
        Next
        Return MAX_BIN_INDEX
    End Function

    Friend Function BinToEnergy(ByVal b As Int32) As Single
        Return 8 * EnergyLinArray(b) / mNumBins
    End Function
    Friend Function BinToEnergy(ByVal b As Single) As Single
        ' -----------------------------------------------------------
        '  BinToEnergy interpolated 
        '  used only by "MillivoltToEnergy" to show pulse energies
        ' -----------------------------------------------------------
        If b < 0 Then b = 0
        If b > MAX_BIN_INDEX Then b = MAX_BIN_INDEX
        Dim e As Single
        Dim bin As Int32 = CInt(Math.Floor(b))
        If bin > MAX_BIN_INDEX - 1 Then
            e = Spectrometer.EnergyLinArray(CInt(b))
        Else
            e = Interpolate(bin, bin + 1, b, Spectrometer.EnergyLinArray(bin), Spectrometer.EnergyLinArray(bin + 1))
        End If
        Return 8 * e / mNumBins
    End Function


    '  MILLIVOLT <--> BINS
    ' ===============================================================================
    Friend Function MillivoltToBin(ByVal mv As Single) As Single
        Return mv * WaveRec.BinMultiplier * 32768.0F / 1000.0F
    End Function

    '  MILLIVOLT <--> ENERGY
    ' ===============================================================================
    Friend Function MillivoltToEnergy(ByVal mv As Single) As Single
        Return BinToEnergy(MillivoltToBin(mv))
    End Function
    Friend Function MillivoltToEnergy_NotLinearized(ByVal mv As Single) As Single
        Return 0.01048F * mv * mTrimRight
    End Function


End Class
