﻿Imports System.Runtime.InteropServices

Public Class AudioIn

    ' ===============================================================================================
    '  AUDIO IN - PRIVATE PROPS AND FUNCTIONS
    ' ===============================================================================================
    Private Structure Buffer
        Public Header As WaveNative.WAVEHDR
        Public Data() As Int16
        Public gcHandleHeader As GCHandle
        Public gcHandleData As GCHandle
        Public HeaderPointer As IntPtr
    End Structure
    Private m_Buffers() As Buffer

    Private m_InputActive As Boolean
    Private m_hWaveIn As Int32
    Private m_Result As Int32
    Private m_BuffersCount As Int32
    Private m_NextBuffer As Int32
    Private m_BufferSize As Int32
    Private m_DoneProc As BufferDoneEventHandler
    Private m_Timer As MultimediaTimer = New MultimediaTimer

    Private Sub AddBuffers()
        SyncLock Me
            While m_InputActive
                ' ----------------------------------------------------------------- test the flag WHDR_INQUEUE
                Dim dwFlags As Int16
                dwFlags = Marshal.ReadInt16(m_Buffers(m_NextBuffer).HeaderPointer, 16)
                If (dwFlags And WaveNative.WHDR_INQUEUE) <> 0 Then Exit While
                ' ----------------------------------------------------------------- read buffer
                m_DoneProc(m_Buffers(m_NextBuffer).Data)
                ' ----------------------------------------------------------------- send the buffer
                m_Result = WaveNative.waveInAddBuffer(m_hWaveIn, _
                                                      m_Buffers(m_NextBuffer).HeaderPointer, _
                                                      WaveNative.WHDR_LEN)
                WaveNative.DecodeError("waveInAddBuffer", m_Result)
                ' ----------------------------------------------------------------- select next buffer
                m_NextBuffer += 1
                If m_NextBuffer >= m_BuffersCount Then m_NextBuffer = 0
            End While
        End SyncLock
    End Sub


    ' ===============================================================================================
    '  AUDIO IN - PUBLIC PROPS AND FUNCTIONS
    ' ===============================================================================================
    Friend Delegate Sub BufferDoneEventHandler(ByRef data() As Int16)

    Friend Function InputOn(ByVal device As Integer, _
                            ByVal rate As Int32, _
                            ByVal bits As Int32, _
                            ByVal channels As Int32, _
                            ByVal bufferSize As Integer, _
                            ByVal bufferCount As Integer, _
                            ByVal readProc As BufferDoneEventHandler) As Boolean
        If readProc Is Nothing Then
            MsgBox("Function InputOn - You must provide a readProc.")
            Return False
        End If
        If bits <> 16 Then
            MsgBox("Function InputOn - Only 16 bit samping is implemented.")
            Return False
        End If
        InputOff()
        SyncLock Me
            m_DoneProc = readProc
            m_BufferSize = bufferSize
            m_BuffersCount = bufferCount
            Dim format As WaveNative.WAVEFORMATEX
            format = New WaveNative.WAVEFORMATEX(rate, bits, channels)
            ' --------------------------------------------------------------------- Wave In Open
            m_Result = WaveNative.waveInOpen(m_hWaveIn, device, format, 0, 0, 0)
            If m_Result <> WaveNative.MMSYSERR_NOERROR Then
                WaveNative.DecodeError("WaveInOpen", m_Result)
                Return False
            End If
            ' --------------------------------------------------------------------- prepare all the headers 
            ReDim m_Buffers(m_BuffersCount - 1)
            '
            For i As Int32 = 0 To m_BuffersCount - 1
                '
                ReDim m_Buffers(i).Data(bufferSize - 1)
                m_Buffers(i).gcHandleHeader = GCHandle.Alloc(m_Buffers(i).Header, GCHandleType.Pinned)
                m_Buffers(i).gcHandleData = GCHandle.Alloc(m_Buffers(i).Data, GCHandleType.Pinned)
                m_Buffers(i).HeaderPointer = m_Buffers(i).gcHandleHeader.AddrOfPinnedObject()
                m_Buffers(i).Header.lpData = m_Buffers(i).gcHandleData.AddrOfPinnedObject()
                m_Buffers(i).Header.dwBufferLength = m_BufferSize * 2
                m_Buffers(i).Header.dwFlags = 0
                m_Buffers(i).Header.dwLoops = 0
                m_Buffers(i).Header.dwUser = i
                Marshal.StructureToPtr(m_Buffers(i).Header, m_Buffers(i).HeaderPointer, True)
                '
                m_Result = WaveNative.waveInPrepareHeader(m_hWaveIn, _
                                                          m_Buffers(i).HeaderPointer, _
                                                          WaveNative.WHDR_LEN)
                WaveNative.DecodeError("waveInPrepareHeader", m_Result)
            Next
            ' --------------------------------------------------------------------- start all
            m_InputActive = True
            m_NextBuffer = 0
            m_Timer.Timer_Start(10, AddressOf AddBuffers)
            m_Result = WaveNative.waveInStart(m_hWaveIn)
            WaveNative.DecodeError("waveInStart", m_Result)
            Return True
        End SyncLock
    End Function

    Friend Sub InputOff()
        SyncLock Me
            m_Timer.Timer_Stop()
            If Not m_InputActive Then Return
            ' --------------------------------------------------------------------- stop sending buffers
            m_InputActive = False
            ' --------------------------------------------------------------------- reset
            m_Result = WaveNative.waveInReset(m_hWaveIn)
            WaveNative.DecodeError("waveInReset", m_Result)
            ' --------------------------------------------------------------------- wait all the buffers
            ' --------------------------------------------------------------------- wait up to 1 Sec (10 * 100mS)
            For m_NextBuffer = 0 To m_BuffersCount - 1
                For j As Int32 = 1 To 10
                    ' ------------------------------------------------------------- test the flag WHDR_INQUEUE
                    Dim dwFlags As Int16
                    dwFlags = Marshal.ReadInt16(m_Buffers(m_NextBuffer).HeaderPointer, 16)
                    If (dwFlags And WaveNative.WHDR_INQUEUE) = 0 Then Exit For
                    System.Threading.Thread.Sleep(100)
                Next
            Next
            ' --------------------------------------------------------------------- unprepare all the headers 
            For i As Int32 = 0 To m_BuffersCount - 1
                m_Result = WaveNative.waveInUnprepareHeader(m_hWaveIn, _
                                                            m_Buffers(i).HeaderPointer, _
                                                            WaveNative.WHDR_LEN)
                WaveNative.DecodeError("waveInUnprepareHeader", m_Result)
            Next
            ' --------------------------------------------------------------------- close wave in
            m_Result = WaveNative.waveInClose(m_hWaveIn)
            WaveNative.DecodeError("waveInClose", m_Result)
            ' --------------------------------------------------------------------- free GC Handlers
            For i As Int32 = 0 To m_BuffersCount - 1
                m_Buffers(i).gcHandleHeader.Free()
                m_Buffers(i).gcHandleData.Free()
            Next
        End SyncLock
    End Sub

End Class
