 //////Included Libraries//////
 /////////////////////////////
 #include <SPI.h>
 #include <SD.h>
 #include <AccelStepper.h>
 #include <MultiStepper.h>
 #include <Wire.h> 
 #include <LiquidCrystal_I2C.h>
//////////////////////////////


/////initialize libraries/////
///////////////////////////////
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address

AccelStepper stepperX(1,2,3);
AccelStepper stepperY(1,5,6);
AccelStepper stepperZ(1,7,8);

MultiStepper steppers;
///////////////////////////////




//Pin definitions//////////
///////////////////////////
#define ENDSTOP_X A3 
#define ENDSTOP_Y 9
#define ENDSTOP_Z A2
#define ANALOG_Y A1
#define ANALOG_X A0
///////////////////////////



////Variables>>>>>>>>>>>>>>>>>>>>>>>>>>

//Joysticks
///////////
  int ANALX = 0;     //Variables to save analog readings to
  int ANALY = 0;     //Variables to save analog readings to
////////////

//Endstops
///////////
  int END_X_CHECK = HIGH ;     //Endstop check variables initialized as low, normally high
  int END_Y_CHECK = HIGH ;     //Endstop check variables initialized as low, normally high
  int END_Z_CHECK = HIGH ;     //Endstop check variables initialized as low, normally high
//////////  
 
 
//For parsing and interpolation
/////////////////////////////// 
  int checker;
  File myFile;         //variable name for file to be parsed
  char character;      // variable used for parsing 
  int TO_DRAW[6] = { 0, 13 , 1 , 11 , 5 , 0 };   //word to be built on LCD and drawn in drawWord()
  String GOTOX;                                  //variable to help build GOTO[] which is the position to interpolate to
  String GOTOY;                                  //variable to help build GOTO[] which is the position to interpolate to
  String GOTOZ;                                  //variable to help build GOTO[] which is the position to interpolate to
  long GOTO[3];                                  // position to interpolate to in parseFile()
 ///////////////////////////////// 
  
  
  
//Important positions
/////////////////////////
  long LETTER_END[3]     = { 1250 , 0 , 250 } ;          //pen ends movement on each letter here. use to adjust letter spacing
  long END_OF_PROGRAM[3] = { 3500 , 4500 , 750 } ;   // position for the draw word program to end at
  long WORD_START[3] = { 0 , 600 , 750 } ;
  long Z_RAISE[3] = { 0 , 0 , 750 } ;


////////////////////////////
  
  
  
//// Menu variables/////////////////
///////////////////////////////////
  bool StateX = 1;
  bool StateY = 0;
  byte LCD_MENU_ITEM=0;
 const char ALPHABET[27] = {'_', 'A' , 'B' , 'C' ,'D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'}; 
  int i;
  int j;
  int k;
  int RUN;
  int MENU_LOCATION;
///////////////////////////////////// 
 
 




//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx//////////// 
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx//////////// 
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx//////////// 
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx////////////
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx////////////



void setup() { 
  lcd.begin(20,4);  

  lcd.setCursor ( 0, 1 ); lcd.print("The Name Drawing CNC");
  lcd.setCursor ( 7, 2 ); lcd.print("V 1.12");   
  delay(5000);
  lcd.clear();

  stepperX.setMaxSpeed(1000);
  stepperY.setMaxSpeed(1000);  
  stepperZ.setMaxSpeed(250);

  steppers.addStepper(stepperX);
  steppers.addStepper(stepperY);
  steppers.addStepper(stepperZ);

   pinMode(10, OUTPUT);   // REQUIRED FOR SD CARD, LEAVE OPEN
 
  lcd.setCursor ( 3, 0 ); lcd.print("Word To Draw:");
  lcd.setCursor ( 0, 3 ); lcd.print("DrawWord    RunGcode");
  
  
 if (!SD.begin(4)) { 
   lcd.setCursor ( 2, 2 ); lcd.print("-! NO SDCARD !-");
   delay(10000);
   return;
 }
 

}//End of Setup()



/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx////////////
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx////////////
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx////////////
/////////////////////////////////////////////////////////////////////////////// 
//////////xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx////////////



void loop() {
//Print the currently built word
/////////////////////////////
 for (j=0;j<6;j++){
   k = 4 + j*2;
       lcd.setCursor ( k, 1 );lcd.print(ALPHABET[TO_DRAW[j]]);
 }
////////////////////////////////


//Set the indicator
//////////////////
if (LCD_MENU_ITEM < 6){
MENU_LOCATION = 4 + LCD_MENU_ITEM*2;
lcd.setCursor ( MENU_LOCATION, 2 );lcd.print("^");
}
else if(LCD_MENU_ITEM == 6){
lcd.setCursor ( 2, 2 );lcd.print("vvvv");
}
else{
lcd.setCursor (13, 2 );lcd.print("vvvv");
}
//////////////////////




 ANALX = analogRead(ANALOG_X);  //Read the X joystick value and save to ANALX
 ANALY = analogRead(ANALOG_Y);  //Read the Y joystick value and save to ANALY
 
 
 

// CHANGE LCD_MENU_ITEM with X Stick ////////////////////
/////////////////////////////////////////////////////////
  if ((ANALX>400)  && (ANALX<600) && (StateX == 0))
  { StateX =   1; 
    //DO NOTHING
    }      
 
  else if ((ANALX<200)  && (StateX == 1))
  { StateX =   0;
     //GO DOWN 1 FUNCTION
   if(LCD_MENU_ITEM == 0){
    lcd.setCursor ( 0, 2 );lcd.print("                    ");
     LCD_MENU_ITEM = 7;
   }
   else{
   lcd.setCursor ( 0, 2 );lcd.print("                    ");   
   LCD_MENU_ITEM --;  
   }
 }    
  
  else if ((ANALX>800)  && (StateX== 1))
  { StateX =   0;
    //GO UP 1 FUNCTION
   if(LCD_MENU_ITEM == 7){
     lcd.setCursor ( 0, 2 );lcd.print("                    ");
     LCD_MENU_ITEM = 1;
   }
   else{
   lcd.setCursor ( 0, 2 );lcd.print("                    ");
   LCD_MENU_ITEM ++;  
   }
  }
/////////////////////////////////////////////////////////


//Perform some action when ANALY changes//////////////////
/////////////////////////////////////////////////////////
if ((ANALY>300)  && (ANALY<700) && (StateY== 1))
  { StateY =   0;  
   //DO NOTHING 
  }
 
   else if ((ANALY<200)  && (StateY == 0))
  { StateY =   1;
   if (LCD_MENU_ITEM < 6){
        if(TO_DRAW[LCD_MENU_ITEM] != 26){
          TO_DRAW[LCD_MENU_ITEM]++;
          delay(250);
        }
        else {
          TO_DRAW[LCD_MENU_ITEM] = 0;
          delay(250);
        }
    }
  } 
 
 
else if ((ANALY > 800)  && (StateY == 0))
  {StateY =   1;
   if (LCD_MENU_ITEM < 6){
        if(TO_DRAW[LCD_MENU_ITEM] != 0){
          TO_DRAW[LCD_MENU_ITEM]--;
          delay(250);
        }
        else {
          TO_DRAW[LCD_MENU_ITEM] = 26;
          delay(250);
        }
    }
    else if(LCD_MENU_ITEM == 6){
        drawWord();                         //<<<<<<<<<<<<drawWord is called to draw TO_DRAW
    }
    else if(LCD_MENU_ITEM == 7){
     HOME_X();
     HOME_Y();
     HOME_Z();
     myFile = SD.open("Gcode.txt");        //<<<<<<<<<<<<Name of file to be drawn custom
     parseFile();

  }    
 }
///////////////////////////////////////////////////////// 
 
 
 
 
}/// End of loop()














