#include <Wire.h>

// A Temperature Wand for the Arduino
// Written by Michael Suzuki
// uses Running Average

#define MAX_TEMPS        6		// C++ is 0 based 0,1,2,3
#define NUM_SAMPLES		25		// Number of samples to average

const float aRef=3.33;			//Aref
const float aVcc=5.04;			// 5Volt

// Analog pins
unsigned int PinV[MAX_TEMPS];

byte j=0;
byte k=0;
byte ArrPtr=0;
unsigned int TempNum;
bool QuickSamp=true;

// arrays
float TempArray[NUM_SAMPLES][MAX_TEMPS];		// Total counts to be average
float TempF[MAX_TEMPS];			// Temperaure Fahrenheit 
float Multiplier[MAX_TEMPS];	// Multiplier 
float Offset[MAX_TEMPS];		// Offset

void error(char *str)
{
  Serial.print("error: ");
  Serial.println(str);
  while(1);
}

//Prototypes for utility functions
void printData();
float getTemperatureF(unsigned int TempNum);

void setup(void){
	// Assign analog pin numbers
	PinV[0]=0;		//Temp voltage 1
	PinV[1]=1;		//Temp voltage 2
	PinV[2]=2;		//Temp voltage 3
	PinV[3]=3;		//Temp voltage 4
	PinV[4]=4;		//Temp voltage 5
	PinV[5]=5;		//Temp voltage 6
	
	analogReference(EXTERNAL); //3.3V connected to AREF thru 3.3K AREF=3VDC
	//discard first analogReads
	for (j=0; j <= 5; j++){
		int dummy=analogRead(j);
	}
	Serial.begin(9600);
	Serial.println();
	Serial.println("Temp5, Temp4, Temp3, Temp2, Temp1, Temp0");
	
	Multiplier[5]=0.40404;
	Multiplier[4]=0.36036;
	Multiplier[3]=0.41885;
	Multiplier[2]=0.41237;
	Multiplier[1]=0.37383;
	Multiplier[0]=0.39216;
	Offset[5]=-320.3+3.6;
	Offset[4]=-277.0+3.1;
	Offset[3]=-334.4+2.4;
	Offset[2]=-328.1+1.9;
	Offset[1]=-290.6+0.5;
	Offset[0]=-308.0-0.8;
}

void loop(void){
	// Get Temperatures
	for(TempNum=0 ; TempNum < MAX_TEMPS ; TempNum++){
		TempF[TempNum] = getTemperatureF(TempNum);
	}
	ArrPtr+=1;
	if (ArrPtr==NUM_SAMPLES){
		ArrPtr=0;
	}
	if (QuickSamp==true&& ArrPtr>=(NUM_SAMPLES-1)){
		QuickSamp=false;
	}
	else{
		delay(2000);
	}
	
	printData();
 }

//////////////////////////////////////////////////////////////////////////////////
// Read analog input for specified temp sensor and maps into a Temperature
// Uses a running average
//////////////////////////////////////////////////////////////////////////////////
float getTemperatureF(unsigned int TempNum){
	float SumTotal=0;
	TempArray[ArrPtr][TempNum] = analogRead(PinV[TempNum]); 
	for (j=0;j<NUM_SAMPLES;j++){    
		SumTotal+= TempArray[j][TempNum];
	}    		
	//return (SumTotal/NUM_SAMPLES);
	return Multiplier[TempNum]*(SumTotal/NUM_SAMPLES)+Offset[TempNum];
}

//////////////////////////////////////////////////////////////////////////////////
// Print Data
//////////////////////////////////////////////////////////////////////////////////
void printData(){
	Serial.print("$, ");
//	for(TempNum= 0 ; TempNum < MAX_TEMPS ; TempNum++)
	for(TempNum = MAX_TEMPS-1 ; TempNum+1 > 0; TempNum--){
		Serial.print(TempF[TempNum],1);
		Serial.print(", ");
	}	
	Serial.println();
}