﻿package com.Red5Link{
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.EventDispatcher;
	import flash.events.ProgressEvent;
	import flash.events.DataEvent;
	import flash.errors.*;
	import flash.net.Socket;	
	import flash.events.TimerEvent;
	import flash.utils.Timer;

	public class Red5Connection {
		private var netConnection:NetConnection;
		private var netStream:NetStream;
		private var connectionUrl:String;
		private var streamUrl:String;
		private var cam:Camera;
		private var mic:Microphone;
		private var video:Video;
		private var reconnectTimer:Timer;

		public function Red5Connection(conUrl:String,stream:String) {
			connectionUrl=conUrl;
			streamUrl=stream;
			video = new Video();
			netConnection:NetConnection = new NetConnection();
			netConnection.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
			netConnection.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
			netConnection.connect(connectionUrl);
			setupCameraAndMic();
			reconnectTimer=new Timer(5000);
			reconnectTimer.addEventListener("timer", timerHandler);
		}
		
		private function netConnect():void{
			netConnection.connect(connectionUrl);
		}

		private function setupCameraAndMic():void {
			// setup cam
			cam=Camera.getCamera();
			// setting dimensions and framerate
			cam.setMode(320, 240, 30);
			// set to minimum of 70% quality
			cam.setQuality(0,70);

			// setup mic
			mic=Microphone.getMicrophone();
			mic.setLoopBack(false);
			mic.rate=44;
		}
		
		private function broadcastStream():void {
			netStream=new NetStream(netConnection);
			netStream.attachCamera(cam);
			netStream.attachAudio(mic);
			
			video.attachCamera(cam);
			addChild(video);

			// publish your cam/mic to red5 for broadcasting
			netStream.publish(streamUrl, "live");
		}

		private function netStatusHandler(event:NetStatusEvent):void {
			switch (event.info.code) {
				case "NetConnection.Connect.Success" :
					trace("Shared object netConnection.Succes");
					connectStream();
					break;

				case "NetConnection.Connect.Closed" :
					
					break;

				case "NetConnection.Connect.Failed" :
					trace("Shared object netConnection.Failed");
					
					break;

				case "NetConnection.Connect.AppShutdown" :
					
					break;

				case "NetConnection.Call.Failed" :
					
					break;

				case "NetConnection.Connect.InvalidApp" :
					
					break;

				case "NetConnection.Connect.Rejected" :
					
					break;
					
				case "NetStream.Play.StreamNotFound" :
					trace("Stream not found: " + videoURL);
					break;

			}
		}

		private function securityErrorHandler(event:SecurityErrorEvent):void {
			trace("securityErrorHandler: " + event);
		}
		
		private function timerHandler(event:TimerEvent):void {
            trace("Reconnect shared object NetConnection.");
        }
	}
}