// Date and time functions using just software, based on millis() & timer
// LOG Shower monitor
// Current date is set whenever this sketch is loaded
// The Real Time Clock is controlled by 8MHz crystal so will eventually be incorrect
// May have to reload sketch to correct or if battery is changed.
// Shower LED will be on every other day
// To shift Shower day one day, press and hold Start button about eight seconds
//
// dayOfWeek starts with 0 = Sunday

#include <Wire.h>
#include "RTClib.h"

RTC_Millis RTC;

int day;
int dayPin[7];
boolean shower = false;
boolean firstSun = true;
DateTime now;

// Digital pins
#define SunPin 13
#define MonPin 12
#define TuePin 11
#define WedPin 10
#define ThuPin 7
#define FriPin 9
#define SatPin 8
#define ShowerPin 6
#define startPin 2
// Prototype

void setup () {
Serial.begin(57600);
	dayPin[0] = SunPin;
	dayPin[1] = MonPin;
	dayPin[2] = TuePin;
	dayPin[3] = WedPin;
	dayPin[4] = ThuPin;
	dayPin[5] = FriPin;
	dayPin[6] = SatPin;
	for (day = 0; day < 7; day++){
		pinMode(dayPin[day], OUTPUT);	// Set for output
	}
	pinMode(ShowerPin, OUTPUT);			// Set for output
    pinMode(startPin, INPUT_PULLUP); 

    // following lines sets the RTC to the date & time this sketch was compiled
    RTC.begin(DateTime(__DATE__, __TIME__));
    now = RTC.now();
    digitalWrite(ShowerPin, HIGH);	
	delay(100);
    digitalWrite(ShowerPin, LOW);	
	
}

void loop () {

	// Do nothing until Start is pushed
	if (digitalRead(startPin) == LOW){ 
		now = RTC.now();
Serial.print(now.hour(), DEC);
Serial.print(':');
Serial.print(now.minute(), DEC);
Serial.print(':');
Serial.print(now.second(), DEC);
Serial.println();
	
		// Turn on correct LED
		for (day = 0; day < 7; day++){
			if ( day != now.dayOfWeek() ) digitalWrite(dayPin[day], LOW);		// Turn off LED
			else digitalWrite(dayPin[day], HIGH);								// Turn on correct LED
		}
		
		// Week is seven days so if Sunday, need to correct Shower day
		// This is tricky, if it's Sunday and first time Start is pushed
		// then toggle shower and set firstSun to false
		// If Saturday (6) make sure firstSun is true
		if ( (now.dayOfWeek() == 0) && firstSun ){
			shower = !shower;
			firstSun = false;
		}
		if (now.dayOfWeek() == 6) firstSun = true;
		
		// Use modulus to see if it's shower day
		if ( (now.dayOfWeek() % 2) == shower)	digitalWrite(ShowerPin, HIGH);		// Turn on LED
		else digitalWrite(ShowerPin, LOW);		// Turn off LED
		delay(3000);
		// if Start button is pushed, toggle shower so shower day is shifted.
		if (digitalRead(startPin) == LOW) shower = !shower;
		delay(3000);
		
		// Turn off LEDs until next Start button press
		for (day = 0; day < 7; day++){
			digitalWrite(dayPin[day], LOW);		// Turn off LED
		}
		digitalWrite(ShowerPin, LOW);			// Turn off LED
	}
}
