//Brobot Servo and LCD Control Code

//Servo Library
#include <Servo.h> 

//LCD Library 
#include <Wire.h>
#include <LiquidCrystal_I2C.h>

//Initialize Servos
Servo myservo1;  // create yaw servo 
Servo myservo2;  // create pitch servo


//Initialize LCD
LiquidCrystal_I2C lcd(0x3F, 16, 2); // set the LCD address to 0x3F

//Callout Pins
int potpin1 = A0;  // analog pin used to connect the potentiometer that controls yaw
int potpin2 = A1;  // analog pin used to connect the potentiometer that controls pitch
int val1;    // variable to read the value for yaw
int val2;    // variable to read the value for pitch

void setup() 
{ 
  //Setup Servos
  myservo1.attach(3);  // attaches the servo on pin 9 to the servo object 
  myservo2.attach(9);  // attaches the servo on pin 9 to the servo object

 //Open Serial Monitor 
   Serial.begin(9600); 

 //Start LCD   
  lcd.init();
  lcd.init();
  lcd.setCursor(1, 0);
  lcd.backlight();
} 

void loop() 
{ 
 //Yaw Servo
  val1 = analogRead(potpin1);            // reads the value of the potentiometer (value between 0 and 1023) 
  val1 = map(val1, 0, 1023, 0, 179);     // scale it to use it with the servo (value between 0 and 180) 
  myservo1.write(val1);                  // sets the servo position according to the scaled value 
  delay(15);                           // waits for the servo to get there 

//Pitch Servo
  val2 = analogRead(potpin2);            // reads the value of the potentiometer (value between 0 and 1023) 
  val2 = map(val2, 0, 1023, 0, 179);     // scale it to use it with the servo (value between 0 and 180) 
  myservo2.write(val2);                  // sets the servo position according to the scaled value 
  delay(15);                           // waits for the servo to get there  

//LCD Display
  lcd.setCursor(0, 0);
  lcd.print("Yaw:");
  lcd.setCursor(8,0);
  lcd.print(val1);
  lcd.setCursor(0, 1);
  lcd.print("Pitch:");
  lcd.setCursor(8, 1);
  lcd.print(val2);
  delay(30);                      // Wait 50ms between pings (about 20 pings/sec). 29ms should be the shortest delay between pings.
} 
