`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    13:01:58 02/11/2010 
// Design Name: 
// Module Name:    top 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module top(
input   clk,
output  led,
output  led1,
output  enable_D1,
output  enable_D2,
output  enable_D3,
output  enable_D4,
output  ca,
output  cb,
output  cc,
output  cd,
output  ce,
output  cf,
output  cg
);

wire clk_out;
wire refreshClk;
wire prbs;
wire [3:0] prbs_reg;
wire led_n;
wire led_n1;


assign led = ~led_n;
assign led1 = ~led_n1;

enable_sr U_ENABLE_SR (
  .clk(refreshClk), 
  .enable_D1(enable_D1), 
  .enable_D2(enable_D2), 
  .enable_D3(enable_D3), 
  .enable_D4(enable_D4)
);

prbs U_PRBS (
  .clk(clk_out), 
  .prbs(prbs),
  .out_par(led_n1),
  .prbs_reg(prbs_reg)
);

clock_gen U_CLOCK (
  .clk(clk), 
  .refreshClk(refreshClk), 
  .clk_out(clk_out)
);

fsm U_FSM (
  .clk(clk_out), 
  .IN(prbs), 
  .OUT(led_n)
);

display U_DISPLAY (
  .enable_D1(enable_D1), 
  .enable_D2(enable_D2), 
  .enable_D3(enable_D3), 
  .enable_D4(enable_D4), 
  .digit(prbs_reg), 
  .ca(ca), 
  .cb(cb), 
  .cc(cc), 
  .cd(cd), 
  .ce(ce), 
  .cf(cf), 
  .cg(cg)
);


endmodule

