`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    13:31:47 02/11/2010 
// Design Name: 
// Module Name:    prbs 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module prbs(
input             clk, // ipnut clock
output            prbs,out_par, //input right most bit for prbs and led ouput
output reg [3:0]  prbs_reg  //input prbs 
);

reg [18:0]  lfsr = 18'b1111111111111111111; //input linear feedback shift register register variable

assign prbs = lfsr[0]; //assign the right most digit of the prbs to right most digit of linear feedback shift register
assign out_par = PARITY(lfsr); //assign output to function ouput parity. Argument of function PARITY is linear feedback shift register

always @(posedge clk) begin
  lfsr <= {lfsr,~lfsr[18]^lfsr[5]^lfsr[1]^lfsr[0]}; //shift the linear shift register to change prbs
end

always @(posedge clk) begin
  prbs_reg = {prbs,prbs_reg[3:1]};//shift prbs pattern
end

//create a function PARITY to find out parity of the linear feedback shift register
function PARITY (input [18:0] data); 
reg PAR; // variable PAR using in the loop to store the temporary parity 
integer i;
begin
 PAR = 1'b1; //assign parity to 1
 for (i=0;i<=18;i=i+1) //create for loop to do the XOR for all 18 bits
  PAR = PAR ^ data[i]; //XOR for each bit
 PARITY = PAR; //Return function to PARITY and to PAR
 end 
endfunction

endmodule


