`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    13:06:33 02/11/2010 
// Design Name: 
// Module Name:    fsm 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module fsm(
input       clk, // synchronous FSM clock
input       IN, // input
output      OUT // output
);

//use parameter to define the constant S0, S1, S2, S3, S4 which are states
//use hot econding to define each state
parameter   S0          =     5'b00001, //State 0, Initial State 
            S1          =     5'b00010,
            S2          =     5'b00100,
            S3          =     5'b01000,
			S4          = 	  5'b10000; // State 4, Final State

// Must do the state initialization to a known state so that behavioral simulation 
//gate level result matches
//Synchronous FSM. Only need to have one state variable 
reg [4:0]   state  =     S0; 
reg         OUT_b  =     0;

assign OUT = ~OUT_b; // output for LED0

//use always block to implment the next state logic 
//use positive edge of clock in the sensitivity list
//case statement and conditional statement to decide next state logic
always @(posedge clk) begin
  case(state)
    S0: begin // Case state 0
      if (IN) state <= S1; // if input is 1, jump to state 1
      else    state <= S0; // if input is 0, stay in state 0
    end
    S1: begin // Case state 1
      if (IN) state <= S0; // if input is 1, go back to state 0
      else    state <= S2; // if input is 0, jump to state 2
    end
    S2: begin // Case state 2
      if (IN) state <= S1; // if input is 1, go back to state 1
      else    state <= S3; // if input is 0, jump to state 3
    end
    S3: begin // Case state 3
      if (IN) state <= S4; // if input is 1, jump to state 4
      else    state <= S3; // if input is 0, stay in state 3
    end
	 S4: begin
      if (IN) state <= S0; // if input is 1, go back to state 0
      else    state <= S1; // if input is 0, go back to state 1
    end
    default: begin // default case to avoid error for unreachable state as there are 16 possible states
      state = S0; // always go to state 0
    end
  endcase
end

//use output to assign output in each state
//always make the output to be 0 unless the final state is reached
always @(posedge clk) begin
  case(state)
    S0: begin // state 0 
      OUT_b = 0; //output is 0
    end
    S1: begin // state 1
      OUT_b = 0; // output is 0
    end
    S2: begin // state 2
      OUT_b = 0; //output is 0
    end
	 S3: begin // state 3 
      OUT_b = 0; // output is 0
    end
    S4: begin // state 4
      if (IN) OUT_b = 0; //if iput is 1, output is 0
      else    OUT_b = 1; //if input is 0, output is 1
    end
    default: begin // default for unreacheable state
      OUT_b = 0; // output is 0
    end
  endcase
end

endmodule
