`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    13:41:33 02/11/2010 
// Design Name: 
// Module Name:    display 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module display(
input             enable_D1, //right most digit
input             enable_D2, //second right most digit
input             enable_D3, //second left most digit
input             enable_D4,//left most digit
input             [3:0] digit, //four digits picked from the pattern generated by prbs. Only "1" or "0"
output reg        ca=0, //segment a. refer to Digilent reference manual
output reg        cb=0, //segment b. refer to Digilent reference manual
output reg        cc=0, //segment c. refer to Digilent reference manual
output reg        cd=0, //segment d. refer to Digilent reference manual
output reg        ce=0, //segment e. refer to Digilent reference manual
output reg        cf=0, //segment f. refer to Digilent reference manual
output reg        cg=0  //segment g. refer to Digilent reference manual
);

//create combinatorial always block.
//include all digits in the sensitivity list
always @(enable_D1,enable_D2,enable_D3,enable_D4,digit) begin
  case({enable_D1,enable_D2,enable_D3,enable_D4})//case statement. contacanate all four digits
  4'b1110: begin //when the right most digit is on
    if (digit[0]) begin // if digitl is 1
      ca = 1;  //off
      cb = 0;  //on
      cc = 0;  //on
      cd = 1;  //off
      ce = 1;  //on
      cf = 1;  //off
      cg = 1;  //off
    end else begin //if digit is 0
      ca = 0;  //on
      cb = 0;  //on
      cc = 0;  //on
      cd = 0;  //on
      ce = 0;  //on 
      cf = 0;  //on
      cg = 1;  //off
    end
  end
  4'b1101: begin //when the second right most digit is on
    if (digit[1]) begin //if digit 1 is 1
      ca = 1; //off
      cb = 0; //on
      cc = 0; //on
      cd = 1; //off
      ce = 1; //off
      cf = 1; //off
      cg = 1; //off
    end else begin //if digit 1 is 0
      ca = 0; //on
      cb = 0; //on
      cc = 0; //on
      cd = 0; //on
      ce = 0; //on
      cf = 0; //on
      cg = 1; //off
    end
  end
  4'b1011: begin //when the second left most digit is on
    if (digit[2]) begin // if digit 2 is 1
      ca = 1; //off
      cb = 0; //on
      cc = 0; //on
      cd = 1; //off
      ce = 1; //off
      cf = 1; //off
      cg = 1; //off
    end else begin // if digit 2 is 0
      ca = 0; //on
      cb = 0; //on
      cc = 0; //on
      cd = 0; //on
      ce = 0; //on
      cf = 0; //on
      cg = 1; //off
    end
  end
  4'b0111: begin //when the left most digit is on
    if (digit[3]) begin // if the digit 3 is 1
      ca = 1; //off
      cb = 0; //on
      cc = 0; //on
      cd = 1; //off
      ce = 1; //off
      cf = 1; //off
      cg = 1; //off
    end else begin //if the digit 3 is 0
      ca = 0; //on
      cb = 0; //on
      cc = 0; //on
      cd = 0; //on
      ce = 0; //on
      cf = 0; //on
      cg = 1; //off
    end
  end
  default: begin //unreahable case
    ca = 1; //off
    cb = 1; //off
    cc = 1; //off
    cd = 1; //off
    ce = 1; //off
    cf = 1; //off
    cg = 1; //off
  end
  endcase
end

endmodule
