
//Sensory_Extension_Prototype
//By Nick Gonyea
//Code derived from OpenMusicLab's FHT library & PatricLaub's Haptic Interface Arduino Prototype

#define LOG_OUT 1 // use the log output function
#define FHT_N 256 // set to 256 point fht

#include <FHT.h> // include the library


//These variables allocate different ports to each vibration motor
int motor1 = 5;
int motor2 = 6;
int motor3 = 7;
int motor4 = 8;
int motor5 = 9;
int motor6 = 10;
int motor7 = 11;
int motor8 = 12;
int motor9 = 13; 


void setup() {
  Serial.begin(115200);
  //TIMSK0 = 0; // turn off timer0 for lower jitter (timer0 must be on for delay function to work properly)
  ADCSRA = 0xe5; // set the adc to free running mode
  ADMUX = 0x40; // use adc0
  //DIDR0 = 0x01; // turn off the digital input for adc0 (digital input must be on for user input in serial monitor)  
  
}


void loop() { 
  
  while(1) { // reduces jitter
    cli();  // UDRE interrupt slows this way down on arduino1.0
    for (int i = 0 ; i < FHT_N ; i++) { // save 256 samples
      while(!(ADCSRA & 0x10)); // wait for adc to be ready
      ADCSRA = 0xf4; // restart adc w/ prescale set to 16 (sampling rate: ~77kHz)
      byte m = ADCL; // fetch adc data
      byte j = ADCH;
      int k = (j << 8) | m; // form into an int
      k -= 0x0200; // form into a signed int
      k <<= 6; // form into a 16b signed int
      fht_input[i] = k; // put real data into bins 
      
    }
    
    fht_window(); // window the data for better frequency response
    fht_reorder(); // reorder the data before doing the fht
    fht_run(); // process the data in the fht
    fht_mag_log(); // take the output of the fht
    sei();

    //Serial.write(255); // send a start byte
    //Serial.write(fht_log_out, FHT_N/2); // send out the data
    

    
    if (fht_log_out[57] >= 120 & fht_log_out[57] < 256){
      int mag57 = fht_log_out[57];
      
      Serial.println("17 kHz");
      displaySetting1(mag57, motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9);
    }

    
    else if (fht_log_out[60] >= 110 & fht_log_out[60] < 256){
      int mag60 = fht_log_out[60];
      
      Serial.println("18 kHz");
      displaySetting2(mag60, motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9);
    }

    
    else if (fht_log_out[63] >= 100 & fht_log_out[63] < 256){
      int mag63 = fht_log_out[63];
      
      Serial.println("19 kHz");
      displaySetting3(mag63, motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9);
    }

    
    else if (fht_log_out[67] >= 80 & fht_log_out[67] < 256){
      int mag67 = fht_log_out[67];
      
      Serial.println("20 kHz");
      displaySetting4(mag67, motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9);
    }

    
    else if (fht_log_out[70] >= 80 & fht_log_out[70] < 256){
      int mag70 = fht_log_out[70];
      
      Serial.println("21 kHz");
      displaySetting5(mag70, motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9);
    }

    
    else{
      char user_input = 0;
      if (Serial.available() > 0) { // is a character available?
        user_input = Serial.read(); // get the character
        if (user_input = 't') {
          Serial.println("Motor Test");
          displaySetting6(motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9); 
         }
       }
      
        else{
          Serial.println("No detectable frequency");
          displaySetting0(motor1, motor2, motor3, motor4, motor5, motor6, motor7, motor8, motor9);
        }
      
    }

    
   
  }

}


//Tactile display functions

int displaySetting1(int mag57, int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){
    
    analogWrite(mtr2, (mag57 * 1.3));
    delay(150);
    analogWrite(mtr2, 0);
    delay(25);
    
    analogWrite(mtr5, (mag57 * 1.3));
    delay(150);
    analogWrite(mtr5, 0);
    delay(25);
    
    analogWrite(mtr8, (mag57 * 1.3));
    delay(150);
    analogWrite(mtr8, 0); 
    delay(200);
}

int displaySetting2(int mag60, int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){

    analogWrite(mtr3, (mag60 * 1.3));
    delay(150);
    analogWrite(mtr3, 0);
    delay(25);
    
    analogWrite(mtr5, (mag60 * 1.3));
    delay(150);
    analogWrite(mtr5, 0);
    delay(25);
    
    analogWrite(mtr7, (mag60 * 1.3));
    delay(150);
    analogWrite(mtr7, 0); 
    delay(200);   
}

int displaySetting3(int mag63, int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){

    analogWrite(mtr6, (mag63 * 1.3));
    delay(150);
    analogWrite(mtr6, 0);
    delay(25);
    
    analogWrite(mtr5, (mag63 * 1.3));
    delay(150);
    analogWrite(mtr5, 0);
    delay(25);
    
    analogWrite(mtr4, (mag63 * 1.3));
    delay(150);
    analogWrite(mtr4, 0); 
    delay(200);   
}

int displaySetting4(int mag67, int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){

    analogWrite(mtr9, (mag67 * 1.3));
    delay(150);
    analogWrite(mtr9, 0);
    delay(25);
    
    analogWrite(mtr5, (mag67 * 1.3));
    delay(150);
    analogWrite(mtr5, 0);
    delay(25);
    
    analogWrite(mtr1, (mag67 * 1.3));
    delay(150);
    analogWrite(mtr1, 0); 
    delay(200);   
}

int displaySetting5(int mag70, int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){

    analogWrite(mtr8, (mag70 * 1.3));
    delay(150);
    analogWrite(mtr8, 0);
    delay(25);
    
    analogWrite(mtr5, (mag70 * 1.3));
    delay(150);
    analogWrite(mtr5, 0);
    delay(25);
    
    analogWrite(mtr2, (mag70 * 1.3));
    delay(150);
    analogWrite(mtr2, 0); 
    delay(200);       
}

//Motor test function
int displaySetting6(int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){

    for(int mag=150; mag<250; mag+=25){
      analogWrite(mtr1, mag);
      delay(500);
      analogWrite(mtr1, 0);
      delay(50);  
      
      analogWrite(mtr2, mag);
      delay(500);
      analogWrite(mtr2, 0);
      delay(50);
      
      analogWrite(mtr3, mag);
      delay(500);
      analogWrite(mtr3, 0); 
      delay(50); 
  
      analogWrite(mtr4, mag);
      delay(500);
      analogWrite(mtr4, 0); 
      delay(50); 
  
      analogWrite(mtr5, mag);
      delay(500);
      analogWrite(mtr5, 0); 
      delay(50); 
  
      analogWrite(mtr6, mag);
      delay(500);
      analogWrite(mtr6, 0); 
      delay(50); 
  
      analogWrite(mtr7, mag);
      delay(500);
      analogWrite(mtr7, 0); 
      delay(50); 
  
      analogWrite(mtr8, mag);
      delay(500);
      analogWrite(mtr8, 0); 
      delay(50); 
  
      analogWrite(mtr9, mag);
      delay(500);
      analogWrite(mtr9, 0); 
      delay(500); 
    }     
}

//Inactivate all motors
int displaySetting0(int mtr1, int mtr2, int mtr3, int mtr4, int mtr5, int mtr6, int mtr7, int mtr8, int mtr9){

    analogWrite(mtr1, 0); 
    analogWrite(mtr2, 0); 
    analogWrite(mtr3, 0); 
    analogWrite(mtr4, 0); 
    analogWrite(mtr5, 0); 
    analogWrite(mtr6, 0); 
    analogWrite(mtr7, 0); 
    analogWrite(mtr8, 0); 
    analogWrite(mtr9, 0);
    delay(1000);     
}


