#include <SoftwareServo.h>  
#include <string.h>
#include <AF_Wave.h>
#include <avr/pgmspace.h>
#include "util.h"
#include "wave.h"
#include "WProgram.h"
void scan();
void setup();
void loop();
void playshoot(int i);
void playup(int i);
void playtilt(int i);
void playnum(int i);
void playfile(char *name);
SoftwareServo scannerServo;
SoftwareServo tiltServo;
SoftwareServo panServo;
//audio defines
AF_Wave card;
File f;
Wavefile wave; 
//analog pin defines
int rangepin = 0;
//digital pin defines
int eyepin = 3;
int laserpin = 4;
int tiltpin = 5;
int scanpin = 6;
int bluepin = 7;
int relaypin = 8;
int panpin = 9;
//global variables
int previous = 0;
int indicator = 0;
int distance = 0;  
int scan_angle = 90;
int prev_angle = 90;
int target_angle = 90;
int count = 0;
int soundcount = 0;
int shootcount = 1;
int upcount = 0;
int tiltcount = 0;
long fireuntil = 99999999;
long nextspeak = 10000;
int firing = 0;


char files[] = "0123456789";
/*
Begin scan method
*/
void scan()
{  
 if(firing == 1)
 {
   if (millis() > fireuntil)
   {
     firing = 0;
     digitalWrite(laserpin,LOW);
     digitalWrite(relaypin,LOW);
   }
 }
  distance = analogRead(rangepin);
  if(distance > 180)  //Object detected
  {
    if(firing == 0)
    {
      digitalWrite(laserpin,HIGH);
      digitalWrite(relaypin,HIGH);
      firing = 1;
      fireuntil = millis() + 1000;
    }
    target_angle = scan_angle;
    if(scan_angle < 180)
    {
    scan_angle++;
    }
  }
  else                  //Object not detected
  {
  if(scan_angle > 0 )   //turn right 
  {
    scan_angle -= 1; 
  }
  else                  //Reset
  {
    for(int q = scan_angle; q < 180; q++)
    {
    scannerServo.write(q);
    SoftwareServo::refresh();
    delay(2);  
    }
    scan_angle = 180;
  }  
  }
  if(count == 4)
  {
    count = 0;
  int angle = 180-(target_angle - 10);
  angle = ((90 - angle)*-1)/2;
  angle = angle + 100;
  if(prev_angle > angle)
  prev_angle--;
  else
  prev_angle++;
  }
  else
  count++;
  panServo.write(prev_angle);
  tiltServo.write(90);
  scannerServo.write(scan_angle);
  SoftwareServo::refresh();
 delay(2);
}
/********************************************************************************************************************
BEGIN SETUP
********************************************************************************************************************/
void setup()
{
  Serial.begin(9600);
  pinMode(17, OUTPUT);
  pinMode(18, OUTPUT);
  pinMode(19, OUTPUT);
  for(int i = 2; i < 6; i++)
  pinMode(i,OUTPUT);
   pinMode(bluepin, OUTPUT);
   pinMode(laserpin, OUTPUT);
   pinMode(eyepin, OUTPUT);
  pinMode(relaypin, OUTPUT);
  pinMode(rangepin, INPUT);
  scannerServo.attach(scanpin);
 scannerServo.setMaximumPulse(2500);
 tiltServo.attach(tiltpin);
 tiltServo.setMaximumPulse(2500);
  panServo.attach(panpin);
  panServo.setMaximumPulse(2500);
  delay(10);
    if (!card.init_card()) {
    putstring_nl("Card init. failed!"); return;
  }
  if (!card.open_partition()) {
    putstring_nl("No partition!"); return;
  }
  if (!card.open_filesys()) {
    putstring_nl("Couldn't open filesys"); return;
  }

 if (!card.open_rootdir()) {
    putstring_nl("Couldn't open dir"); return;
  }
}
/********************************************************************************************************************
END SETUP
BEGIN LOOP
********************************************************************************************************************/
uint16_t samplerate;
char filename[13];
void loop()
{ 
  for(int q = 0; q < 100; q++)
  {
    panServo.write(80);
    tiltServo.write(120);
    SoftwareServo::refresh();
    delay(2);  
  }
  digitalWrite(bluepin,HIGH);
  playfile("S.WAV");
  while (wave.isplaying) 
  {     
   }
   card.close_file(f);
   digitalWrite(bluepin,LOW);
  digitalWrite(eyepin,HIGH);
  int groundtilt = analogRead(2);
  int groundval = analogRead(1);
  while(1)
  {
    int val = analogRead(1);
int tilt = analogRead(2);
    while(val > (groundval + 20))
    {
      tilt = analogRead(2);
      val = analogRead(1);
      digitalWrite(laserpin,LOW);
       digitalWrite(relaypin,LOW);
       digitalWrite(eyepin,HIGH);
       digitalWrite(bluepin,HIGH);
       if(((groundtilt + 20) < tilt)||((groundtilt - 20) > tilt))
       {
         playtilt(tiltcount);
         tiltcount++;
       }
       else
       {
         playup(upcount);
       upcount++;
       }
       if(upcount >= 10)
       {
       upcount = 0;
       }  
       if(tiltcount >= 6)
       {
         tiltcount = 0;
       }
       nextspeak = millis() + 5000;
     }
       digitalWrite(bluepin,LOW);
    scan();
    if(millis() > nextspeak)
    {
       digitalWrite(laserpin,LOW);
       digitalWrite(relaypin,LOW);
       if(firing == 1)
       {
         playshoot(shootcount);
         shootcount++;
       }
       else
       {
      playnum(soundcount);
      soundcount++;
       }
       nextspeak = millis() + 5000;
       if(shootcount >= 5)
       {
         shootcount = 1;
       }
      if(soundcount >= 19)
      {
        soundcount = 0;
      }
    }
  }
}
/********************************************************************************************************************
END LOOP
********************************************************************************************************************/
void playshoot(int i)
{
        filename[0] = files[i];
      filename[1] = '.';
    filename[2] = 'W';
    filename[3] = 'A';
    filename[4] = 'V';
    filename[5] = 0;
      playfile(filename);
      samplerate = wave.dwSamplesPerSec;
      digitalWrite(bluepin,HIGH);
  while (wave.isplaying) 
  {     
  }
   digitalWrite(bluepin,LOW);
    card.close_file(f);
}
void playup(int i)
{
    filename[0] = files[9];
        filename[1] = files[i];
      filename[2] = '.';
    filename[3] = 'W';
    filename[4] = 'A';
    filename[5] = 'V';
    filename[6] = 0;
      playfile(filename);
      samplerate = wave.dwSamplesPerSec;
      digitalWrite(bluepin,HIGH);
  while (wave.isplaying) 
  {     
  }
   digitalWrite(bluepin,LOW);
    card.close_file(f);
}
void playtilt(int i)
{
    filename[0] = files[8];
        filename[1] = files[i];
      filename[2] = '.';
    filename[3] = 'W';
    filename[4] = 'A';
    filename[5] = 'V';
    filename[6] = 0;
      playfile(filename);
      samplerate = wave.dwSamplesPerSec;
      digitalWrite(bluepin,HIGH);
  while (wave.isplaying) 
  {     
  }
   digitalWrite(bluepin,LOW);
    card.close_file(f);
}
void playnum(int i)
{
    int a = 2;
      if(i < 10)
      {
        filename[0] = '0';
        filename[1] = files[i];
      }
      else
      {
        a = 2;
        filename[0] = '1';
        filename[1] = files[i-10];
      }
      filename[a] = '.';
    filename[a+1] = 'W';
    filename[a+2] = 'A';
    filename[a+3] = 'V';
    filename[a+4] = 0;
      playfile(filename);
      samplerate = wave.dwSamplesPerSec;
      digitalWrite(bluepin,HIGH);
  while (wave.isplaying) 
  {     
  }
   digitalWrite(bluepin,LOW);
    card.close_file(f);
}

void playfile(char *name) {
Serial.println(name);
   f = card.open_file(name);
   if (!f) {
      putstring_nl(" Couldn't open file"); return;
   }
   if (!wave.create(f)) {
     putstring_nl(" Not a valid WAV"); return;
   }
   wave.play();
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

