/**
 This sketch displays svg slices use with long-exposure photography. 
 The mouse advances the slides, and space controls automatic advancing. Alternatively, basic network control can be implemented with Processing's net library. 
 
 2016 - BenandMattMakeThings
 */

PShape[] svgs = new PShape[48];

int id = 0;

boolean on = false;

int command = 0;

boolean automatic = false;

int automaticTiming = 500;

int lastChange = 0;

public void setup() {
  size(1280, 1024);

  noCursor();

  //setupServer();

  for (int i = 0; i < svgs.length; i++) {
    svgs[i] = loadShape("data/cathedral_" + i + ".svg");
  }

  command = 1;
  lastChange = millis();

  //exportFrames();
}

public void draw() {
  background(0);
  //checkServer();

  svgs[id].disableStyle();
  stroke(255);
  fill(100);
  strokeWeight(3);

  if (on) shape(svgs[id], 200, 100);

  if (automatic) {
    if (millis() - lastChange > automaticTiming) {
      command = 1;
      receiveCommand();
      lastChange = millis();
    }
  }
}

public void receiveCommand() {
  if (command == 0) {
    on = false;
  } else if (command == 1) {
    id++;
    id %= svgs.length;
    on = true;
  }
}


public void mousePressed() {
  command = 1;
  receiveCommand();
}

public void keyPressed() {
  if (key == ' ') automatic = !automatic;
}



public void exportFrames() {
  for (int i = 0; i < svgs.length; i++) {
    background(0);
    stroke(255);
    noFill();
    fill(100);
    strokeWeight(3);
    svgs[i].disableStyle();
    shape(svgs[i], 200, 100);
    save("frames/frame" + String.format ("%03d", i) + ".png");
  }
}