/******************************** (C) COPYRIGHT 2016 Seven ********************************
* @Function:    USART For STM8
* @Author:      Seven
* @Data:        2016/01/21
* @Version Log:
* -----------------------------------------------------------------------------------------
* 2016/01/21  V1.0  Seven  
******************************************************************************************/
#include "usart.h"

#include "fifo.h"

uint8_t UsartBuff[32];

FIFO_TypeDef USART1_Buff;

/******************************************************************************************
* @Function:    USART1 Init
* @Parameter:   [BuadRate]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
void USART1_Init(uint32_t BuadRate)
{
    UART1_DeInit();
    UART1_Init(BuadRate, UART1_WORDLENGTH_8D, UART1_STOPBITS_1, UART1_PARITY_NO,
               UART1_SYNCMODE_CLOCK_DISABLE, UART1_MODE_TXRX_ENABLE);
    UART1_ITConfig(UART1_IT_RXNE_OR, ENABLE);
    UART1_Cmd(ENABLE);
    
    FIFO_Create(&USART1_Buff, UsartBuff, 32);
}

/******************************************************************************************
* @Function:    USART1_FIFO_In
* @Parameter:   [Data]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
void USART1_FIFO_In(uint8_t Data)
{
    FIFO_In(&USART1_Buff, &Data, UINT8_T);
}

/******************************************************************************************
* @Function:    USART1_FIFO_In
* @Parameter:   [Data]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
uint8_t USART1_FIFO_Out(void)
{
    uint8_t Data = 0;
    FIFO_Out(&USART1_Buff, &Data, UINT8_T);
    return Data;
}

/******************************************************************************************
* @Function:    USART1 Send Data
* @Parameter:   [Data]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
uint8_t UART1_SendByte(uint8_t Data)
{
    uint16_t TimeOut = 0;
    UART1_SendData8(Data);
    while (UART1_GetFlagStatus(UART1_FLAG_TXE) == RESET)
    {
        if(TimeOut++ > 20000)
        {
            return 1;   //Send Data TimeOut
        }
    }
    return 0;
}

/******************************************************************************************
* @Function:    USART1 Send String
* @Parameter:   [pString]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
uint8_t UART1_SendStr(uint8_t* str)
{
    uint8_t err = 0;
    while (*str != '\0')
    {
        err += UART1_SendByte(*str);
        str++;
    }
    return err;
}



/******************************** (C) COPYRIGHT 2016 Seven *******************************/
