/******************************** (C) COPYRIGHT 2016 Seven ********************************
* @Function:    Timer For STM8
* @Author:      Seven
* @Data:        2016/01/21
* @Version Log:
* -----------------------------------------------------------------------------------------
* 2016/01/21  V1.0  Seven  
******************************************************************************************/
#include "timer.h"

#include "stm8s_tim4.h"     //systick
#include "stm8s_tim2.h"

uint32_t Systick = 0;

/******************************************************************************************
* @Function:    Systick Init
* @Parameter:   [ʱƵֵ][]
* @Return:      [None]
* @Notes:       ʹ8bit ʱ4Ϊsystickļ
*******************************************************************************************/
void Systick_Init(TIM4_Prescaler_TypeDef Prescaler, uint8_t Period)
{
    TIM4_TimeBaseInit(Prescaler, Period);
    TIM4_PrescalerConfig(Prescaler, TIM4_PSCRELOADMODE_IMMEDIATE);
    //Զ
    TIM4_ARRPreloadConfig(ENABLE);
    //жʹ
    TIM4_ITConfig(TIM4_IT_UPDATE, ENABLE);
    //ʱʹ
    TIM4_Cmd(ENABLE);
}

/******************************************************************************************
* @Function:    Systick_GetCounter
* @Parameter:   [None]
* @Return:      [Systick Counter]
* @Notes:       
*******************************************************************************************/
uint32_t Systick_GetCounter(void)
{
    return Systick;
}

/******************************************************************************************
* @Function:    delay_ms
* @Parameter:   [ms]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
void delay_ms(uint32_t t)
{
    t += Systick;
    while (t >= Systick);
}

/******************************************************************************************
* @Function:    Timer2 Init
* @Parameter:   [ʱƵֵ][]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
void TIM2_Init(TIM2_Prescaler_TypeDef TIM2_Prescaler, uint16_t TIM2_Period)
{
    //ʱ16Ƶ 999 + 1
    TIM2_TimeBaseInit(TIM2_Prescaler, TIM2_Period);
    //
    TIM2_PrescalerConfig(TIM2_Prescaler, TIM2_PSCRELOADMODE_IMMEDIATE);
    //Զ
    TIM2_ARRPreloadConfig(ENABLE);
    //жʹ
    TIM2_ITConfig(TIM2_IT_UPDATE, ENABLE);
    //ʱʹ
    TIM2_Cmd(ENABLE);
}

/******************************************************************************************
* @Function:    TIM2 PWM Init
* @Parameter:   [ʱƵֵ][]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
void TIM2_PWM_Init(uint8_t CHx, TIM2_Prescaler_TypeDef Prescaler,
                   TIM2_OCPolarity_TypeDef Polar, uint16_t Period, uint16_t Pulse)
{
    //ʱƵ
    TIM2_TimeBaseInit(Prescaler, Period);
    //PWM
    if(CHx == 1)
    {
        TIM2_OC1Init(TIM2_OCMODE_PWM1, TIM2_OUTPUTSTATE_ENABLE, Pulse, Polar);
        TIM2_OC1PreloadConfig(ENABLE);
    }
    else if(CHx == 2)
    {
        TIM2_OC2Init(TIM2_OCMODE_PWM1, TIM2_OUTPUTSTATE_ENABLE, Pulse, Polar);
        TIM2_OC2PreloadConfig(ENABLE);
    }
    else if(CHx == 3)
    {
        TIM2_OC3Init(TIM2_OCMODE_PWM1, TIM2_OUTPUTSTATE_ENABLE, Pulse, TIM2_OCPOLARITY_HIGH);
        TIM2_OC3PreloadConfig(ENABLE);
    }
    //ʱʹ
    TIM2_Cmd(ENABLE);
}

/******************************************************************************************
* @Function:    TIM2 PWM Set
* @Parameter:   [ռձ]
* @Return:      [None]
* @Notes:       
*******************************************************************************************/
void TIM2_PWM_Set(uint8_t CHx, uint16_t Pulse)
{
   if(CHx == 1)
    {
        TIM2->CCR1H = (uint8_t)(Pulse >> 8);
        TIM2->CCR1L = (uint8_t)(Pulse);
    }
    else if(CHx == 2)
    {
        TIM2->CCR2H = (uint8_t)(Pulse >> 8);
        TIM2->CCR2L = (uint8_t)(Pulse);
    }
    else if(CHx == 3)
    {
        TIM2->CCR3H = (uint8_t)(Pulse >> 8);
        TIM2->CCR3L = (uint8_t)(Pulse);
        TIM2_OC3PreloadConfig(ENABLE);
    }
}

/******************************** (C) COPYRIGHT 2016 Seven *******************************/
