/******************** (C) COPYRIGHT  iCreateǶʽ **************
 * ļ  sysclock.c
 *     ϵͳʱ   
 * ʵƽ̨STM8
 * 汾  V2.1.0
 *       QQ779814207
 *     
 * Ա    http://shop71177993.taobao.com/
 *޸ʱ 2012-11-9

*******************************************************************************/

/* ϵͳͷļ */

/* Զͷļ */
#include "sysclock.h"
static void HSE_ClockStartUpConfiguration(HSE_Clock_TypeDef HSE_Clock,HSE_ClockStartUpTime_TypeDef HSE_ClockStartUpTime);
/* Զ */

/* Զ */
#define DEBUG
/*******************************************************************************
 * : HSE_ClockStartUpConfiguration
 * : ʱӵѡ񣬿ʵⲿʱл
 * β: HSE_Clock ⲿʱ͵ѡ
         HSE_ClockStartUpTime ⲿʱȶʱ
 * : 
 * ˵: ⲿʱǴ16MHzflashҪһȴ
         Сڻߵ16MHzҪ
         Щдflash,һμ,ڵԵʱм
               
 ******************************************************************************/
static void HSE_ClockStartUpConfiguration(HSE_Clock_TypeDef HSE_Clock,HSE_ClockStartUpTime_TypeDef HSE_ClockStartUpTime)
{
  FLASH_Unlock(FLASH_MEMTYPE_DATA);/*ҪѡֽдҪȽFLASH*/
  while(!(FLASH->IAPSR & FLASH_IAPSR_DUL));/*ȴ*/
 /*ⲿʱǴ16MHzСڵ24MHz,flashҪһȴڣСڻߵ16MHzҪ*/
  if(HSE_Clock==HSE_24MHz)   
  FLASH_ProgramOptionByte(FLASH_WAIT_STATES_ADDRESS,HSE_Clock);
  FLASH_ProgramOptionByte(HSE_CLOCK_STARTUP_ADDRESS,HSE_ClockStartUpTime);
  /*ⲿʱȶ*/
  FLASH_Lock(FLASH_MEMTYPE_DATA);/*Ҫ*/
    
}
/*******************************************************************************
 * : DefaultSystemClockForHSI
 * : ָĬHSIܵ
 * β:      
 * : 
 * ˵: Щдflash,һμ,ڵԵʱм
 ******************************************************************************/
void DefaultSystemClockForHSI(void)
{
  FLASH_Unlock(FLASH_MEMTYPE_DATA);/*ҪѡֽдҪȽFLASH*/
  while(!(FLASH->IAPSR & FLASH_IAPSR_DUL));/*ȴ*/
  FLASH_EraseOptionByte(FLASH_WAIT_STATES_ADDRESS);/*ָHSIʱ*/
  FLASH_EraseOptionByte(HSE_CLOCK_STARTUP_ADDRESS);
  FLASH_Lock(FLASH_MEMTYPE_DATA);/*Ҫ*/
}


/*******************************************************************************
 * : Sysclock_Init
 * : ϵͳʱƵ
 * β: 
 * : 
 * ˵: ʱѡ
         ѡⲿ24MHzʱӵģⲿ24MĻ
         #define HSE_24M  HSE_VALUEע͵,
         Ҫлⲿʱӣ#define __HSE_VALUE  HSE_VALUE
         ע͵
 ******************************************************************************/
void SystemClock_Init(SystemClock_TypeDef sysclk)
{

   if(sysclk==HSE_Clock)/*ѡⲿʱ*/
   {
     #ifdef DEBUG
     HSE_ClockStartUpConfiguration(HSE_24MHz,HSECNT_8CLK);
     #endif
     while (!CLK_ClockSwitchConfig(CLK_SWITCHMODE_AUTO, CLK_SOURCE_HSE, DISABLE,\
            CLK_CURRENTCLOCKSTATE_DISABLE));
     /*лⲿʱ,ȴʱȴɹ*/
   }
   else 
   {
     #ifdef DEBUG
     DefaultSystemClockForHSI();
     #endif
     CLK_HSIPrescalerConfig(CLK_PRESCALER_HSIDIV1);
   }

}


/******************* (C) COPYRIGHT iCreateǶʽ *****END OF FILE****/