/******************************** (C) COPYRIGHT 2016 Seven ********************************
* @Function:    STM8
* @Author:      Seven
* @Data:        2016/01/20
* @Version Log:
* -----------------------------------------------------------------------------------------
* 2016/01/20  V1.0  Seven   
******************************************************************************************/

#include "stm8s.h"
#include "usart.h"
#include "timer.h"
#include "stm8s_exti.h"
#include "stm8s_adc1.h"

/******************************************************************************************
* @Description:
******************************************************************************************/
//ӿ
#define KEY_PORT                        (GPIOC)
#define KEY_LIGHT_FN                    (GPIO_PIN_5)    //Ӱ
#define KEY_LIGHT_ON                    (GPIO_PIN_6)    //⿪
#define KEY_LIGHT_ADJ                   (GPIO_PIN_7)    //

#define LED_PORT                        (GPIOA)
#define LED_LOW_POWER                   (GPIO_PIN_3)    //ָʾ

#define LIGHT_LEVEL                     (1)             //仯

//ذ±־
volatile uint8_t  IsKeyDown = 0;
//⿪ر־
uint8_t  IsLightOn = 0;
//[0-500]ԽԽ
uint16_t Light = 200;
//͵־
uint8_t  IsBatteryLow = 0;


/******************************************************************************************
* @Function:    Delay
* @Parameter:   [None]
* @Return:      [None]
* @Description:
*******************************************************************************************/
void delay(unsigned int i)
{
    while(i--);
}

/******************************************************************************************
* @Function:    PowerDown
* @Parameter:   [None]
* @Return:      [None]
* @Description:
*******************************************************************************************/
void System_PowerDown(void)
{
    //رյָʾ
    LED_PORT->ODR = LED_LOW_POWER;
    //LPVR͹ѹ
    CLK_SlowActiveHaltWakeUpCmd(ENABLE);
    //رFLASH
    FLASH->CR1 |= 0x04;
    //ͣģʽⲿжϻ
    halt();
}

/******************************************************************************************
* @Function:    GPIO Config
* @Parameter:   [None]
* @Return:      [None]
* @Description:
*******************************************************************************************/
void GPIO_Config(void)
{
    //LED
    GPIO_Init(LED_PORT, LED_LOW_POWER, GPIO_MODE_OUT_PP_LOW_FAST);
    LED_PORT->ODR = LED_LOW_POWER;
    
    //GPIO_Init(GPIOD,GPIO_PIN_3,GPIO_MODE_OUT_PP_LOW_FAST);
    //GPIOD->ODR = GPIO_PIN_3;
    
    //key 
    GPIO_Init(KEY_PORT, KEY_LIGHT_ON, GPIO_MODE_IN_PU_IT);       
    EXTI_SetExtIntSensitivity(EXTI_PORT_GPIOC, EXTI_SENSITIVITY_FALL_ONLY);
    
    GPIO_Init(KEY_PORT, KEY_LIGHT_ADJ, GPIO_MODE_IN_PU_NO_IT);
}

/******************************************************************************************
* @Function:    BatteryCheck
* @Parameter:   [None]
* @Return:      [Battery State:0->Normal 1->Low]
* @Description:
*******************************************************************************************/
uint8_t BatteryCheck(void)
{
    uint16_t ADC_Value = 0;
    uint8_t i;
    
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_ADC, ENABLE);
    ADC1_DeInit();
    ADC1_Init(ADC1_CONVERSIONMODE_SINGLE , ADC1_CHANNEL_2, ADC1_PRESSEL_FCPU_D18,\
    ADC1_EXTTRIG_TIM, DISABLE, ADC1_ALIGN_RIGHT, ADC1_SCHMITTTRIG_CHANNEL2, DISABLE);
    
    ADC1_Cmd(ENABLE);

    for(i = 0; i < 10; i++)
    {
        ADC1_StartConversion();
        delay(20);
        ADC_Value += ADC1_GetConversionValue();
    }
    //رADCʡ
    ADC1_Cmd(DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_ADC, DISABLE);
    
    ADC_Value = ADC_Value / 10;
    
    // UART1_SendByte(ADC_Value/1000 + 0x30);
    // UART1_SendByte(ADC_Value%1000/100 + 0x30);
    // UART1_SendByte(ADC_Value%100/10 + 0x30);
    // UART1_SendByte(ADC_Value%10 + 0x30);
    // UART1_SendByte('\n');
    
    //3.3ο/1024λ*520*2ѹ=3.3V
    if(ADC_Value < 520)//ͣǿƹر
    {
        i = 40;
        while(i--)  //˸20
        {
            LED_PORT->ODR ^= LED_LOW_POWER;
            delay(200);
        }
        //ģʽ
        System_PowerDown();
    }
    //3.5V,͵
    if(ADC_Value > 520 && ADC_Value < 545)return 1;
    //
    return 0;
}

/******************************************************************************************
* @Function:    Key_Scan
* @Parameter:   [Key Name]
* @Return:      [Key State]
* @Description:
*******************************************************************************************/
uint8_t Key_Scan(GPIO_Pin_TypeDef KeyName)
{
    if(GPIO_ReadInputPin(KEY_PORT, KeyName) == 0) //⵽аˣIOڵѹᱻ  
    {  
        delay(10);    
        if(GPIO_ReadInputPin(KEY_PORT, KeyName) == 0) //Ȼڵ͵ƽ  
        {   
           return 1;               
        }                      
    }
    return 0;
}

/******************************************************************************************
* @Function:    LightControl
* @Parameter:   [None]
* @Return:      [None]
* @Description:
*******************************************************************************************/
void LightControl(uint8_t State)
{
    uint16_t temp = 0;
    if(State)   //
    {
        while(temp < Light)
        {
            temp += LIGHT_LEVEL;
            TIM2_PWM_Set(2, temp);
            delay(150);
        }
        TIM2_PWM_Set(2, Light);
    }
    else
    {
        temp = Light;
        while(temp > 0)
        {
            temp -= LIGHT_LEVEL;
            TIM2_PWM_Set(2, temp);
            delay(30);
        }
        TIM2_PWM_Set(2, 0);
        //ͣģʽ
        System_PowerDown();
    }
}

/******************************************************************************************
* @Function:    SystemInit
* @Parameter:   [None]
* @Return:      [None]
* @Description:
*******************************************************************************************/
void SystemInit(void)
{
    //ʹж
    __enable_interrupt();
    //ڲHSIƵF_Master
    CLK_HSIPrescalerConfig(CLK_PRESCALER_HSIDIV8);  //16/8=2MHZ
    //CPUƵ,F_CPU
    CLK_SYSCLKConfig(CLK_PRESCALER_CPUDIV64);  //2/64
    //TIM4ϵͳ1msһ
    //Systick_Init(TIM4_PRESCALER_2, 100);  //2/2=1MHZ * 10-> 10MS
    //رղҪ裬ʡ
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_I2C, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_SPI, DISABLE);
    //STM8S003F33Ǵ1
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_UART2, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_UART3, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER6, DISABLE);
    //STM8S003F3ʱ5ҲǶʱ2˲ܹر
    // CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER5, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER4, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER3, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER1, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_AWU, DISABLE);
    CLK_PeripheralClockConfig(CLK_PERIPHERAL_CAN, DISABLE);

}

/******************************************************************************************
* @Function:    Main
* @Parameter:   [None]
* @Return:      [None]
* @Description:
*******************************************************************************************/void main(void)
{
    int16_t Level = 10;
    uint32_t Timer = 0;

    SystemInit();
    
    GPIO_Config();
    
    //USART1_Init(115200);
    
    //տΪ0
    TIM2_PWM_Init(2, TIM2_PRESCALER_32, TIM2_OCPOLARITY_HIGH, 500, 0);
    while (1)
    {
        //ư
        if( IsKeyDown )
        {
            IsLightOn = !IsLightOn;
            //⻺򿪻ر
            LightControl( IsLightOn );
            IsKeyDown = 0;
        }
        
        //˱⣬ұڰ
        if(IsLightOn)
        {
            if( Key_Scan(KEY_LIGHT_ADJ) )
            {
                //ȴ̧
                while(GPIO_ReadInputPin(KEY_PORT, KEY_LIGHT_ADJ) == 0)
                {
                    if(Light == 500){Level = -LIGHT_LEVEL;delay(500);}
                    if(Light == 0){Level = LIGHT_LEVEL;delay(500);}
                    Light += Level;
                    TIM2_PWM_Set(2, Light);
                    delay(10); 
                }
            }
        }
        
        //ԼһӼһεصѹ
        if(Timer % 4000 == 0)
        {
            IsBatteryLow = BatteryCheck();
        }
        
        //͵ʱÿ3˸һ
        if( IsBatteryLow )
        {
            if(Timer % 200 == 1)LED_PORT->ODR ^= LED_LOW_POWER;
        }
        
        Timer++;
        delay(10);
    }
  
}

#ifdef USE_FULL_ASSERT
void assert_failed(u8* file, u32 line)
{ 
    while (1)
    {
    }
}
#endif


/******************************** (C) COPYRIGHT 2016 Seven ********************************/
