/******************************** (C) COPYRIGHT 2016 Seven ********************************
* @Function:    Timer For STM8
* @Author:      Seven
* @Data:        2016/01/21
* @Version Log:
* -----------------------------------------------------------------------------------------
* 2016/01/21  V1.0  Seven  
******************************************************************************************/
#ifndef __TIMER_H
#define __TIMER_H

#include "stm8s.h"

/******************************************************************************************
* @Description:Timer Var
*******************************************************************************************/
extern uint32_t Systick;

/******************************************************************************************
* @Description:USART API
*******************************************************************************************/
void Systick_Init(TIM4_Prescaler_TypeDef Prescaler, uint8_t Period);
uint32_t Systick_GetCounter(void);
void delay_ms(uint32_t t);

void TIM2_Init(TIM2_Prescaler_TypeDef TIM2_Prescaler, uint16_t TIM2_Period);
void TIM2_PWM_Init(uint8_t CHx, TIM2_Prescaler_TypeDef Prescaler,
                   TIM2_OCPolarity_TypeDef Polar, uint16_t Period, uint16_t Pulse);
void TIM2_PWM_Set(uint8_t CHx, uint16_t Pulse);

#endif
